/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

public class StringUtil {
    public static boolean isWhitespace(char charCode) {
        return Character.isWhitespace(charCode) || Character.getType(charCode) == 12;
    }

    public static boolean isWhitespace(int charCode) {
        return Character.isWhitespace(charCode) || Character.getType(charCode) == 12;
    }

    public static String toLowerCase(CharSequence string) {
        int[] cp = string.codePoints().map(Character::toLowerCase).toArray();
        return new String(cp, 0, cp.length);
    }

    public static String toUpperCase(CharSequence string) {
        char[] upperCaseChars = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            upperCaseChars[i] = Character.toUpperCase(string.charAt(i));
        }
        return new String(upperCaseChars);
    }

    public static boolean isEmpty(CharSequence theString) {
        return theString.length() == 0;
    }

    private static int minimum(int a, int b, int c) {
        int minValue = a;
        if (b < minValue) {
            minValue = b;
        }
        if (c < minValue) {
            minValue = c;
        }
        return minValue;
    }

    public static int[][] levenshteinDistance(String wordForm, String lemma) {
        int i;
        int wordLength = wordForm.length();
        int lemmaLength = lemma.length();
        int[][] distance = new int[wordLength + 1][lemmaLength + 1];
        if (wordLength == 0) {
            return distance;
        }
        if (lemmaLength == 0) {
            return distance;
        }
        for (i = 0; i <= wordLength; ++i) {
            distance[i][0] = i;
        }
        for (int j = 0; j <= lemmaLength; ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= wordLength; ++i) {
            char s_i = wordForm.charAt(i - 1);
            for (int j = 1; j <= lemmaLength; ++j) {
                int cost = s_i == lemma.charAt(j - 1) ? 0 : 1;
                distance[i][j] = StringUtil.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + cost);
            }
        }
        return distance;
    }

    public static void computeShortestEditScript(String wordForm, String lemma, int[][] distance, StringBuffer permutations) {
        int n = distance.length;
        int m = distance[0].length;
        int wordFormLength = n - 1;
        int lemmaLength = m - 1;
        while (distance[wordFormLength][lemmaLength] != 0) {
            if (lemmaLength > 0 && wordFormLength > 0 && distance[wordFormLength - 1][lemmaLength - 1] < distance[wordFormLength][lemmaLength]) {
                permutations.append('R').append(Integer.toString(wordFormLength - 1)).append(wordForm.charAt(wordFormLength - 1)).append(lemma.charAt(lemmaLength - 1));
                --lemmaLength;
                --wordFormLength;
                continue;
            }
            if (lemmaLength > 0 && distance[wordFormLength][lemmaLength - 1] < distance[wordFormLength][lemmaLength]) {
                permutations.append('I').append(Integer.toString(wordFormLength)).append(lemma.charAt(lemmaLength - 1));
                --lemmaLength;
                continue;
            }
            if (wordFormLength > 0 && distance[wordFormLength - 1][lemmaLength] < distance[wordFormLength][lemmaLength]) {
                permutations.append('D').append(Integer.toString(wordFormLength - 1)).append(wordForm.charAt(wordFormLength - 1));
                --wordFormLength;
                continue;
            }
            if (wordFormLength > 0 && lemmaLength > 0 && distance[wordFormLength - 1][lemmaLength - 1] == distance[wordFormLength][lemmaLength]) {
                --wordFormLength;
                --lemmaLength;
                continue;
            }
            if (wordFormLength > 0 && distance[wordFormLength - 1][lemmaLength] == distance[wordFormLength][lemmaLength]) {
                --wordFormLength;
                continue;
            }
            if (lemmaLength <= 0 || distance[wordFormLength][lemmaLength - 1] != distance[wordFormLength][lemmaLength]) continue;
            --lemmaLength;
        }
    }

    public static String decodeShortestEditScript(String wordForm, String permutations) {
        StringBuffer lemma = new StringBuffer(wordForm).reverse();
        int permIndex = 0;
        while (permutations.length() > permIndex) {
            int charIndex;
            String charAtPerm;
            char nextOperation = permutations.charAt(permIndex);
            ++permIndex;
            if (nextOperation == 'R') {
                charAtPerm = Character.toString(permutations.charAt(permIndex));
                charIndex = Integer.parseInt(charAtPerm);
                char replace = permutations.charAt(++permIndex);
                char with = permutations.charAt(++permIndex);
                if (lemma.length() <= charIndex) {
                    return wordForm;
                }
                if (lemma.charAt(charIndex) == replace) {
                    lemma.setCharAt(charIndex, with);
                }
                ++permIndex;
                continue;
            }
            if (nextOperation == 'I') {
                charAtPerm = Character.toString(permutations.charAt(permIndex));
                charIndex = Integer.parseInt(charAtPerm);
                char in = permutations.charAt(++permIndex);
                if (lemma.length() < charIndex) {
                    return wordForm;
                }
                lemma.insert(charIndex, in);
                ++permIndex;
                continue;
            }
            if (nextOperation != 'D') continue;
            charAtPerm = Character.toString(permutations.charAt(permIndex));
            charIndex = Integer.parseInt(charAtPerm);
            if (lemma.length() <= charIndex) {
                return wordForm;
            }
            lemma.deleteCharAt(charIndex);
            ++permIndex;
            ++permIndex;
        }
        return lemma.reverse().toString();
    }

    public static String getShortestEditScript(String wordForm, String lemma) {
        String ses;
        String reversedWF = new StringBuffer(wordForm.toLowerCase()).reverse().toString();
        String reversedLemma = new StringBuffer(lemma.toLowerCase()).reverse().toString();
        StringBuffer permutations = new StringBuffer();
        if (!reversedWF.equals(reversedLemma)) {
            int[][] levenDistance = StringUtil.levenshteinDistance(reversedWF, reversedLemma);
            StringUtil.computeShortestEditScript(reversedWF, reversedLemma, levenDistance, permutations);
            ses = permutations.toString();
        } else {
            ses = "O";
        }
        return ses;
    }
}

