/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0049_privatedata;

import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.Renderer;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.extension.xep0049_privatedata.PrivateDataPersistenceManager;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;

public class PrivateDataIQHandler
extends DefaultIQHandler {
    protected PrivateDataPersistenceManager persistenceManager;

    public void setPersistenceManager(PrivateDataPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "jabber:iq:private");
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "query");
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        String queryContent;
        Entity to = stanza.getTo();
        Entity from = stanza.getFrom();
        if (from == null) {
            from = sessionContext.getInitiatingEntity();
        }
        if (to != null && !to.getBareJID().equals(sessionContext.getInitiatingEntity().getBareJID())) {
            return ServerErrorResponses.getStreamError(StreamErrorCondition.BAD_FORMAT, null, "Private data only modifiable by the owner", null);
        }
        XMLElement queryElement = stanza.getFirstInnerElement();
        if (queryElement.getInnerElements().size() != 1) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.NOT_ACCEPTABLE, stanza, StanzaErrorType.MODIFY, "query's child element is missing", null, null);
        }
        XMLElement x = queryElement.getFirstInnerElement();
        String ns = x.getAttribute("xmlns").getValue();
        if (ns == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.NOT_ACCEPTABLE, stanza, StanzaErrorType.MODIFY, "no namespace", null, null);
        }
        if (this.persistenceManager == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.INTERNAL_SERVER_ERROR, stanza, StanzaErrorType.WAIT, "internal storage inaccessible", null, null);
        }
        String queryKey = this.getKey(x);
        boolean success = this.persistenceManager.setPrivateData(from, queryKey, queryContent = new Renderer(queryElement).getComplete());
        if (success) {
            return (Stanza)StanzaBuilder.createIQStanza(null, from, IQStanzaType.RESULT, stanza.getID()).build();
        }
        return (Stanza)StanzaBuilder.createIQStanza(null, from, IQStanzaType.ERROR, stanza.getID()).build();
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity to = stanza.getTo();
        Entity from = stanza.getFrom();
        if (from == null) {
            from = sessionContext.getInitiatingEntity();
        }
        if (to != null && !to.getBareJID().equals(sessionContext.getInitiatingEntity().getBareJID())) {
            return ServerErrorResponses.getStreamError(StreamErrorCondition.BAD_FORMAT, null, "can only view your data", null);
        }
        XMLElement queryElement = stanza.getFirstInnerElement();
        XMLElement x = queryElement.getFirstInnerElement();
        if (x == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.NOT_ACCEPTABLE, stanza, StanzaErrorType.MODIFY, "query's child element missing", null, null);
        }
        if (this.persistenceManager == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.INTERNAL_SERVER_ERROR, stanza, StanzaErrorType.WAIT, "internal storage inaccessible", null, null);
        }
        String queryKey = this.getKey(x);
        String privateDataXML = this.persistenceManager.getPrivateData(from, queryKey);
        StanzaBuilder stanzaBuilder = StanzaBuilder.createIQStanza(stanza.getTo(), stanza.getFrom(), IQStanzaType.RESULT, stanza.getID());
        if (privateDataXML == null) {
            stanzaBuilder.startInnerElement(x.getName(), x.getNamespaceURI());
            for (Attribute a : x.getAttributes()) {
                stanzaBuilder.addAttribute(a);
            }
            stanzaBuilder.endInnerElement();
        } else {
            stanzaBuilder.addText(privateDataXML);
        }
        return (Stanza)stanzaBuilder.build();
    }

    private String getKey(XMLElement x) {
        StringBuilder queryKey = new StringBuilder();
        queryKey.append(x.getName());
        queryKey.append("-");
        queryKey.append(x.getAttribute("xmlns").getValue());
        for (int i = 0; i < queryKey.length(); ++i) {
            char c = queryKey.charAt(i);
            if (c != ' ' && c != ':') continue;
            queryKey.setCharAt(i, '-');
        }
        return queryKey.toString();
    }
}

