/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.apache.jackrabbit.core.observation.EventConsumer;

class EventListenerIteratorImpl
implements EventListenerIterator {
    private final Session session;
    private final Iterator consumers;
    private EventListener next;
    private long pos = 0L;

    EventListenerIteratorImpl(Session session, Collection sConsumers, Collection aConsumers) throws NullPointerException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (sConsumers == null) {
            throw new NullPointerException("consumers");
        }
        if (aConsumers == null) {
            throw new NullPointerException("consumers");
        }
        this.session = session;
        ArrayList allConsumers = new ArrayList(sConsumers);
        allConsumers.addAll(aConsumers);
        this.consumers = allConsumers.iterator();
        this.fetchNext();
    }

    public EventListener nextEventListener() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        EventListener l = this.next;
        this.fetchNext();
        ++this.pos;
        return l;
    }

    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    public long getSize() {
        return -1L;
    }

    public long getPosition() {
        return this.pos;
    }

    public void remove() {
        throw new UnsupportedOperationException("EventListenerIterator.remove()");
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextEventListener();
    }

    private void fetchNext() {
        this.next = null;
        while (this.next == null && this.consumers.hasNext()) {
            EventConsumer consumer = (EventConsumer)this.consumers.next();
            if (!consumer.getSession().equals(this.session)) continue;
            this.next = consumer.getEventListener();
        }
    }
}

