/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIOutput;
import javax.faces.component._ComponentUtils;
import javax.faces.component._MessageUtils;
import javax.faces.component._SharedRendererUtils;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    private static final String DEFAULT_RENDERER_TYPE = "javax.faces.Text";
    private static final boolean DEFAULT_IMMEDIATE = false;
    private static final boolean DEFAULT_REQUIRED = false;
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    private static final String ERROR_HANDLING_EXCEPTION_LIST = "org.apache.myfaces.errorHandling.exceptionList";
    private static final Validator[] EMPTY_VALIDATOR_ARRAY = new Validator[0];
    private Boolean _immediate = null;
    private Boolean _required = null;
    private Object _submittedValue = null;
    private boolean _localValueSet = false;
    private boolean _valid = true;
    private MethodBinding _validator = null;
    private MethodBinding _valueChangeListener = null;
    private List _validatorList = null;

    public Object getSubmittedValue() {
        return this._submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this._submittedValue = submittedValue;
    }

    public void setValue(Object value) {
        this.setLocalValueSet(true);
        super.setValue(value);
    }

    public Object getValue() {
        if (this.isLocalValueSet()) {
            return super.getLocalValue();
        }
        return super.getValue();
    }

    public boolean isLocalValueSet() {
        return this._localValueSet;
    }

    public void setLocalValueSet(boolean localValueSet) {
        this._localValueSet = localValueSet;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setValid(boolean valid) {
        this._valid = valid;
    }

    public MethodBinding getValidator() {
        return this._validator;
    }

    public void setValidator(MethodBinding validator) {
        this._validator = validator;
    }

    public MethodBinding getValueChangeListener() {
        return this._valueChangeListener;
    }

    public void setValueChangeListener(MethodBinding valueChangeListener) {
        this._valueChangeListener = valueChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDecodes(FacesContext context) {
        block12: {
            if (context == null) {
                throw new NullPointerException("context");
            }
            try {
                this.setCachedFacesContext(context);
                if (!this.isRendered()) {
                    return;
                }
            }
            finally {
                this.setCachedFacesContext(null);
            }
            super.processDecodes(context);
            try {
                this.setCachedFacesContext(context);
                if (!this.isImmediate()) break block12;
                try {
                    this.validate(context);
                }
                catch (RuntimeException e) {
                    context.renderResponse();
                    throw e;
                }
                if (!this.isValid()) {
                    context.renderResponse();
                }
            }
            finally {
                this.setCachedFacesContext(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processValidators(FacesContext context) {
        block12: {
            if (context == null) {
                throw new NullPointerException("context");
            }
            try {
                this.setCachedFacesContext(context);
                if (!this.isRendered()) {
                    return;
                }
            }
            finally {
                this.setCachedFacesContext(null);
            }
            super.processValidators(context);
            try {
                this.setCachedFacesContext(context);
                if (this.isImmediate()) break block12;
                try {
                    this.validate(context);
                }
                catch (RuntimeException e) {
                    context.renderResponse();
                    throw e;
                }
                if (!this.isValid()) {
                    context.renderResponse();
                }
            }
            finally {
                this.setCachedFacesContext(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            this.setCachedFacesContext(context);
            if (!this.isRendered()) {
                return;
            }
        }
        finally {
            this.setCachedFacesContext(null);
        }
        super.processUpdates(context);
        try {
            this.setCachedFacesContext(context);
            try {
                this.updateModel(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
        finally {
            this.setCachedFacesContext(null);
        }
    }

    public void decode(FacesContext context) {
        this.setValid(true);
        super.decode(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding valueChangeListenerBinding;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (valueChangeListenerBinding = this.getValueChangeListener()) != null) {
            try {
                valueChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public void updateModel(FacesContext context) {
        if (!this.isValid()) {
            return;
        }
        if (!this.isLocalValueSet()) {
            return;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb == null) {
            return;
        }
        try {
            vb.setValue(context, this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (Exception e) {
            context.getExternalContext().log(e.getMessage(), e);
            _MessageUtils.addErrorMessage(context, this, CONVERSION_MESSAGE_ID, new Object[]{this.getId()});
            this.setValid(false);
            this.queueExceptionInRequest(context, vb, e);
        }
    }

    private void queueExceptionInRequest(FacesContext context, ValueBinding binding, Exception e) {
        ArrayList<FacesException> li = (ArrayList<FacesException>)context.getExternalContext().getRequestMap().get(ERROR_HANDLING_EXCEPTION_LIST);
        if (null == li) {
            li = new ArrayList<FacesException>();
            context.getExternalContext().getRequestMap().put(ERROR_HANDLING_EXCEPTION_LIST, li);
        }
        li.add(new FacesException("Exception while setting value for expression : " + binding.getExpressionString() + " of component with path : " + _ComponentUtils.getPathToComponent(this), e));
    }

    protected void validateValue(FacesContext context, Object convertedValue) {
        boolean empty;
        boolean bl = empty = convertedValue == null || convertedValue instanceof String && ((String)convertedValue).length() == 0;
        if (this.isRequired() && empty) {
            _MessageUtils.addErrorMessage(context, this, REQUIRED_MESSAGE_ID, new Object[]{this.getId()});
            this.setValid(false);
            return;
        }
        if (!empty) {
            _ComponentUtils.callValidators(context, this, convertedValue);
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            Object submittedValue = this.getSubmittedValue();
            if (submittedValue == null) {
                return;
            }
            Object convertedValue = this.getConvertedValue(context, submittedValue);
            if (!this.isValid()) {
                return;
            }
            this.validateValue(context, convertedValue);
            if (!this.isValid()) {
                return;
            }
            Object previousValue = this.getValue();
            this.setValue(convertedValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previousValue, convertedValue)) {
                this.queueEvent(new ValueChangeEvent(this, previousValue, convertedValue));
            }
        }
        catch (Exception ex) {
            throw new FacesException("Exception while validating component with path : " + _ComponentUtils.getPathToComponent(this), ex);
        }
    }

    protected Object getConvertedValue(FacesContext context, Object submittedValue) {
        try {
            Converter converter;
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                return renderer.getConvertedValue(context, this, submittedValue);
            }
            if (submittedValue instanceof String && (converter = _SharedRendererUtils.findUIOutputConverter(context, this)) != null) {
                return converter.getAsObject(context, this, (String)submittedValue);
            }
        }
        catch (ConverterException e) {
            FacesMessage facesMessage = e.getFacesMessage();
            if (facesMessage != null) {
                context.addMessage(this.getClientId(context), facesMessage);
            } else {
                _MessageUtils.addErrorMessage(context, this, CONVERSION_MESSAGE_ID, new Object[]{this.getId()});
            }
            this.setValid(false);
        }
        return submittedValue;
    }

    protected boolean compareValues(Object previous, Object value) {
        return previous == null ? value != null : !previous.equals(value);
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException("validator");
        }
        if (this._validatorList == null) {
            this._validatorList = new ArrayList();
        }
        this._validatorList.add(validator);
    }

    public Validator[] getValidators() {
        return this._validatorList != null ? this._validatorList.toArray(new Validator[this._validatorList.size()]) : EMPTY_VALIDATOR_ARRAY;
    }

    public void removeValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException("validator");
        }
        if (this._validatorList != null) {
            this._validatorList.remove(validator);
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener(listener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._immediate, this._localValueSet, this._required, this._submittedValue, this._valid, UIInput.saveAttachedState(context, this._validator), UIInput.saveAttachedState(context, this._valueChangeListener), UIInput.saveAttachedState(context, this._validatorList)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._immediate = (Boolean)values[1];
        this._localValueSet = (Boolean)values[2];
        this._required = (Boolean)values[3];
        this._submittedValue = values[4];
        this._valid = (Boolean)values[5];
        this._validator = (MethodBinding)UIInput.restoreAttachedState(context, values[6]);
        this._valueChangeListener = (MethodBinding)UIInput.restoreAttachedState(context, values[7]);
        this._validatorList = (List)UIInput.restoreAttachedState(context, values[8]);
    }

    public UIInput() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return "javax.faces.Input";
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate;
    }

    public boolean isImmediate() {
        if (this._immediate != null) {
            return this._immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        if (this._required != null) {
            return this._required;
        }
        ValueBinding vb = this.getValueBinding("required");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }
}

