/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.ArrayList;
import java.util.List;
import javax.faces.model.DataModelListener;

public abstract class DataModel {
    private static final DataModelListener[] EMPTY_DATA_MODEL_LISTENER = new DataModelListener[0];
    private List<DataModelListener> _listeners;
    private DataModelListener[] _cachedListenersArray = null;

    public void addDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList<DataModelListener>();
        }
        this._listeners.add(listener);
        this._cachedListenersArray = null;
    }

    public DataModelListener[] getDataModelListeners() {
        if (this._listeners == null) {
            return EMPTY_DATA_MODEL_LISTENER;
        }
        if (this._cachedListenersArray == null) {
            this._cachedListenersArray = this._listeners.toArray(new DataModelListener[this._listeners.size()]);
        }
        return this._cachedListenersArray;
    }

    public abstract int getRowCount();

    public abstract Object getRowData();

    public abstract int getRowIndex();

    public abstract Object getWrappedData();

    public abstract boolean isRowAvailable();

    public void removeDataModelListener(DataModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
        this._cachedListenersArray = null;
    }

    public abstract void setRowIndex(int var1);

    public abstract void setWrappedData(Object var1);
}

