/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.validator._MessageUtils;

public class DoubleRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE";
    private Double _minimum = null;
    private Double _maximum = null;
    private boolean _transient = false;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double maximum) {
        this._maximum = new Double(maximum);
    }

    public DoubleRangeValidator(double maximum, double minimum) {
        this._maximum = new Double(maximum);
        this._minimum = new Double(minimum);
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        double dvalue = this.parseDoubleValue(facesContext, uiComponent, value);
        if (this._minimum != null && this._maximum != null) {
            if (dvalue < this._minimum || dvalue > this._maximum) {
                Object[] args = new Object[]{this._minimum, this._maximum, _MessageUtils.getLabel(facesContext, uiComponent)};
                throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, args));
            }
        } else if (this._minimum != null) {
            if (dvalue < this._minimum) {
                Object[] args = new Object[]{this._minimum, _MessageUtils.getLabel(facesContext, uiComponent)};
                throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MINIMUM_MESSAGE_ID, args));
            }
        } else if (this._maximum != null && dvalue > this._maximum) {
            Object[] args = new Object[]{this._maximum, _MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MAXIMUM_MESSAGE_ID, args));
        }
    }

    private double parseDoubleValue(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{_MessageUtils.getLabel(facesContext, uiComponent)};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, TYPE_MESSAGE_ID, args));
        }
    }

    public double getMaximum() {
        return this._maximum != null ? this._maximum : Double.MAX_VALUE;
    }

    public void setMaximum(double maximum) {
        this._maximum = new Double(maximum);
    }

    public double getMinimum() {
        return this._minimum != null ? this._minimum : Double.MIN_VALUE;
    }

    public void setMinimum(double minimum) {
        this._minimum = new Double(minimum);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this._maximum, this._minimum};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._maximum = (Double)values[0];
        this._minimum = (Double)values[1];
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean transientValue) {
        this._transient = transientValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleRangeValidator)) {
            return false;
        }
        DoubleRangeValidator doubleRangeValidator = (DoubleRangeValidator)o;
        if (this._maximum != null ? !this._maximum.equals(doubleRangeValidator._maximum) : doubleRangeValidator._maximum != null) {
            return false;
        }
        return !(this._minimum != null ? !this._minimum.equals(doubleRangeValidator._minimum) : doubleRangeValidator._minimum != null);
    }
}

