/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationFactoryImpl;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.el.DefaultPropertyResolver;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.lifecycle.LifecycleFactoryImpl;
import org.apache.myfaces.renderkit.RenderKitFactoryImpl;
import org.apache.myfaces.renderkit.html.HtmlRenderKitImpl;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.LocaleUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigurator {
    private static final Log log = LogFactory.getLog(FacesConfigurator.class);
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "META-INF/standard-faces-config.xml";
    private static final String FACES_CONFIG_RESOURCE = "META-INF/faces-config.xml";
    private static final String META_INF_SERVICES_RESOURCE_PREFIX = "META-INF/services/";
    private static final String DEFAULT_RENDER_KIT_CLASS = HtmlRenderKitImpl.class.getName();
    private static final String DEFAULT_APPLICATION_FACTORY = ApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = LifecycleFactoryImpl.class.getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = RenderKitFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set<String> FACTORY_NAMES = new HashSet<String>();
    private final ExternalContext _externalContext;
    private FacesConfigUnmarshaller _unmarshaller;
    private FacesConfigDispenser _dispenser;
    private RuntimeConfig _runtimeConfig;
    private static final String JAR_EXTENSION = ".jar";
    private static final String META_INF_MANIFEST_SUFFIX = "!/META-INF/MANIFEST.MF";
    private static final String JAR_PREFIX = "jar:";
    private static long lastUpdate;
    public static final String MYFACES_API_PACKAGE_NAME = "myfaces-api";
    public static final String MYFACES_IMPL_PACKAGE_NAME = "myfaces-impl";
    public static final String MYFACES_TOMAHAWK_PACKAGE_NAME = "tomahawk";
    public static final String MYFACES_TOMAHAWK12_PACKAGE_NAME = "tomahawk12";
    public static final String MYFACES_ORCHESTRA_PACKAGE_NAME = "myfaces-orchestra-core";
    public static final String MYFACES_ORCHESTRA12_PACKAGE_NAME = "myfaces-orchestra-core12";
    public static final String MYFACES_TRINIDAD_API_PACKAGE_NAME = "trinidad-api";
    public static final String MYFACES_TRINIDAD_IMPL_PACKAGE_NAME = "trinidad-impl";
    public static final String MYFACES_TOBAGO_PACKAGE_NAME = "tobago-core";
    public static final String MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME = "tomahawk-sandbox";
    public static final String MYFACES_TOMAHAWK_SANDBOX12_PACKAGE_NAME = "tomahawk-sandbox12";
    public static final String MYFACES_TOMAHAWK_SANDBOX15_PACKAGE_NAME = "tomahawk-sandbox15";
    public static final String COMMONS_EL_PACKAGE_NAME = "commons-el";
    public static final String JSP_API_PACKAGE_NAME = "jsp-api";
    private static final String[] ARTIFACTS_IDS;
    public static final String REGEX_LIBRARY = "(jar|besjar|wsjar|zip):(file:.*/(.+?)-(\\d+.*)\\.jar)!/META-INF/MANIFEST.MF";
    private static final Pattern REGEX_LIBRARY_PATTERN;
    private static final int REGEX_LIBRARY_FILE_PATH = 2;
    private static final int REGEX_LIBRARY_ARTIFACT_ID = 3;
    private static final int REGEX_LIBRARY_VERSION = 4;

    public FacesConfigurator(ExternalContext externalContext) {
        if (externalContext == null) {
            throw new IllegalArgumentException("external context must not be null");
        }
        this._externalContext = externalContext;
    }

    public void setUnmarshaller(FacesConfigUnmarshaller unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller getUnmarshaller() {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        }
        return this._unmarshaller;
    }

    public void setDispenser(FacesConfigDispenser dispenser) {
        this._dispenser = dispenser;
    }

    protected FacesConfigDispenser getDispenser() {
        if (this._dispenser == null) {
            this._dispenser = new DigesterFacesConfigDispenserImpl();
        }
        return this._dispenser;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return this.getResourceLastModified(url);
            }
        }
        catch (IOException e) {
            log.error((Object)("Could not read resource " + resource), (Throwable)e);
        }
        return 0L;
    }

    private long getResourceLastModified(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String externalForm = url.toExternalForm();
            File file = new File(externalForm.substring(5));
            return file.lastModified();
        }
        return this.getResourceLastModified(url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getResourceLastModified(URLConnection connection) throws IOException {
        long modified;
        if (connection instanceof JarURLConnection) {
            URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
            URLConnection jarFileConnection = jarFileUrl.openConnection();
            try {
                modified = jarFileConnection.getLastModified();
            }
            finally {
                try {
                    jarFileConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        modified = connection.getLastModified();
        return modified;
    }

    private long getLastModifiedTime() {
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        List<String> configFilesList = this.getConfigFilesList();
        for (String systemId : configFilesList) {
            resModified = this.getResourceLastModified(systemId);
            if (resModified <= lastModified) continue;
            lastModified = resModified;
        }
        return lastModified;
    }

    public void update() {
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                try {
                    this.purgeConfiguration();
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)"Configuration objects do not support clean-up. Update aborted");
                    lastUpdate = System.currentTimeMillis();
                    return;
                }
                catch (IllegalAccessException e) {
                    log.fatal((Object)("Error during configuration clean-up" + e.getMessage()));
                }
                catch (InvocationTargetException e) {
                    log.fatal((Object)("Error during configuration clean-up" + e.getMessage()));
                }
                this.configure();
            }
        }
    }

    private void purgeConfiguration() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] NO_PARAMETER_TYPES = new Class[]{};
        Object[] NO_PARAMETERS = new Object[]{};
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Method appFactoryPurgeMethod = applicationFactory.getClass().getMethod("purgeApplication", NO_PARAMETER_TYPES);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        Method renderKitPurgeMethod = renderKitFactory.getClass().getMethod("purgeRenderKit", NO_PARAMETER_TYPES);
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Method lifecyclePurgeMethod = lifecycleFactory.getClass().getMethod("purgeLifecycle", NO_PARAMETER_TYPES);
        appFactoryPurgeMethod.invoke((Object)applicationFactory, NO_PARAMETERS);
        renderKitPurgeMethod.invoke((Object)renderKitFactory, NO_PARAMETERS);
        RuntimeConfig.getCurrentInstance(this._externalContext).purge();
        lifecyclePurgeMethod.invoke((Object)lifecycleFactory, NO_PARAMETERS);
    }

    public void configure() throws FacesException {
        try {
            this.feedStandardConfig();
            this.feedMetaInfServicesFactories();
            this.feedClassloaderConfigurations();
            this.feedContextSpecifiedConfig();
            this.feedWebAppConfig();
            if (log.isInfoEnabled()) {
                this.logMetaInf();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
        lastUpdate = System.currentTimeMillis();
    }

    private void feedStandardConfig() throws IOException, SAXException {
        InputStream stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE);
        if (stream == null) {
            throw new FacesException("Standard faces config META-INF/standard-faces-config.xml not found");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Reading standard config META-INF/standard-faces-config.xml");
        }
        this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE));
        stream.close();
    }

    protected void logMetaInf() {
        try {
            HashMap<String, List<JarInfo>> libs = new HashMap<String, List<JarInfo>>(30);
            Iterator it = ClassUtils.getResources("META-INF/MANIFEST.MF", this);
            while (it.hasNext()) {
                URL url = (URL)it.next();
                FacesConfigurator.addJarInfo(libs, url);
            }
            if (log.isWarnEnabled()) {
                for (String artifactId : ARTIFACTS_IDS) {
                    List versions = (List)libs.get(artifactId);
                    if (versions == null || versions.size() <= 1) continue;
                    StringBuilder builder = new StringBuilder(1024);
                    builder.append("You are using the library: ");
                    builder.append(artifactId);
                    builder.append(" in different versions; first (and probably used) version is: ");
                    builder.append(((JarInfo)versions.get(0)).getVersion());
                    builder.append(" loaded from: ");
                    builder.append(((JarInfo)versions.get(0)).getUrl());
                    builder.append(", but also found the following versions: ");
                    boolean needComma = false;
                    for (int i = 1; i < versions.size(); ++i) {
                        JarInfo info = (JarInfo)versions.get(i);
                        if (needComma) {
                            builder.append(", ");
                        }
                        builder.append(info.getVersion());
                        builder.append(" loaded from: ");
                        builder.append(info.getUrl());
                        needComma = true;
                    }
                    log.warn((Object)builder.toString());
                }
            }
            if (log.isInfoEnabled()) {
                for (String artifactId : ARTIFACTS_IDS) {
                    this.startLib(artifactId, libs);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    protected static void addJarInfo(Map<String, List<JarInfo>> libs, URL url) {
        Matcher matcher = REGEX_LIBRARY_PATTERN.matcher(url.toString());
        if (matcher.matches()) {
            String version;
            String path;
            JarInfo newInfo;
            String artifactId = matcher.group(3);
            List<JarInfo> versions = libs.get(artifactId);
            if (versions == null) {
                versions = new ArrayList<JarInfo>(2);
                libs.put(artifactId, versions);
            }
            if (!versions.contains(newInfo = new JarInfo(path = matcher.group(2), version = matcher.group(4)))) {
                versions.add(newInfo);
            }
        }
    }

    protected void feedMetaInfServicesFactories() {
        try {
            for (String factoryName : FACTORY_NAMES) {
                Iterator it = ClassUtils.getResources(META_INF_SERVICES_RESOURCE_PREFIX + factoryName, this);
                while (it.hasNext()) {
                    String className;
                    URL url = (URL)it.next();
                    InputStream stream = this.openStreamWithoutCache(url);
                    InputStreamReader isr = new InputStreamReader(stream);
                    BufferedReader br = new BufferedReader(isr);
                    try {
                        className = br.readLine();
                    }
                    catch (IOException e) {
                        throw new FacesException("Unable to read class name from file " + url.toExternalForm(), (Throwable)e);
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Found " + factoryName + " factory implementation: " + className));
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        this.getDispenser().feedApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        this.getDispenser().feedFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        this.getDispenser().feedLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        this.getDispenser().feedRenderKitFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedClassloaderConfigurations() {
        try {
            TreeMap<String, URL> facesConfigs = new TreeMap<String, URL>();
            Iterator it = ClassUtils.getResources(FACES_CONFIG_RESOURCE, this);
            while (it.hasNext()) {
                URL url = (URL)it.next();
                String systemId = url.toExternalForm();
                facesConfigs.put(systemId, url);
            }
            for (Map.Entry entry : facesConfigs.entrySet()) {
                InputStream stream = null;
                try {
                    stream = this.openStreamWithoutCache((URL)entry.getValue());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Reading config : " + (String)entry.getKey()));
                    }
                    this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, (String)entry.getKey()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private void feedContextSpecifiedConfig() throws IOException, SAXException {
        List<String> configFilesList = this.getConfigFilesList();
        for (String systemId : configFilesList) {
            InputStream stream = this._externalContext.getResourceAsStream(systemId);
            if (stream == null) {
                log.error((Object)("Faces config resource " + systemId + " not found"));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reading config " + systemId));
            }
            this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, systemId));
            stream.close();
        }
    }

    private List<String> getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void feedWebAppConfig() throws IOException, SAXException {
        InputStream stream = this._externalContext.getResourceAsStream(DEFAULT_FACES_CONFIG);
        if (stream != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Reading config /WEB-INF/faces-config.xml");
            }
            this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, DEFAULT_FACES_CONFIG));
            stream.close();
        }
    }

    private void configureFactories() {
        FacesConfigDispenser dispenser = this.getDispenser();
        this.setFactories("javax.faces.application.ApplicationFactory", dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
    }

    private void setFactories(String factoryName, Iterator factories, String defaultFactory) {
        FactoryFinder.setFactory((String)factoryName, (String)defaultFactory);
        while (factories.hasNext()) {
            String factory = (String)factories.next();
            if (factory.equals(defaultFactory)) continue;
            FactoryFinder.setFactory((String)factoryName, (String)factory);
        }
    }

    private void startLib(String artifactId, Map<String, List<JarInfo>> libs) {
        List<JarInfo> versions = libs.get(artifactId);
        if (versions == null) {
            log.info((Object)("Artifact '" + artifactId + "' was not found."));
        } else {
            JarInfo info = versions.get(0);
            log.info((Object)("Artifact '" + artifactId + "' was found in version '" + info.getVersion() + "' from path '" + info.getUrl() + "'"));
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        FacesConfigDispenser dispenser = this.getDispenser();
        application.setActionListener((ActionListener)this.getApplicationObject(ActionListener.class, dispenser.getActionListenerIterator(), null));
        if (dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(dispenser.getDefaultLocale()));
        }
        if (dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(dispenser.getDefaultRenderKitId());
        }
        if (dispenser.getMessageBundle() != null) {
            application.setMessageBundle(dispenser.getMessageBundle());
        }
        application.setNavigationHandler((NavigationHandler)this.getApplicationObject(NavigationHandler.class, dispenser.getNavigationHandlerIterator(), application.getNavigationHandler()));
        application.setStateManager((StateManager)this.getApplicationObject(StateManager.class, dispenser.getStateManagerIterator(), application.getStateManager()));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator<String> it = dispenser.getSupportedLocalesIterator();
        while (it.hasNext()) {
            locales.add(LocaleUtils.toLocale(it.next()));
        }
        application.setSupportedLocales(locales);
        application.setViewHandler((ViewHandler)this.getApplicationObject(ViewHandler.class, dispenser.getViewHandlerIterator(), application.getViewHandler()));
        it = dispenser.getComponentTypes();
        while (it.hasNext()) {
            String componentType = it.next();
            application.addComponent(componentType, dispenser.getComponentClass(componentType));
        }
        it = dispenser.getConverterIds();
        while (it.hasNext()) {
            String converterId = it.next();
            application.addConverter(converterId, dispenser.getConverterClassById(converterId));
        }
        it = dispenser.getConverterClasses();
        while (it.hasNext()) {
            String converterClass = it.next();
            try {
                application.addConverter(ClassUtils.simpleClassForName(converterClass), dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.error((Object)"Converter could not be added. Reason:", (Throwable)ex);
            }
        }
        it = dispenser.getValidatorIds();
        while (it.hasNext()) {
            String validatorId = it.next();
            application.addValidator(validatorId, dispenser.getValidatorClass(validatorId));
        }
        RuntimeConfig runtimeConfig = this.getRuntimeConfig();
        runtimeConfig.setPropertyResolverChainHead((PropertyResolver)this.getApplicationObject(PropertyResolver.class, dispenser.getPropertyResolverIterator(), (Object)new DefaultPropertyResolver()));
        runtimeConfig.setVariableResolverChainHead((VariableResolver)this.getApplicationObject(VariableResolver.class, dispenser.getVariableResolverIterator(), (Object)new VariableResolverImpl()));
    }

    protected RuntimeConfig getRuntimeConfig() {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        }
        return this._runtimeConfig;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this._runtimeConfig = runtimeConfig;
    }

    private Object getApplicationObject(Class interfaceClass, Iterator classNamesIterator, Object defaultObject) {
        Object current = defaultObject;
        while (classNamesIterator.hasNext()) {
            String implClassName = (String)classNamesIterator.next();
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            try {
                Constructor delegationConstructor = implClass.getConstructor(interfaceClass);
                try {
                    current = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                current = ClassUtils.newInstance(implClass);
            }
        }
        return current;
    }

    private void configureRuntimeConfig() {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        FacesConfigDispenser dispenser = this.getDispenser();
        Iterator<Object> iterator = dispenser.getManagedBeans();
        while (iterator.hasNext()) {
            ManagedBean bean = iterator.next();
            if (log.isWarnEnabled() && runtimeConfig.getManagedBean(bean.getManagedBeanName()) != null) {
                log.warn((Object)("More than one managed bean w/ the name of '" + bean.getManagedBeanName() + "' - only keeping the last "));
            }
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        this.removePurgedBeansFromSessionAndApplication(runtimeConfig);
        iterator = dispenser.getNavigationRules();
        while (iterator.hasNext()) {
            NavigationRule rule = (NavigationRule)iterator.next();
            runtimeConfig.addNavigationRule(rule);
        }
        Iterator<String> it = this._dispenser.getConverterConfigurationByClassName();
        while (it.hasNext()) {
            String converterClassName = it.next();
            runtimeConfig.addConverterConfiguration(converterClassName, this._dispenser.getConverterConfiguration(converterClassName));
        }
        Iterator<Object> iter = dispenser.getResourceBundles();
        while (iter.hasNext()) {
            runtimeConfig.addResourceBundle(iter.next());
        }
        iter = dispenser.getElResolvers();
        while (iter.hasNext()) {
            runtimeConfig.addFacesConfigElResolver((ELResolver)ClassUtils.newInstance((String)iter.next(), ELResolver.class));
        }
        String comparatorClass = this._externalContext.getInitParameter("org.apache.myfaces.EL_RESOLVER_COMPARATOR");
        if (comparatorClass != null && !"".equals(comparatorClass)) {
            try {
                Class clazz = ClassUtils.classForName(comparatorClass);
                Comparator comparator = (Comparator)clazz.newInstance();
                runtimeConfig.setELResolverComparator(comparator);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cannot instantiate EL Resolver Comparator " + comparatorClass + " . Check org.apache.myfaces.EL_RESOLVER_COMPARATOR web config param. Initialization continues with no comparator used."), (Throwable)e);
                }
            }
        } else {
            runtimeConfig.setELResolverComparator(null);
        }
    }

    private void removePurgedBeansFromSessionAndApplication(RuntimeConfig runtimeConfig) {
        Map oldManagedBeans = runtimeConfig.getManagedBeansNotReaddedAfterPurge();
        if (oldManagedBeans != null) {
            for (Map.Entry entry : oldManagedBeans.entrySet()) {
                ManagedBean bean = (ManagedBean)entry.getValue();
                String scope = bean.getManagedBeanScope();
                if (scope != null && scope.equalsIgnoreCase("session")) {
                    this._externalContext.getSessionMap().remove(entry.getKey());
                    continue;
                }
                if (scope == null || !scope.equalsIgnoreCase("application")) continue;
                this._externalContext.getApplicationMap().remove(entry.getKey());
            }
        }
        runtimeConfig.resetManagedBeansNotReaddedAfterPurge();
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        FacesConfigDispenser dispenser = this.getDispenser();
        Iterator<String> iterator = dispenser.getRenderKitIds();
        while (iterator.hasNext()) {
            String renderKitId = iterator.next();
            String renderKitClass = dispenser.getRenderKitClass(renderKitId);
            if (renderKitClass == null) {
                renderKitClass = DEFAULT_RENDER_KIT_CLASS;
            }
            RenderKit renderKit = (RenderKit)ClassUtils.newInstance(renderKitClass);
            Iterator<Renderer> renderers = dispenser.getRenderers(renderKitId);
            while (renderers.hasNext()) {
                javax.faces.render.Renderer renderer;
                Renderer element = renderers.next();
                try {
                    renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                }
                catch (Throwable e) {
                    log.error((Object)("failed to configure class " + element.getRendererClass()), e);
                    continue;
                }
                renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator it = lifecycleFactory.getLifecycleIds();
        while (it.hasNext()) {
            Lifecycle lifecycle = lifecycleFactory.getLifecycle((String)it.next());
            Iterator<String> iterator = this.getDispenser().getLifecyclePhaseListeners();
            while (iterator.hasNext()) {
                String listenerClassName = iterator.next();
                try {
                    lifecycle.addPhaseListener((PhaseListener)ClassUtils.newInstance(listenerClassName, PhaseListener.class));
                }
                catch (ClassCastException e) {
                    log.error((Object)("Class " + listenerClassName + " does not implement PhaseListener"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
            }
            catch (ClassCastException e) {
                log.error((Object)("Make sure '" + serialProvider + "' implements the correct interface"), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.error((Object)"Using default serialization provider");
                }
            }
        }
        log.info((Object)("Serialization provider : " + serialFactory.getClass()));
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    static {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        ARTIFACTS_IDS = new String[]{MYFACES_API_PACKAGE_NAME, MYFACES_IMPL_PACKAGE_NAME, MYFACES_TOMAHAWK_PACKAGE_NAME, MYFACES_TOMAHAWK12_PACKAGE_NAME, MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME, MYFACES_TOMAHAWK_SANDBOX12_PACKAGE_NAME, MYFACES_TOMAHAWK_SANDBOX15_PACKAGE_NAME, MYFACES_ORCHESTRA_PACKAGE_NAME, MYFACES_ORCHESTRA12_PACKAGE_NAME, MYFACES_TRINIDAD_API_PACKAGE_NAME, MYFACES_TRINIDAD_IMPL_PACKAGE_NAME, MYFACES_TOBAGO_PACKAGE_NAME, COMMONS_EL_PACKAGE_NAME, JSP_API_PACKAGE_NAME};
        REGEX_LIBRARY_PATTERN = Pattern.compile(REGEX_LIBRARY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JarInfo
    implements Comparable<JarInfo> {
        private String url;
        private String version;

        public JarInfo(String url, String version) {
            this.url = url;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public int compareTo(JarInfo info) {
            return this.version.compareTo(info.version);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof JarInfo) {
                JarInfo other = (JarInfo)o;
                return this.version.equals(other.version);
            }
            return false;
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

