/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.lifecycle.ApplyRequestValuesExecutor;
import org.apache.myfaces.lifecycle.InvokeApplicationExecutor;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.PhaseListenerManager;
import org.apache.myfaces.lifecycle.ProcessValidationsExecutor;
import org.apache.myfaces.lifecycle.RenderResponseExecutor;
import org.apache.myfaces.lifecycle.RestoreViewExecutor;
import org.apache.myfaces.lifecycle.UpdateModelValuesExecutor;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXml;
import org.apache.myfaces.util.DebugUtils;

public class LifecycleImpl
extends Lifecycle {
    private static final Log log = LogFactory.getLog(LifecycleImpl.class);
    private PhaseExecutor[] lifecycleExecutors;
    private PhaseExecutor renderExecutor;
    private final List<PhaseListener> _phaseListenerList = new ArrayList<PhaseListener>();
    private PhaseListener[] _phaseListenerArray = null;

    public LifecycleImpl() {
        this.lifecycleExecutors = new PhaseExecutor[]{new RestoreViewExecutor(), new ApplyRequestValuesExecutor(), new ProcessValidationsExecutor(), new UpdateModelValuesExecutor(), new InvokeApplicationExecutor()};
        this.renderExecutor = new RenderResponseExecutor();
    }

    public void execute(FacesContext facesContext) throws FacesException {
        WebXml.update(facesContext.getExternalContext());
        new FacesConfigurator(facesContext.getExternalContext()).update();
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, facesContext, this.getPhaseListeners());
        for (int executorIndex = 0; executorIndex < this.lifecycleExecutors.length; ++executorIndex) {
            if (!this.executePhase(facesContext, this.lifecycleExecutors[executorIndex], phaseListenerMgr)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePhase(FacesContext facesContext, PhaseExecutor executor, PhaseListenerManager phaseListenerMgr) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering " + executor.getPhase() + " in " + LifecycleImpl.class.getName()));
        }
        try {
            phaseListenerMgr.informPhaseListenersBefore(executor.getPhase());
            if (this.isResponseComplete(facesContext, executor.getPhase(), true)) {
                boolean bl = true;
                return bl;
            }
            if (this.shouldRenderResponse(facesContext, executor.getPhase(), true)) {
                skipFurtherProcessing = true;
            }
            if (executor.execute(facesContext)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(executor.getPhase());
        }
        if (this.isResponseComplete(facesContext, executor.getPhase(), false) || this.shouldRenderResponse(facesContext, executor.getPhase(), false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && log.isTraceEnabled()) {
            log.trace((Object)("exiting " + executor.getPhase() + " in " + LifecycleImpl.class.getName()));
        }
        return skipFurtherProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(FacesContext facesContext) throws FacesException {
        if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering " + this.renderExecutor.getPhase() + " in " + LifecycleImpl.class.getName()));
        }
        PhaseListenerManager phaseListenerMgr = new PhaseListenerManager(this, facesContext, this.getPhaseListeners());
        try {
            phaseListenerMgr.informPhaseListenersBefore(this.renderExecutor.getPhase());
            if (this.isResponseComplete(facesContext, this.renderExecutor.getPhase(), true)) {
                return;
            }
            this.renderExecutor.execute(facesContext);
        }
        finally {
            phaseListenerMgr.informPhaseListenersAfter(this.renderExecutor.getPhase());
        }
        if (log.isTraceEnabled()) {
            DebugUtils.traceView("View after rendering");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("exiting " + this.renderExecutor.getPhase() + " in " + LifecycleImpl.class.getName()));
        }
    }

    private boolean isResponseComplete(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getResponseComplete()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("exiting from lifecycle.execute in " + phase + " because getResponseComplete is true from one of the " + (before ? "before" : "after") + " listeners"));
            }
            flag = true;
        }
        return flag;
    }

    private boolean shouldRenderResponse(FacesContext facesContext, PhaseId phase, boolean before) {
        boolean flag = false;
        if (facesContext.getRenderResponse()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("exiting from lifecycle.execute in " + phase + " because getRenderResponse is true from one of the " + (before ? "before" : "after") + " listeners"));
            }
            flag = true;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        List<PhaseListener> list = this._phaseListenerList;
        synchronized (list) {
            this._phaseListenerList.add(phaseListener);
            this._phaseListenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        List<PhaseListener> list = this._phaseListenerList;
        synchronized (list) {
            this._phaseListenerList.remove(phaseListener);
            this._phaseListenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        List<PhaseListener> list = this._phaseListenerList;
        synchronized (list) {
            if (this._phaseListenerArray == null) {
                this._phaseListenerArray = this._phaseListenerList.toArray(new PhaseListener[this._phaseListenerList.size()]);
            }
            return this._phaseListenerArray;
        }
    }
}

