/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.Enumeration;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.discovery.tools.DiscoverSingleton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.webapp.AbstractMyFacesListener;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.Jsp20FacesInitializer;
import org.apache.myfaces.webapp.Jsp21FacesInitializer;
import org.apache.myfaces.webapp.StartupListener;

public class StartupServletContextListener
extends AbstractMyFacesListener
implements ServletContextListener {
    static final String FACES_INIT_DONE = StartupServletContextListener.class.getName() + ".FACES_INIT_DONE";
    static final String FACES_INIT_PLUGINS = "org.apache.myfaces.FACES_INIT_PLUGINS";
    private static final byte FACES_INIT_PHASE_PREINIT = 0;
    private static final byte FACES_INIT_PHASE_POSTINIT = 1;
    private static final byte FACES_INIT_PHASE_PREDESTROY = 2;
    private static final byte FACES_INIT_PHASE_POSTDESTROY = 3;
    private static final Log log = LogFactory.getLog(StartupServletContextListener.class);
    private FacesInitializer _facesInitializer;
    private ServletContext _servletContext;

    public void contextInitialized(ServletContextEvent event) {
        if (this._servletContext != null) {
            throw new IllegalStateException("context is already initialized");
        }
        this._servletContext = event.getServletContext();
        Boolean b = (Boolean)this._servletContext.getAttribute(FACES_INIT_DONE);
        if (b == null || !b.booleanValue()) {
            FacesInitializer facesInitializer = this.getFacesInitializer();
            FacesContext facesContext = facesInitializer.initStartupFacesContext(this._servletContext);
            this.dispatchInitializationEvent(event, 0);
            facesInitializer.initFaces(this._servletContext);
            this.dispatchInitializationEvent(event, 1);
            this._servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
            facesInitializer.destroyStartupFacesContext(facesContext);
        } else {
            log.info((Object)"MyFaces already initialized");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this._facesInitializer != null && this._servletContext != null) {
            FacesContext facesContext = this._facesInitializer.initShutdownFacesContext(this._servletContext);
            this.doPredestroy(event);
            this._facesInitializer.destroyFaces(this._servletContext);
            LifecycleProviderFactory.getLifecycleProviderFactory().release();
            if (facesContext != null) {
                this._facesInitializer.destroyShutdownFacesContext(facesContext);
            }
            FactoryFinder.releaseFactories();
            DiscoverSingleton.release();
            this.dispatchInitializationEvent(event, 3);
        }
        this._servletContext = null;
    }

    protected FacesInitializer getFacesInitializer() {
        if (this._facesInitializer == null) {
            this._facesInitializer = ContainerUtils.isJsp21() ? new Jsp21FacesInitializer() : new Jsp20FacesInitializer();
        }
        return this._facesInitializer;
    }

    public void setFacesInitializer(FacesInitializer facesInitializer) {
        if (this._facesInitializer != null && this._facesInitializer != facesInitializer && this._servletContext != null) {
            this._facesInitializer.destroyFaces(this._servletContext);
        }
        this._facesInitializer = facesInitializer;
        if (this._servletContext != null) {
            facesInitializer.initFaces(this._servletContext);
        }
    }

    private void doPredestroy(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        this.dispatchInitializationEvent(event, 2);
        Enumeration attributes = ctx.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            Object value = ctx.getAttribute(name);
            this.doPreDestroy(value, name, "application");
        }
    }

    private void dispatchInitializationEvent(ServletContextEvent event, int operation) {
        String[] pluginEntries = (String[])this._servletContext.getAttribute(FACES_INIT_PLUGINS);
        if (pluginEntries == null) {
            String plugins = this._servletContext.getInitParameter(FACES_INIT_PLUGINS);
            log.info((Object)"Checking for plugins:org.apache.myfaces.FACES_INIT_PLUGINS");
            if (plugins == null) {
                return;
            }
            log.info((Object)"Plugins found");
            pluginEntries = plugins.split(",");
            this._servletContext.setAttribute(FACES_INIT_PLUGINS, (Object)pluginEntries);
        }
        for (String plugin : pluginEntries) {
            log.info((Object)("Processing plugin:" + plugin));
            try {
                Class<?> pluginClass = ClassUtils.getContextClassLoader().loadClass(plugin);
                if (pluginClass == null) {
                    pluginClass = this.getClass().getClassLoader().loadClass(plugin);
                }
                StartupListener initializer = (StartupListener)pluginClass.newInstance();
                switch (operation) {
                    case 0: {
                        initializer.preInit(event);
                        break;
                    }
                    case 1: {
                        initializer.postInit(event);
                        break;
                    }
                    case 2: {
                        initializer.preDestroy(event);
                        break;
                    }
                    default: {
                        initializer.postDestroy(event);
                        break;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e);
            }
            catch (InstantiationException e) {
                log.error((Object)e);
            }
        }
        log.info((Object)"Processing plugins done");
    }
}

