/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.context.FacesContext;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.flow.Freezable;

public class NavigationCaseImpl
extends NavigationCase
implements Freezable {
    private String condition;
    private String fromAction;
    private String fromOutcome;
    private String fromViewId;
    private String toViewId;
    private String toFlowDocumentId;
    private boolean includeViewParams;
    private boolean redirect;
    private Map<String, List<String>> parameters;
    private ValueExpression conditionExpression;
    private ValueExpression toViewIdExpression;
    private boolean initialized;

    public NavigationCaseImpl() {
        super(null, null, null, null, null, null, false, false);
    }

    public NavigationCaseImpl(String fromViewId, String fromAction, String fromOutcome, String condition, String toViewId, Map<String, List<String>> parameters, boolean redirect, boolean includeViewParams) {
        super(fromViewId, fromAction, fromOutcome, condition, toViewId, parameters, redirect, includeViewParams);
        this.condition = condition;
        this.fromViewId = fromViewId;
        this.fromAction = fromAction;
        this.fromOutcome = fromOutcome;
        this.toViewId = toViewId;
        this.toFlowDocumentId = null;
        this.redirect = redirect;
        this.includeViewParams = includeViewParams;
        this.parameters = parameters;
    }

    public NavigationCaseImpl(String fromViewId, String fromAction, String fromOutcome, String condition, String toViewId, String toFlowDocumentId, Map<String, List<String>> parameters, boolean redirect, boolean includeViewParams) {
        super(fromViewId, fromAction, fromOutcome, condition, toViewId, toFlowDocumentId, parameters, redirect, includeViewParams);
        this.condition = condition;
        this.fromViewId = fromViewId;
        this.fromAction = fromAction;
        this.fromOutcome = fromOutcome;
        this.toViewId = toViewId;
        this.toFlowDocumentId = toFlowDocumentId;
        this.redirect = redirect;
        this.includeViewParams = includeViewParams;
        this.parameters = parameters;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.checkInitialized();
        this.condition = condition;
    }

    public String getFromAction() {
        return this.fromAction;
    }

    public void setFromAction(String fromAction) {
        this.checkInitialized();
        this.fromAction = fromAction;
    }

    public String getFromOutcome() {
        return this.fromOutcome;
    }

    public void setFromOutcome(String fromOutcome) {
        this.checkInitialized();
        this.fromOutcome = fromOutcome;
    }

    public String getFromViewId() {
        return this.fromViewId;
    }

    public void setFromViewId(String fromViewId) {
        this.checkInitialized();
        this.fromViewId = fromViewId;
    }

    public String getToViewId() {
        return this.toViewId;
    }

    public void setToViewId(String toViewId) {
        this.checkInitialized();
        this.toViewId = toViewId;
    }

    public String getToFlowDocumentId() {
        return this.toFlowDocumentId;
    }

    public void setToFlowDocumentId(String toFlowDocumentId) {
        this.checkInitialized();
        this.toFlowDocumentId = toFlowDocumentId;
    }

    public boolean isIncludeViewParams() {
        return this.includeViewParams;
    }

    public void setIncludeViewParams(boolean includeViewParams) {
        this.checkInitialized();
        this.includeViewParams = includeViewParams;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.checkInitialized();
        this.redirect = redirect;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.checkInitialized();
        this.parameters = parameters;
    }

    public ValueExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public void setConditionExpression(ValueExpression conditionExpression) {
        this.checkInitialized();
        this.conditionExpression = conditionExpression;
    }

    public ValueExpression getToViewIdExpression() {
        return this.toViewIdExpression;
    }

    public void setToViewIdExpression(ValueExpression toViewIdExpression) {
        this.checkInitialized();
        this.toViewIdExpression = toViewIdExpression;
    }

    public Boolean getCondition(FacesContext context) {
        if (this.condition == null) {
            return null;
        }
        ValueExpression expression = this._getConditionExpression(context);
        return Boolean.TRUE.equals(expression.getValue(context.getELContext()));
    }

    private ValueExpression _getConditionExpression(FacesContext context) {
        assert (this.condition != null);
        if (this.conditionExpression == null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this.conditionExpression = factory.createValueExpression(context.getELContext(), this.condition, Boolean.class);
        }
        return this.conditionExpression;
    }

    public String getToViewId(FacesContext context) {
        if (this.toViewId == null) {
            return null;
        }
        ValueExpression expression = this._getToViewIdExpression(context);
        return expression.isLiteralText() ? expression.getExpressionString() : (String)expression.getValue(context.getELContext());
    }

    private ValueExpression _getToViewIdExpression(FacesContext context) {
        assert (this.toViewId != null);
        if (this.toViewIdExpression == null) {
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            this.toViewIdExpression = factory.createValueExpression(context.getELContext(), this.toViewId, String.class);
        }
        return this.toViewIdExpression;
    }

    public boolean hasCondition() {
        return this.condition != null && this.condition.length() > 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.condition != null ? this.condition.hashCode() : 0);
        hash = 47 * hash + (this.fromAction != null ? this.fromAction.hashCode() : 0);
        hash = 47 * hash + (this.fromOutcome != null ? this.fromOutcome.hashCode() : 0);
        hash = 47 * hash + (this.fromViewId != null ? this.fromViewId.hashCode() : 0);
        hash = 47 * hash + (this.toViewId != null ? this.toViewId.hashCode() : 0);
        hash = 47 * hash + (this.toFlowDocumentId != null ? this.toFlowDocumentId.hashCode() : 0);
        hash = 47 * hash + (this.includeViewParams ? 1 : 0);
        hash = 47 * hash + (this.redirect ? 1 : 0);
        hash = 47 * hash + (this.parameters != null ? this.parameters.hashCode() : 0);
        hash = 47 * hash + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
        hash = 47 * hash + (this.toViewIdExpression != null ? this.toViewIdExpression.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationCaseImpl other = (NavigationCaseImpl)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        if (this.fromAction == null ? other.fromAction != null : !this.fromAction.equals(other.fromAction)) {
            return false;
        }
        if (this.fromOutcome == null ? other.fromOutcome != null : !this.fromOutcome.equals(other.fromOutcome)) {
            return false;
        }
        if (this.fromViewId == null ? other.fromViewId != null : !this.fromViewId.equals(other.fromViewId)) {
            return false;
        }
        if (this.toViewId == null ? other.toViewId != null : !this.toViewId.equals(other.toViewId)) {
            return false;
        }
        if (this.toFlowDocumentId == null ? other.toFlowDocumentId != null : !this.toFlowDocumentId.equals(other.toFlowDocumentId)) {
            return false;
        }
        if (this.includeViewParams != other.includeViewParams) {
            return false;
        }
        if (this.redirect != other.redirect) {
            return false;
        }
        if (!(this.parameters == other.parameters || this.parameters != null && this.parameters.equals(other.parameters))) {
            return false;
        }
        if (!(this.conditionExpression == other.conditionExpression || this.conditionExpression != null && this.conditionExpression.equals((Object)other.conditionExpression))) {
            return false;
        }
        return this.toViewIdExpression == other.toViewIdExpression || this.toViewIdExpression != null && this.toViewIdExpression.equals((Object)other.toViewIdExpression);
    }

    @Override
    public void freeze() {
        this.initialized = true;
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }
}

