/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl.formatter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.myfaces.extensions.cdi.message.api.Formatter;
import org.apache.myfaces.extensions.cdi.message.api.GenericConfig;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultNumberFormatter
implements Formatter<Number> {
    private static final long serialVersionUID = 1639250543559140704L;
    private Character groupingSeparator = null;
    private Character decimalSeparator = null;
    private Integer minimumFractionDigits = null;
    private Integer minimumIntegerDigits = null;
    private Integer maximumFractionDigits = null;
    private Integer maximumIntegerDigits = null;
    private String exponentSeparator = null;

    DefaultNumberFormatter() {
    }

    public boolean isResponsibleFor(Class<?> type) {
        return Number.class.isAssignableFrom(type);
    }

    public boolean isStateless() {
        return false;
    }

    public String format(MessageContext messageContext, Number valueToFormat) {
        Locale locale = messageContext.getLocale();
        GenericConfig formatterConfig = messageContext.config().getFormatterFactory().findFormatterConfig(Number.class, locale);
        if (formatterConfig != null) {
            this.useCustomConfig(formatterConfig);
        }
        if (valueToFormat instanceof BigDecimal || valueToFormat instanceof Double || valueToFormat instanceof Float) {
            return this.getDecimalFormat(locale).format(valueToFormat);
        }
        return this.getNumberFormat(locale).format(valueToFormat);
    }

    private void useCustomConfig(GenericConfig formatterConfig) {
        if (formatterConfig.containsProperty("grouping_separator")) {
            this.groupingSeparator = Character.valueOf(((String)((Object)formatterConfig.getProperty("grouping_separator", String.class))).charAt(0));
        }
        if (formatterConfig.containsProperty("decimal_separator")) {
            this.decimalSeparator = Character.valueOf(((String)((Object)formatterConfig.getProperty("decimal_separator", String.class))).charAt(0));
        }
        if (formatterConfig.containsProperty("minimum_fraction_digits")) {
            this.minimumFractionDigits = (Integer)formatterConfig.getProperty("minimum_fraction_digits", Integer.class);
        }
        if (formatterConfig.containsProperty("minimum_integer_digits")) {
            this.minimumIntegerDigits = (Integer)formatterConfig.getProperty("minimum_integer_digits", Integer.class);
        }
        if (formatterConfig.containsProperty("maximum_fraction_digits")) {
            this.maximumFractionDigits = (Integer)formatterConfig.getProperty("maximum_fraction_digits", Integer.class);
        }
        if (formatterConfig.containsProperty("maximum_integer_digits")) {
            this.maximumIntegerDigits = (Integer)formatterConfig.getProperty("maximum_integer_digits", Integer.class);
        }
        if (formatterConfig.containsProperty("exponent_separator")) {
            this.exponentSeparator = (String)((Object)formatterConfig.getProperty("exponent_separator", String.class));
        }
    }

    private NumberFormat getNumberFormat(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        if (this.groupingSeparator != null) {
            symbols.setGroupingSeparator(this.groupingSeparator.charValue());
        }
        if (this.decimalSeparator != null) {
            symbols.setDecimalSeparator(this.decimalSeparator.charValue());
        }
        if (this.exponentSeparator != null) {
            symbols.setExponentSeparator(this.exponentSeparator);
        }
        return new DecimalFormat("", symbols);
    }

    private NumberFormat getDecimalFormat(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        if (this.groupingSeparator != null) {
            symbols.setGroupingSeparator(this.groupingSeparator.charValue());
        }
        if (this.decimalSeparator != null) {
            symbols.setDecimalSeparator(this.decimalSeparator.charValue());
        }
        if (this.exponentSeparator != null) {
            symbols.setExponentSeparator(this.exponentSeparator);
        }
        DecimalFormat format = new DecimalFormat("", symbols);
        if (this.minimumFractionDigits != null) {
            format.setMinimumFractionDigits(this.minimumFractionDigits);
        }
        if (this.minimumIntegerDigits != null) {
            format.setMinimumIntegerDigits(this.minimumIntegerDigits);
        }
        if (this.maximumFractionDigits != null) {
            format.setMaximumFractionDigits(this.maximumFractionDigits);
        }
        if (this.maximumIntegerDigits != null) {
            format.setMaximumIntegerDigits(this.maximumIntegerDigits);
        }
        return format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultNumberFormatter)) {
            return false;
        }
        DefaultNumberFormatter that = (DefaultNumberFormatter)o;
        if (this.decimalSeparator != null ? !this.decimalSeparator.equals(that.decimalSeparator) : that.decimalSeparator != null) {
            return false;
        }
        if (this.exponentSeparator != null ? !this.exponentSeparator.equals(that.exponentSeparator) : that.exponentSeparator != null) {
            return false;
        }
        if (this.groupingSeparator != null ? !this.groupingSeparator.equals(that.groupingSeparator) : that.groupingSeparator != null) {
            return false;
        }
        if (this.maximumFractionDigits != null ? !this.maximumFractionDigits.equals(that.maximumFractionDigits) : that.maximumFractionDigits != null) {
            return false;
        }
        if (this.maximumIntegerDigits != null ? !this.maximumIntegerDigits.equals(that.maximumIntegerDigits) : that.maximumIntegerDigits != null) {
            return false;
        }
        if (this.minimumFractionDigits != null ? !this.minimumFractionDigits.equals(that.minimumFractionDigits) : that.minimumFractionDigits != null) {
            return false;
        }
        return !(this.minimumIntegerDigits != null ? !this.minimumIntegerDigits.equals(that.minimumIntegerDigits) : that.minimumIntegerDigits != null);
    }

    public int hashCode() {
        int result = this.groupingSeparator != null ? this.groupingSeparator.hashCode() : 0;
        result = 31 * result + (this.decimalSeparator != null ? this.decimalSeparator.hashCode() : 0);
        result = 31 * result + (this.minimumFractionDigits != null ? this.minimumFractionDigits.hashCode() : 0);
        result = 31 * result + (this.minimumIntegerDigits != null ? this.minimumIntegerDigits.hashCode() : 0);
        return result;
    }
}

