/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core;

import java.lang.annotation.Annotation;
import org.apache.myfaces.extensions.validator.core.DefaultProjectStageResolver;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.ProjectStageResolver;
import org.apache.myfaces.extensions.validator.core.WebXmlParameter;
import org.apache.myfaces.extensions.validator.core.proxy.DefaultProxyHelper;
import org.apache.myfaces.extensions.validator.core.proxy.ProxyHelper;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRendererProxy;
import org.apache.myfaces.extensions.validator.core.validation.ConstraintSource;
import org.apache.myfaces.extensions.validator.core.validation.IgnoreConstraintSource;
import org.apache.myfaces.extensions.validator.core.validation.TargetProperty;
import org.apache.myfaces.extensions.validator.core.validation.TargetPropertyId;
import org.apache.myfaces.extensions.validator.core.validation.parameter.DisableClientSideValidation;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ValidationParameter;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ViolationSeverity;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultExtValCoreConfiguration
extends ExtValCoreConfiguration {
    private static final String GLOBAL_PROPERTY_MODE_INIT_REQUIRED = "mode:init:required";
    private static final String GLOBAL_PROPERTY_MODE_RESET_REQUIRED = "mode:reset:required";

    @Override
    public String customMessageBundleBaseName() {
        return WebXmlParameter.CUSTOM_MESSAGE_BUNDLE;
    }

    @Override
    public String customBasePackage() {
        return WebXmlParameter.CUSTOM_BASE_PACKAGE;
    }

    @Override
    public String customInformationProviderBeanClassName() {
        return WebXmlParameter.CUSTOM_INFORMATION_PROVIDER_BEAN;
    }

    @Override
    public String customComponentMetaDataExtractorClassName() {
        return WebXmlParameter.CUSTOM_COMPONENT_META_DATA_EXTRACTOR;
    }

    @Override
    public String customValidationParameterExtractorClassName() {
        return WebXmlParameter.CUSTOM_VALIDATION_PARAMETER_EXTRACTOR;
    }

    @Override
    public String customStaticValidationStrategyMappingSource() {
        return WebXmlParameter.CUSTOM_STATIC_VALIDATION_STRATEGY_MAPPING;
    }

    @Override
    public String customComponentInitializerClassName() {
        return WebXmlParameter.CUSTOM_COMPONENT_INITIALIZER;
    }

    @Override
    public String customValidationExceptionInterceptorClassName() {
        return WebXmlParameter.CUSTOM_VALIDATION_EXCEPTION_INTERCEPTOR;
    }

    @Override
    public String customPropertyValidationInterceptorClassName() {
        return WebXmlParameter.CUSTOM_PROPERTY_VALIDATION_INTERCEPTOR;
    }

    @Override
    public String customMetaDataExtractionInterceptorClassName() {
        return WebXmlParameter.CUSTOM_META_DATA_EXTRACTION_INTERCEPTOR;
    }

    @Override
    @ToDo(value=Priority.MEDIUM, description="The tryToInstantiateClassForName can return a null value which isn't handled correctly afterwards.  We should throw an exception like in rendererProxy method.")
    public ProxyHelper proxyHelper() {
        String customProxyHelperClassName = WebXmlParameter.CUSTOM_PROXY_HELPER;
        if (customProxyHelperClassName != null && !"".equals(customProxyHelperClassName)) {
            return (ProxyHelper)ClassUtils.tryToInstantiateClassForName(customProxyHelperClassName);
        }
        return new DefaultProxyHelper();
    }

    @Override
    public ProjectStageResolver projectStageResolver() {
        return new DefaultProjectStageResolver();
    }

    @Override
    public Class<? extends ExtValRendererProxy> rendererProxy() {
        String proxyClassName = (String)ExtValContext.getContext().getGlobalProperty(ExtValRendererProxy.KEY);
        if (proxyClassName != null && !proxyClassName.endsWith(this.getClass().getName())) {
            Class targetClass = ClassUtils.tryToLoadClassForName(proxyClassName);
            if (targetClass == null) {
                throw new IllegalStateException("a custom invalid renderer proxy is configured: " + proxyClassName);
            }
            return targetClass;
        }
        return null;
    }

    @Override
    public Class violationSeverity() {
        return ViolationSeverity.class;
    }

    @Override
    public String customValidationStrategyToMessageResolverNameMapperClassName() {
        return WebXmlParameter.CUSTOM_VALIDATION_STRATEGY_TO_MESSAGE_RESOLVER_NAME_MAPPER;
    }

    @Override
    public String customMetaDataToValidationStrategyNameMapperClassName() {
        return WebXmlParameter.CUSTOM_META_DATA_TO_VALIDATION_STRATEGY_NAME_MAPPER;
    }

    @Override
    public String customValidationStrategyToMetaDataTransformerNameMapperClassName() {
        return WebXmlParameter.CUSTOM_VALIDATION_STRATEGY_TO_META_DATA_TRANSFORMER_NAME_MAPPER;
    }

    @Override
    public String customMetaDataStorageFilterClassName() {
        return WebXmlParameter.CUSTOM_META_DATA_STORAGE_FILTER;
    }

    @Override
    public String customValidationStrategyFactoryClassName() {
        return WebXmlParameter.CUSTOM_VALIDATION_STRATEGY_FACTORY;
    }

    @Override
    public String customMessageResolverFactoryClassName() {
        return WebXmlParameter.CUSTOM_MESSAGE_RESOLVER_FACTORY;
    }

    @Override
    public String customComponentMetaDataExtractorFactoryClassName() {
        return WebXmlParameter.CUSTOM_COMPONENT_META_DATA_EXTRACTOR_FACTORY;
    }

    @Override
    public String customValidationParameterExtractorFactoryClassName() {
        return WebXmlParameter.CUSTOM_VALIDATION_PARAMETER_EXTRACTOR_FACTORY;
    }

    @Override
    public String customValidationParameterFactoryClassName() {
        return WebXmlParameter.CUSTOM_VALIDATION_PARAMETER_FACTORY;
    }

    @Override
    public String customMetaDataTransformerFactoryClassName() {
        return WebXmlParameter.CUSTOM_META_DATA_TRANSFORMER_FACTORY;
    }

    @Override
    public String customStorageManagerFactoryClassName() {
        return WebXmlParameter.CUSTOM_STORAGE_MANAGER_FACTORY;
    }

    @Override
    public String customFacesMessageFactoryClassName() {
        return WebXmlParameter.CUSTOM_FACES_MESSAGE_FACTORY;
    }

    @Override
    public Class<? extends Annotation> constraintSourceAnnotation() {
        return ConstraintSource.class;
    }

    @Override
    public Class<? extends Annotation> ignoreConstraintSourceAnnotation() {
        return IgnoreConstraintSource.class;
    }

    @Override
    public Class<? extends Annotation> targetPropertyAnnotation() {
        return TargetProperty.class;
    }

    @Override
    public Class<? extends Annotation> targetPropertyIdAnnotation() {
        return TargetPropertyId.class;
    }

    @Override
    public Class<? extends ValidationParameter> disableClientSideValidationValidationParameter() {
        return DisableClientSideValidation.class;
    }

    @Override
    public boolean activateRequiredInitialization() {
        Boolean globalProperty = (Boolean)ExtValContext.getContext().getGlobalProperty(GLOBAL_PROPERTY_MODE_INIT_REQUIRED);
        if (globalProperty != null) {
            return globalProperty;
        }
        return WebXmlParameter.ACTIVATE_REQUIRED_INITIALIZATION != null && "true".equalsIgnoreCase(WebXmlParameter.ACTIVATE_REQUIRED_INITIALIZATION);
    }

    public static void overruleActivateRequiredInitialization(Boolean value, boolean forceOverride) {
        ExtValContext.getContext().addGlobalProperty(GLOBAL_PROPERTY_MODE_INIT_REQUIRED, value, forceOverride);
    }

    @Override
    public boolean deactivateDefaultConvention() {
        return "true".equalsIgnoreCase(WebXmlParameter.DEACTIVATE_DEFAULT_CONVENTION);
    }

    @Override
    public boolean deactivateDefaultNameMappers() {
        String deactivateDefaultNameMappers = WebXmlParameter.DEACTIVATE_DEFAULT_NAME_MAPPERS;
        return deactivateDefaultNameMappers != null && deactivateDefaultNameMappers.equalsIgnoreCase("true");
    }

    @Override
    public boolean deactivateElResolver() {
        return false;
    }

    @Override
    public boolean deactivateComponentInitialization() {
        return "true".equalsIgnoreCase(WebXmlParameter.DEACTIVATE_COMPONENT_INITIALIZATION);
    }

    @Override
    public boolean deactivateValidationParameters() {
        return "true".equalsIgnoreCase(WebXmlParameter.DEACTIVATE_VALIDATION_PARAMETERS);
    }

    @Override
    public boolean deactivateRenderKitFactory() {
        return "true".equalsIgnoreCase(WebXmlParameter.DEACTIVATE_RENDER_KIT_FACTORY);
    }

    @Override
    public boolean deactivateRequiredAttributeSupport() {
        Boolean globalProperty = (Boolean)ExtValContext.getContext().getGlobalProperty(GLOBAL_PROPERTY_MODE_RESET_REQUIRED);
        if (globalProperty != null) {
            return globalProperty;
        }
        return WebXmlParameter.DEACTIVATE_REQUIRED_ATTRIBUTE_SUPPORT != null && "true".equalsIgnoreCase(WebXmlParameter.DEACTIVATE_REQUIRED_ATTRIBUTE_SUPPORT);
    }

    public static void overruleDeactivateRequiredAttributeSupport(Boolean value, boolean forceOverride) {
        ExtValContext.getContext().addGlobalProperty(GLOBAL_PROPERTY_MODE_RESET_REQUIRED, value, forceOverride);
    }

    @Override
    public boolean interpretEmptyStringSubmittedValuesAsNull() {
        return !"false".equalsIgnoreCase(WebXmlParameter.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL);
    }

    @Override
    public boolean validateEmptyFields() {
        return !"false".equalsIgnoreCase(WebXmlParameter.VALIDATE_EMPTY_FIELDS);
    }
}

