/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.myfaces.extensions.validator.core.InvocationOrderComparator;
import org.apache.myfaces.extensions.validator.core.factory.NameMapperAwareFactory;
import org.apache.myfaces.extensions.validator.core.mapper.NameMapper;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.API})
public abstract class AbstractNameMapperAwareFactory<T>
implements NameMapperAwareFactory<NameMapper<T>> {
    private List<Class> deniedNameMapperList = new CopyOnWriteArrayList<Class>();

    @Override
    public synchronized void register(NameMapper<T> nameMapper) {
        if (!this.deniedNameMapperList.contains(nameMapper.getClass())) {
            this.getNameMapperList().add(nameMapper);
            List<NameMapper<T>> nameMapperList = this.getNameMapperList();
            if (nameMapperList instanceof CopyOnWriteArrayList) {
                ArrayList<NameMapper<T>> sortableList = new ArrayList<NameMapper<T>>(nameMapperList);
                Collections.sort(sortableList, this.getComparator());
                nameMapperList.clear();
                nameMapperList.addAll(sortableList);
            } else {
                Collections.sort(nameMapperList, this.getComparator());
            }
        }
    }

    protected Comparator<NameMapper<T>> getComparator() {
        return new InvocationOrderComparator<NameMapper<T>>();
    }

    @Override
    public synchronized void deregister(Class<? extends NameMapper> classToDeregister) {
        Iterator<NameMapper<T>> nameMapperIterator = this.getNameMapperList().iterator();
        while (nameMapperIterator.hasNext()) {
            if (!nameMapperIterator.next().getClass().getName().equals(classToDeregister.getName())) continue;
            nameMapperIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deny(Class<? extends NameMapper> classToDeny) {
        this.deregister(classToDeny);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.deniedNameMapperList.add(classToDeny);
        }
    }

    protected abstract List<NameMapper<T>> getNameMapperList();
}

