/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

class MulticaretHandler {
    private final Document doc;
    private ArrayList<MutablePositionRegion> regions = null;

    static MulticaretHandler create(JTextComponent c) {
        return new MulticaretHandler(c);
    }

    private MulticaretHandler(JTextComponent c) {
        this.doc = c.getDocument();
        this.doc.render(() -> {
            List<CaretInfo> carets;
            Caret caret = c.getCaret();
            if (caret instanceof EditorCaret && (carets = ((EditorCaret)caret).getCarets()).size() > 1) {
                this.regions = new ArrayList(carets.size());
                carets.forEach(ci -> {
                    try {
                        int[] block = ci.isSelectionShowing() ? null : Utilities.getIdentifierBlock(c, ci.getDot());
                        Position start = NbDocument.createPosition(this.doc, block != null ? block[0] : ci.getSelectionStart(), Position.Bias.Backward);
                        Position end = NbDocument.createPosition(this.doc, block != null ? block[1] : ci.getSelectionEnd(), Position.Bias.Forward);
                        this.regions.add(new MutablePositionRegion(start, end));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                });
                Collections.reverse(this.regions);
            }
        });
    }

    void release() {
        String firstRegionText = this.getFirstRegionText();
        if (firstRegionText != null) {
            int regionCount = this.regions.size();
            for (int i = 1; i < regionCount; ++i) {
                MutablePositionRegion region = this.regions.get(i);
                int offset = region.getStartOffset();
                int length = region.getEndOffset() - offset;
                try {
                    CharSequence old = DocumentUtilities.getText(this.doc, offset, length);
                    if (CharSequenceUtilities.textEquals(firstRegionText, old)) continue;
                    int res = -1;
                    int k = 0;
                    while (k < Math.min(old.length(), firstRegionText.length()) && old.charAt(k) == firstRegionText.charAt(k)) {
                        res = k++;
                    }
                    String insert = firstRegionText.substring(res + 1);
                    CharSequence remove = old.subSequence(res + 1, old.length());
                    if (insert.length() > 0) {
                        this.doc.insertString(offset + res + 1, insert, null);
                    }
                    if (remove.length() <= 0) continue;
                    this.doc.remove(offset + res + 1 + insert.length(), remove.length());
                    continue;
                }
                catch (BadLocationException e) {
                    Exceptions.printStackTrace(e);
                }
            }
        }
    }

    private String getFirstRegionText() {
        return this.getRegionText(0);
    }

    private String getRegionText(int regionIndex) {
        if (this.regions != null) {
            try {
                MutablePositionRegion region = this.regions.get(regionIndex);
                int offset = region.getStartOffset();
                int length = region.getEndOffset() - offset;
                return this.doc.getText(offset, length);
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace(e);
            }
        }
        return null;
    }
}

