/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.support.ProfileSupport;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.project.ui.Bundle;
import org.netbeans.modules.java.project.ui.FixProfile;
import org.netbeans.modules.java.project.ui.ProjectProblemsProviders;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class ProfileProblemsProviderImpl
implements ProjectProblemsProvider,
PropertyChangeListener,
ChangeListener,
Runnable {
    private static final String LIB_PREFIX = "${libs.";
    private static final String PRJ_PREFIX = "${reference.";
    private static final String FILE_PREFIX = "${file.reference.";
    private static final String REF_PREFIX = "${";
    private static final String VOL_CLASSPATH = "classpath";
    private static final char PATH_SEPARATOR_CHAR = ':';
    private static final String ICON_LIBRARIES = "org/netbeans/modules/java/project/ui/resources/libraries.gif";
    private static final String ICON_FILE = "org/netbeans/modules/java/project/ui/resources/jar.gif";
    private static final int SLIDING_DELAY = 1000;
    private static final Logger LOG = Logger.getLogger(ProfileProblemsProviderImpl.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ProjectProblemsProviders.class);
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper referenceHelper;
    private final PropertyEvaluator evaluator;
    private final String profileProperty;
    private final Set<String> classPathProperties;
    private final ProjectProblemsProviderSupport problemsProviderSupport;
    private final Collection<SourceLevelQuery.Result> foreignSlResults;
    private final RequestProcessor.Task firer;
    private final Object listenersInitLock = new Object();
    private ClassPath classPath;
    private SourceLevelQuery.Result slRes;

    ProfileProblemsProviderImpl(@NonNull AntProjectHelper antProjectHelper, @NonNull ReferenceHelper referenceHelper, @NonNull PropertyEvaluator evaluator, @NonNull String profileProperty, String ... classPathProperties) {
        assert (antProjectHelper != null);
        assert (referenceHelper != null);
        assert (evaluator != null);
        assert (profileProperty != null);
        assert (classPathProperties != null);
        this.antProjectHelper = antProjectHelper;
        this.referenceHelper = referenceHelper;
        this.evaluator = evaluator;
        this.profileProperty = profileProperty;
        this.classPathProperties = new HashSet<String>(Arrays.asList(classPathProperties));
        this.problemsProviderSupport = new ProjectProblemsProviderSupport(this);
        this.foreignSlResults = Collections.synchronizedCollection(new ArrayList());
        this.firer = RP.create(this);
    }

    @Override
    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull("listener", listener);
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull("listener", listener);
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    @Override
    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            @Override
            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                return ProjectManager.mutex().readAccess(new Mutex.Action<Collection<? extends ProjectProblemsProvider.ProjectProblem>>(){

                    @Override
                    public Collection<? extends ProjectProblemsProvider.ProjectProblem> run() {
                        SourceLevelQuery.Result mySL = ProfileProblemsProviderImpl.this.listenenOnProjectMetadata();
                        SourceLevelQuery.Profile profile = mySL.getProfile();
                        if (profile == SourceLevelQuery.Profile.DEFAULT) {
                            return Collections.emptySet();
                        }
                        Set<Reference> problems = ProfileProblemsProviderImpl.this.collectReferencesWithWrongProfile(profile);
                        if (problems.isEmpty()) {
                            return Collections.emptySet();
                        }
                        SourceLevelQuery.Profile minProfile = null;
                        for (Reference problem : problems) {
                            SourceLevelQuery.Profile problemProfile = problem.getRequiredProfile();
                            minProfile = ProfileProblemsProviderImpl.max(minProfile, problemProfile);
                        }
                        return Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError(Bundle.LBL_InvalidProfile(), minProfile != null ? Bundle.DESC_InvalidProfile(profile.getDisplayName(), minProfile.getDisplayName()) : Bundle.DESC_IllegalProfile(), new ProfileResolver(ProfileProblemsProviderImpl.this.antProjectHelper, ProfileProblemsProviderImpl.this.profileProperty, profile, problems)));
                    }
                });
            }
        });
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if ("roots".equals(propName) || "installedPlatforms".equals(propName)) {
            this.firer.schedule(1000);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.firer.schedule(1000);
    }

    @Override
    public void run() {
        this.problemsProviderSupport.fireProblemsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceLevelQuery.Result listenenOnProjectMetadata() {
        Object object = this.listenersInitLock;
        synchronized (object) {
            if (this.slRes == null) {
                assert (this.classPath == null);
                JavaPlatformManager jpm = JavaPlatformManager.getDefault();
                jpm.addPropertyChangeListener(WeakListeners.propertyChange(this, jpm));
                this.slRes = SourceLevelQuery.getSourceLevel2(this.antProjectHelper.getProjectDirectory());
                this.slRes.addChangeListener(this);
                File baseFolder = FileUtil.toFile(this.antProjectHelper.getProjectDirectory());
                if (baseFolder != null) {
                    ClassPath cp = ClassPathFactory.createClassPath(ProjectClassPathSupport.createPropertyBasedClassPathImplementation(baseFolder, this.evaluator, this.classPathProperties.toArray(new String[0])));
                    cp.addPropertyChangeListener(this);
                    cp.getRoots();
                    this.classPath = cp;
                }
            }
            return this.slRes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Set<Reference> collectReferencesWithWrongProfile(@NonNull SourceLevelQuery.Profile currentProfile) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        HashSet<Reference> res = new HashSet<Reference>();
        EditableProperties projectProps = this.antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProps = this.antProjectHelper.getProperties("nbproject/private/private.properties");
        EditableProperties globalProps = PropertyUtils.getGlobalProperties();
        ArrayDeque newSlResults = new ArrayDeque();
        for (String cpId : this.classPathProperties) {
            ProfileProblemsProviderImpl.collectReferencesWithWrongProfileImpl(cpId, currentProfile, this.antProjectHelper, this.evaluator, this.referenceHelper, projectProps, privateProps, globalProps, res, newSlResults);
        }
        Collection<SourceLevelQuery.Result> collection = this.foreignSlResults;
        synchronized (collection) {
            Iterator<SourceLevelQuery.Result> it = this.foreignSlResults.iterator();
            while (it.hasNext()) {
                SourceLevelQuery.Result cslr = it.next();
                it.remove();
                cslr.removeChangeListener(this);
            }
            assert (this.foreignSlResults.isEmpty());
            for (SourceLevelQuery.Result cslr : newSlResults) {
                cslr.addChangeListener(this);
                this.foreignSlResults.add(cslr);
            }
        }
        return res;
    }

    private static void collectReferencesWithWrongProfileImpl(@NonNull String classPathId, @NonNull SourceLevelQuery.Profile requiredProfile, @NonNull AntProjectHelper antProjectHelper, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper, @NonNull EditableProperties projectProps, @NonNull EditableProperties privateProps, @NonNull EditableProperties globalProps, @NonNull Set<? super Reference> collector, @NonNull Collection<? super SourceLevelQuery.Result> slResCollector) {
        String cp = projectProps.getProperty(classPathId);
        if (cp == null) {
            cp = privateProps.getProperty(classPathId);
        }
        if (cp == null) {
            cp = globalProps.getProperty(classPathId);
        }
        if (cp != null) {
            ArrayDeque<String> todo = new ArrayDeque<String>(Arrays.asList(PropertyUtils.tokenizePath(cp)));
            while (!todo.isEmpty()) {
                SourceLevelQuery.Profile maxProfile;
                Collection<ProfileSupport.Violation> res;
                String rawEntry = (String)todo.remove();
                String propName = ProfileProblemsProviderImpl.getAntPropertyName(rawEntry);
                if (propName == null) continue;
                if (rawEntry.startsWith(LIB_PREFIX)) {
                    String libName = rawEntry.substring(LIB_PREFIX.length(), rawEntry.lastIndexOf(46));
                    Library lib = refHelper.findLibrary(libName);
                    if (lib == null || (res = ProfileSupport.findProfileViolations(requiredProfile, Collections.emptySet(), lib.getContent(VOL_CLASSPATH), Collections.emptySet(), EnumSet.of(ProfileSupport.Validation.BINARIES_BY_MANIFEST))).isEmpty()) continue;
                    maxProfile = ProfileProblemsProviderImpl.findMaxProfile(res);
                    collector.add(new LibraryReference(classPathId, rawEntry, maxProfile, lib));
                    continue;
                }
                if (rawEntry.startsWith(PRJ_PREFIX)) {
                    Object[] ref = refHelper.findArtifactAndLocation(rawEntry);
                    if (ref[0] == null) continue;
                    AntArtifact artifact = (AntArtifact)ref[0];
                    SourceLevelQuery.Result slRes = SourceLevelQuery.getSourceLevel2(artifact.getProject().getProjectDirectory());
                    slResCollector.add(slRes);
                    SourceLevelQuery.Profile minProfile = slRes.getProfile();
                    if (!ProfileProblemsProviderImpl.isBroken(requiredProfile, minProfile)) continue;
                    collector.add(new ProjectReference(classPathId, rawEntry, minProfile, artifact.getProject()));
                    continue;
                }
                if (rawEntry.startsWith(FILE_PREFIX)) {
                    Collection<ProfileSupport.Violation> res2;
                    File file;
                    URL root;
                    String path = eval.getProperty(propName);
                    if (path == null || (root = FileUtil.urlForArchiveOrDir(file = antProjectHelper.resolveFile(path))) == null || (res2 = ProfileSupport.findProfileViolations(requiredProfile, Collections.emptySet(), Collections.singleton(root), Collections.emptySet(), EnumSet.of(ProfileSupport.Validation.BINARIES_BY_MANIFEST))).isEmpty()) continue;
                    SourceLevelQuery.Profile maxProfile2 = ProfileProblemsProviderImpl.findMaxProfile(res2);
                    collector.add(new FileReference(classPathId, rawEntry, maxProfile2, file));
                    continue;
                }
                if (rawEntry.startsWith(REF_PREFIX)) {
                    ProfileProblemsProviderImpl.collectReferencesWithWrongProfileImpl(propName, requiredProfile, antProjectHelper, eval, refHelper, projectProps, privateProps, globalProps, collector, slResCollector);
                    continue;
                }
                File file = antProjectHelper.resolveFile(propName);
                URL root = FileUtil.urlForArchiveOrDir(file);
                if (root == null || (res = ProfileSupport.findProfileViolations(requiredProfile, Collections.emptySet(), Collections.singleton(root), Collections.emptySet(), EnumSet.of(ProfileSupport.Validation.BINARIES_BY_MANIFEST))).isEmpty()) continue;
                maxProfile = ProfileProblemsProviderImpl.findMaxProfile(res);
                collector.add(new FileReference(classPathId, rawEntry, maxProfile, file));
            }
        }
    }

    private static boolean isBroken(@NonNull SourceLevelQuery.Profile requiredProfile, @NullAllowed SourceLevelQuery.Profile profile) {
        if (profile == null) {
            return true;
        }
        SourceLevelQuery.Profile max = ProfileProblemsProviderImpl.max(requiredProfile, profile);
        return !max.equals((Object)SourceLevelQuery.Profile.DEFAULT) && !max.equals((Object)requiredProfile);
    }

    @CheckForNull
    private static String getAntPropertyName(@NullAllowed String reference) {
        if (reference != null && reference.startsWith(REF_PREFIX) && reference.endsWith("}")) {
            reference = reference.substring(2, reference.length() - 1);
        }
        return reference;
    }

    @CheckForNull
    private static SourceLevelQuery.Profile findMaxProfile(@NonNull Iterable<? extends ProfileSupport.Violation> violations) {
        SourceLevelQuery.Profile current = null;
        for (ProfileSupport.Violation violation : violations) {
            SourceLevelQuery.Profile p = violation.getRequiredProfile();
            if (p == null) {
                return null;
            }
            current = ProfileProblemsProviderImpl.max(current, p);
        }
        return current;
    }

    @CheckForNull
    static SourceLevelQuery.Profile max(@NullAllowed SourceLevelQuery.Profile a, @NullAllowed SourceLevelQuery.Profile b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        return a.compareTo(b) <= 0 ? b : a;
    }

    @NonNull
    static SourceLevelQuery.Profile requiredProfile(@NonNull Collection<? extends Reference> state, @NonNull SourceLevelQuery.Profile initial) {
        SourceLevelQuery.Profile current = initial;
        for (Reference reference : state) {
            current = ProfileProblemsProviderImpl.max(current, reference.getRequiredProfile());
        }
        return current;
    }

    private static final class LibraryReference
    extends Reference {
        private final Library lib;

        private LibraryReference(@NonNull String classPathId, @NonNull String rawId, @NullAllowed SourceLevelQuery.Profile requiredProfile, @NonNull Library lib) {
            super(classPathId, rawId, requiredProfile);
            Parameters.notNull("lib", lib);
            this.lib = lib;
        }

        @Override
        String getDisplayName() {
            return this.lib.getDisplayName();
        }

        @Override
        String getToolTipText() {
            return this.lib.getDisplayName();
        }

        @Override
        Icon getIcon() {
            return ImageUtilities.loadImageIcon(ProfileProblemsProviderImpl.ICON_LIBRARIES, false);
        }
    }

    private static final class ProjectReference
    extends Reference {
        private final Project prj;

        private ProjectReference(@NonNull String classPathId, @NonNull String rawId, @NullAllowed SourceLevelQuery.Profile requiredProfile, @NonNull Project prj) {
            super(classPathId, rawId, requiredProfile);
            Parameters.notNull("prj", prj);
            this.prj = prj;
        }

        @Override
        String getDisplayName() {
            return ProjectUtils.getInformation(this.prj).getDisplayName();
        }

        @Override
        String getToolTipText() {
            return FileUtil.getFileDisplayName(this.prj.getProjectDirectory());
        }

        @Override
        Icon getIcon() {
            return ProjectUtils.getInformation(this.prj).getIcon();
        }
    }

    private static final class FileReference
    extends Reference {
        private final File file;

        private FileReference(@NonNull String classPathId, @NonNull String rawId, @NullAllowed SourceLevelQuery.Profile requiredProfile, @NonNull File file) {
            super(classPathId, rawId, requiredProfile);
            Parameters.notNull("file", file);
            this.file = file;
        }

        @Override
        String getDisplayName() {
            return this.file.getName();
        }

        @Override
        String getToolTipText() {
            return this.file.getAbsolutePath();
        }

        @Override
        Icon getIcon() {
            return ImageUtilities.loadImageIcon(ProfileProblemsProviderImpl.ICON_FILE, false);
        }
    }

    static abstract class Reference {
        private final String classPathId;
        private final String rawId;
        private final SourceLevelQuery.Profile requiredProfile;

        private Reference(@NonNull String classPathId, @NonNull String rawId, @NullAllowed SourceLevelQuery.Profile requiredProfile) {
            Parameters.notNull("classPathId", classPathId);
            Parameters.notNull("rawId", rawId);
            this.classPathId = classPathId;
            this.rawId = rawId;
            this.requiredProfile = requiredProfile;
        }

        @NonNull
        abstract String getDisplayName();

        @NonNull
        abstract String getToolTipText();

        @NonNull
        abstract Icon getIcon();

        @CheckForNull
        final SourceLevelQuery.Profile getRequiredProfile() {
            return this.requiredProfile;
        }

        private void remove(@NonNull AntProjectHelper helper) {
            EditableProperties props = helper.getProperties("nbproject/project.properties");
            String rawPath = props.getProperty(this.classPathId);
            if (rawPath != null) {
                String[] pathElements = PropertyUtils.tokenizePath(rawPath);
                ArrayList<Object> result = new ArrayList<Object>(pathElements.length);
                boolean changed = false;
                for (String pathElement : pathElements) {
                    if (this.rawId.equals(pathElement)) {
                        changed = true;
                        continue;
                    }
                    result.add(pathElement + ":");
                }
                if (!result.isEmpty()) {
                    String last = (String)result.get(result.size() - 1);
                    result.set(result.size() - 1, last.substring(0, last.length() - 1));
                }
                if (changed) {
                    props.setProperty(this.classPathId, result.toArray(new String[0]));
                    helper.putProperties("nbproject/project.properties", props);
                }
            }
        }

        public int hashCode() {
            int hash = 17;
            hash = 31 * hash + this.classPathId.hashCode();
            hash = 31 * hash + this.rawId.hashCode();
            return hash;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Reference)) {
                return false;
            }
            Reference otherRef = (Reference)other;
            return this.classPathId.equals(otherRef.classPathId) && this.rawId.equals(otherRef.rawId);
        }
    }

    private static final class ProfileResolver
    implements ProjectProblemResolver {
        private final AntProjectHelper antProjectHelper;
        private final String profileProperty;
        private final SourceLevelQuery.Profile currentProfile;
        private final Collection<? extends Reference> state;

        private ProfileResolver(@NonNull AntProjectHelper antProjectHelper, @NonNull String profileProperty, @NonNull SourceLevelQuery.Profile currentProfile, @NonNull Collection<? extends Reference> state) {
            assert (antProjectHelper != null);
            assert (profileProperty != null);
            assert (currentProfile != null);
            assert (state != null);
            this.antProjectHelper = antProjectHelper;
            this.profileProperty = profileProperty;
            this.currentProfile = currentProfile;
            this.state = state;
        }

        @Override
        public Future<ProjectProblemsProvider.Result> resolve() {
            JButton ok = new JButton(Bundle.LBL_ResolveButton());
            ok.getAccessibleContext().setAccessibleName(Bundle.AN_ResolveButton());
            ok.getAccessibleContext().setAccessibleDescription(Bundle.AD_ResolveButton());
            final FixProfile panel = new FixProfile(ok, this.currentProfile, this.state);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.LBL_ResolveProfile(), true, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, null, null);
            if (DialogDisplayer.getDefault().notify(dd) == ok) {
                return RP.submit(new Callable<ProjectProblemsProvider.Result>(){

                    @Override
                    public ProjectProblemsProvider.Result call() throws Exception {
                        ProjectProblemsProvider.Status status = ProjectProblemsProvider.Status.UNRESOLVED;
                        try {
                            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                                @Override
                                public Void run() throws IOException {
                                    boolean shouldUpdate = panel.shouldUpdateProfile();
                                    if (shouldUpdate) {
                                        SourceLevelQuery.Profile newProfile = panel.getProfile();
                                        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                                        if (newProfile == null || newProfile == SourceLevelQuery.Profile.DEFAULT) {
                                            editableProperties.remove(profileProperty);
                                        } else {
                                            editableProperties.put(profileProperty, newProfile.getName());
                                        }
                                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                                    }
                                    for (Reference reference : panel.getRootsToRemove()) {
                                        reference.remove(antProjectHelper);
                                    }
                                    ProjectManager.getDefault().saveProject(FileOwnerQuery.getOwner(antProjectHelper.getProjectDirectory()));
                                    return null;
                                }
                            });
                            status = ProjectProblemsProvider.Status.RESOLVED;
                        }
                        catch (MutexException e) {
                            Exceptions.printStackTrace(e);
                        }
                        return ProjectProblemsProvider.Result.create(status);
                    }
                });
            }
            FutureTask<ProjectProblemsProvider.Result> res = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

                @Override
                public ProjectProblemsProvider.Result call() {
                    return ProjectProblemsProvider.Result.create(ProjectProblemsProvider.Status.UNRESOLVED);
                }
            });
            res.run();
            return res;
        }

        @Override
        public int hashCode() {
            int res = 17;
            FileObject projDir = this.antProjectHelper.getProjectDirectory();
            res = res * 31 + (projDir == null ? 0 : projDir.toURI().hashCode());
            res = res * 31 + this.currentProfile.hashCode();
            return res;
        }

        @Override
        public boolean equals(@NullAllowed Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ProfileResolver)) {
                return false;
            }
            ProfileResolver otherResolver = (ProfileResolver)other;
            FileObject projDir = this.antProjectHelper.getProjectDirectory();
            FileObject otherProjDir = otherResolver.antProjectHelper.getProjectDirectory();
            return this.currentProfile.equals((Object)otherResolver.currentProfile) && (projDir == null ? otherProjDir == null : projDir.equals(otherProjDir));
        }
    }
}

