/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.classfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import jpt.sun.tools.classfile.Attribute;
import jpt.sun.tools.classfile.ClassFile;
import jpt.sun.tools.classfile.ConstantPool;
import jpt.sun.tools.classfile.FatalError;

public class ClassReader {
    private DataInputStream in;
    private ClassFile classFile;
    private Attribute.Factory attributeFactory;

    ClassReader(ClassFile classFile, InputStream in, Attribute.Factory attributeFactory) throws IOException {
        this.classFile = Objects.requireNonNull(classFile);
        this.attributeFactory = Objects.requireNonNull(attributeFactory);
        this.in = new DataInputStream(new BufferedInputStream(in));
    }

    ClassFile getClassFile() {
        return this.classFile;
    }

    ConstantPool getConstantPool() {
        return this.classFile.constant_pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute readAttribute() throws IOException {
        int name_index = this.readUnsignedShort();
        int length = this.readInt();
        if (length < 0) {
            String attrName;
            try {
                attrName = this.getConstantPool().getUTF8Value(name_index);
            }
            catch (ConstantPool.InvalidIndex | ConstantPool.UnexpectedEntry e) {
                attrName = "";
            }
            throw new FatalError(String.format("attribute %s too big to handle", attrName));
        }
        byte[] data = new byte[length];
        this.readFully(data);
        DataInputStream prev = this.in;
        this.in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            Attribute attribute = this.attributeFactory.createAttribute(this, name_index, data);
            return attribute;
        }
        finally {
            this.in = prev;
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

