/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.NetigsoFramework;
import org.netbeans.NetigsoModule;
import org.netbeans.TopSecurityManager;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class NetigsoHandle {
    private final ModuleManager mgr;
    private final ArrayList<Module> toEnable = new ArrayList();
    private NetigsoFramework framework;
    private List<NetigsoModule> toInit = new ArrayList<NetigsoModule>();

    NetigsoHandle(ModuleManager mgr) {
        this.mgr = mgr;
    }

    final NetigsoFramework getDefault() {
        return this.getDefault(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetigsoFramework getDefault(Lookup lkp) {
        Class<NetigsoFramework> clazz = NetigsoFramework.class;
        synchronized (NetigsoFramework.class) {
            if (this.framework != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.framework;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            NetigsoFramework created = null;
            if (lkp != null) {
                NetigsoFramework prototype = lkp.lookup(NetigsoFramework.class);
                if (prototype == null) {
                    throw new IllegalStateException("No NetigsoFramework found, is org.netbeans.core.netigso module enabled?");
                }
                created = prototype.bindTo(this.mgr);
            }
            Class<NetigsoFramework> clazz2 = NetigsoFramework.class;
            synchronized (NetigsoFramework.class) {
                if (this.framework == null && created != null) {
                    this.framework = created;
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return this.framework;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void shutdownFramework() {
        Class<NetigsoFramework> clazz = NetigsoFramework.class;
        synchronized (NetigsoFramework.class) {
            NetigsoFramework f = this.framework;
            this.framework = null;
            this.toInit = new ArrayList<NetigsoModule>();
            ArrayList<Module> arrayList = this.toEnable;
            synchronized (arrayList) {
                this.toEnable.clear();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (f != null) {
                f.shutdown();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void willEnable(List<Module> newlyEnabling) {
        ArrayList<Module> arrayList = this.toEnable;
        synchronized (arrayList) {
            this.toEnable.addAll(newlyEnabling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<Module> turnOn(ClassLoader findNetigsoFrameworkIn, Collection<Module> allModules) throws InvalidException {
        boolean found = false;
        if (this.getDefault() == null) {
            ArrayList<Module> arrayList = this.toEnable;
            synchronized (arrayList) {
                for (Module m : this.toEnable) {
                    if (!(m instanceof NetigsoModule)) continue;
                    found = true;
                    break;
                }
            }
        } else {
            found = true;
        }
        if (!found) {
            return Collections.emptySet();
        }
        Lookup lkp = Lookups.metaInfServices(findNetigsoFrameworkIn);
        this.getDefault(lkp).prepare(lkp, allModules);
        ArrayList<Module> arrayList = this.toEnable;
        synchronized (arrayList) {
            this.toEnable.clear();
            this.toEnable.trimToSize();
        }
        this.delayedInit(this.mgr);
        Set<String> cnbs = this.getDefault().start(allModules);
        if (cnbs == null) {
            return Collections.emptySet();
        }
        HashSet<Module> additional = new HashSet<Module>();
        for (Module m : allModules) {
            if (m.isEnabled() || !cnbs.contains(m.getCodeNameBase())) continue;
            additional.add(m);
        }
        return additional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delayedInit(ModuleManager mgr) throws InvalidException {
        List<NetigsoModule> init;
        NetigsoHandle netigsoHandle = this;
        synchronized (netigsoHandle) {
            init = this.toInit;
            this.toInit = null;
            if (init == null || init.isEmpty()) {
                return true;
            }
        }
        HashSet<NetigsoModule> problematic = new HashSet<NetigsoModule>();
        for (NetigsoModule nm : init) {
            try {
                nm.start();
            }
            catch (IOException ex) {
                nm.setEnabled(false);
                InvalidException invalid = new InvalidException(nm, ex.getMessage());
                nm.setProblem(invalid);
                problematic.add(nm);
            }
        }
        if (!problematic.isEmpty()) {
            mgr.getEvents().log("failedInstallNew", problematic);
        }
        return problematic.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void classLoaderUp(NetigsoModule nm) throws IOException {
        List clone;
        if (this.toInit != null) {
            this.toInit.add(nm);
            return;
        }
        ArrayList<Module> arrayList = this.toEnable;
        synchronized (arrayList) {
            List cloneTmp;
            clone = cloneTmp = (List)this.toEnable.clone();
            this.toEnable.clear();
        }
        if (!clone.isEmpty()) {
            this.getDefault().prepare(Lookup.getDefault(), clone);
        }
        nm.start();
    }

    synchronized void classLoaderDown(NetigsoModule nm) {
        if (this.toInit != null) {
            this.toInit.remove(nm);
        }
    }

    final void startFramework() {
        if (this.getDefault() != null) {
            this.getDefault().start();
        }
    }

    final ClassLoader findFallbackLoader() {
        NetigsoFramework f = this.getDefault();
        if (f == null) {
            return null;
        }
        ClassLoader frameworkLoader = f.findFrameworkClassLoader();
        Class<?>[] stack = TopSecurityManager.getStack();
        for (int i = 0; i < stack.length; ++i) {
            ClassLoader sl = stack[i].getClassLoader();
            if (sl == null || sl.getClass().getClassLoader() != frameworkLoader) continue;
            return stack[i].getClassLoader();
        }
        return null;
    }
}

