/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jpt.sun.source.tree.AssertTree;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.ConditionalExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.NewArrayTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TypeCastTree;
import jpt.sun.source.tree.UnaryTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;

public class ArithmeticUtilities {
    static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };
    public static final Object NOT_NULL = new Object();
    private static final Object UNKNOWN = new Object();
    private static final String CONST_EVAL_KEY = ArithmeticUtilities.class.getName();

    public static Number compute(CompilationInfo info, TreePath tp, boolean resolveCompileTimeConstants) {
        Object o = ArithmeticUtilities.compute(info, tp, resolveCompileTimeConstants, false);
        return o instanceof Number ? (Number)((Number)o) : (Number)null;
    }

    public static boolean isRealValue(Object o) {
        return o != null && o != NULL && o != NOT_NULL;
    }

    public static boolean isNull(Object o) {
        return o == NULL;
    }

    public static boolean isNeverNull(Object o) {
        return o == NOT_NULL;
    }

    public static Object compute(CompilationInfo info, TreePath tp, boolean resolveCompileTimeConstants, boolean enhanced) {
        Object o;
        boolean save = false;
        ElementValue v = null;
        Map cache = null;
        if (tp.getParentPath() != null) {
            Tree parentL = tp.getParentPath().getLeaf();
            switch (parentL.getKind()) {
                case IF: 
                case DO_WHILE_LOOP: 
                case CONDITIONAL_EXPRESSION: 
                case FOR_LOOP: 
                case ASSIGNMENT: 
                case VARIABLE: {
                    save = true;
                    break;
                }
                case ASSERT: {
                    boolean bl = save = ((AssertTree)parentL).getCondition() == tp.getLeaf();
                }
            }
            if (save && (v = (ElementValue)(cache = VisitorImpl.getValueCache(info)).get(tp.getLeaf())) != null) {
                if (enhanced && v.constant != null) {
                    return v.constant == UNKNOWN ? null : v.constant;
                }
                if (!enhanced && v.jlsConstant != null) {
                    return v.jlsConstant == UNKNOWN ? null : v.jlsConstant;
                }
            }
        }
        try {
            o = new VisitorImpl(info, resolveCompileTimeConstants, enhanced).scan(tp, null);
        }
        catch (ArithmeticException | IllegalArgumentException | IndexOutOfBoundsException ex) {
            o = null;
        }
        if (save) {
            if (v == null) {
                v = new ElementValue();
                cache.put(tp.getLeaf(), v);
            }
            if (enhanced) {
                v.constant = o == null ? ArithmeticUtilities.UNKNOWN : o;
            } else {
                v.jlsConstant = o == null ? ArithmeticUtilities.UNKNOWN : o;
            }
        }
        return o;
    }

    public static Object implicitConversion(CompilationInfo info, Object val, TypeMirror convertTo) {
        if (!convertTo.getKind().isPrimitive()) {
            if (Utilities.isPrimitiveWrapperType(convertTo)) {
                convertTo = info.getTypes().unboxedType(convertTo);
            } else {
                Element el;
                if (ArithmeticUtilities.isNull(val)) {
                    return val;
                }
                if (val instanceof String && convertTo.getKind() == TypeKind.DECLARED && (el = info.getTypes().asElement(convertTo)).getKind() == ElementKind.CLASS && ((TypeElement)el).getQualifiedName().contentEquals("java.lang.String")) {
                    return val;
                }
                return null;
            }
        }
        switch (convertTo.getKind()) {
            case BOOLEAN: {
                if (val instanceof Boolean) {
                    return val;
                }
                return null;
            }
            case BYTE: {
                if (val instanceof Short || val instanceof Long || val instanceof Integer) {
                    long l = ((Number)val).longValue();
                    if (l >= 0L && l <= 255L) {
                        return (byte)l;
                    }
                } else if (val instanceof Character) {
                    return (byte)((Character)val).charValue();
                }
                return null;
            }
            case CHAR: {
                int n;
                if (val instanceof Character) {
                    return val;
                }
                if (val instanceof Short) {
                    short n2 = (Short)val;
                    if (n2 < 32768) {
                        return Character.valueOf((char)n2);
                    }
                } else if (val instanceof Integer && (n = ((Integer)val).intValue()) < 65536) {
                    return Character.valueOf((char)n);
                }
                return null;
            }
            case DOUBLE: {
                if (val instanceof Number) {
                    return ((Number)val).doubleValue();
                }
                if (val instanceof Character) {
                    return (double)((Character)val).charValue();
                }
                return null;
            }
            case FLOAT: {
                if (val instanceof Double) {
                    return null;
                }
                if (val instanceof Number) {
                    return Float.valueOf(((Number)val).floatValue());
                }
                if (val instanceof Character) {
                    return (double)((Character)val).charValue();
                }
                return null;
            }
            case INT: {
                if (val instanceof Short || val instanceof Long || val instanceof Integer) {
                    long l = ((Number)val).longValue();
                    if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                        return (int)l;
                    }
                } else if (val instanceof Character) {
                    return (int)((Character)val).charValue();
                }
                return null;
            }
            case LONG: {
                if (val instanceof Character) {
                    return (long)((Character)val).charValue();
                }
                if (val instanceof Double || val instanceof Float) {
                    return null;
                }
                if (val instanceof Number) {
                    return ((Number)val).longValue();
                }
                return null;
            }
            case SHORT: {
                if (val instanceof Short || val instanceof Long || val instanceof Integer) {
                    long l = ((Number)val).longValue();
                    if (l >= -32768L && l <= 32767L) {
                        return (short)l;
                    }
                } else if (val instanceof Character) {
                    return (short)((Character)val).charValue();
                }
                return null;
            }
        }
        return null;
    }

    private static class ElementValue {
        private Object jlsConstant;
        private Object constant;

        private ElementValue() {
        }
    }

    private static final class VisitorImpl
    extends ErrorAwareTreePathScanner<Object, Void> {
        private static final Set<Tree.Kind> ACCEPTED_KINDS = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.PARENTHESIZED, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.TYPE_CAST, Tree.Kind.NEW_CLASS, Tree.Kind.NEW_ARRAY});
        private static final EnumSet<TypeKind> PRIMITIVE_KINDS = EnumSet.of(TypeKind.BOOLEAN, new TypeKind[]{TypeKind.CHAR, TypeKind.BYTE, TypeKind.SHORT, TypeKind.INT, TypeKind.LONG, TypeKind.DOUBLE, TypeKind.FLOAT});
        private final CompilationInfo info;
        private final boolean resolveCompileTimeConstants;
        private final boolean enhanceProcessing;
        private static final BinaryOp OP_EQUAL = new BinaryOp(){

            @Override
            public Object eval(Object left, Object right) {
                return left.equals(right);
            }
        };

        public VisitorImpl(CompilationInfo info, boolean resolveCompileTimeConstants, boolean enhanceProcessing) {
            this.info = info;
            this.resolveCompileTimeConstants = resolveCompileTimeConstants;
            this.enhanceProcessing = enhanceProcessing;
        }

        @Override
        public Object scan(TreePath tree, Void p) {
            if (!ACCEPTED_KINDS.contains((Object)tree.getLeaf().getKind())) {
                return null;
            }
            return super.scan(tree, p);
        }

        @Override
        public Object scan(Tree tree, Void p) {
            if (tree == null) {
                return null;
            }
            if (!ACCEPTED_KINDS.contains((Object)tree.getKind())) {
                return null;
            }
            return super.scan(tree, p);
        }

        private Object resolveTypeCast(TypeCastTree node, TypeMirror target, Object result, Void p) {
            String qn;
            if (target.getKind() != TypeKind.DECLARED) {
                return null;
            }
            DeclaredType dt = (DeclaredType)target;
            TypeElement e = (TypeElement)dt.asElement();
            if (this.enhanceProcessing) {
                if (result == NULL) {
                    return NULL;
                }
                if (result == NOT_NULL) {
                    return result;
                }
            }
            if ("java.lang.String".equals(qn = e.getQualifiedName().toString())) {
                return result instanceof String ? result : null;
            }
            if (!this.enhanceProcessing) {
                return null;
            }
            TypeMirror castee = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (!Utilities.isValidType(castee)) {
                return null;
            }
            if (this.info.getTypes().isAssignable(castee, target)) {
                return result;
            }
            switch (qn) {
                case "java.lang.Boolean": {
                    if (!(result instanceof Boolean)) break;
                    return result;
                }
                case "java.lang.Byte": {
                    if (!(result instanceof Number) || castee == null || castee.getKind() != TypeKind.BYTE) break;
                    return ((Number)result).byteValue();
                }
                case "java.lang.Character": {
                    if (!(result instanceof Number) || castee == null || castee.getKind() != TypeKind.CHAR) break;
                    return Character.valueOf((char)((Number)result).intValue());
                }
                case "java.lang.Double": {
                    if (!(result instanceof Number) || castee == null || castee.getKind() != TypeKind.DOUBLE) break;
                    return ((Number)result).doubleValue();
                }
                case "java.lang.Float": {
                    if (!(result instanceof Number) || castee == null || castee.getKind() != TypeKind.FLOAT) break;
                    return Float.valueOf(((Number)result).floatValue());
                }
                case "java.lang.Integer": {
                    if (!(result instanceof Number) || castee == null || castee.getKind() != TypeKind.INT) break;
                    return ((Number)result).intValue();
                }
                case "java.lang.Long": {
                    if (!(result instanceof Number) || castee == null || castee.getKind() != TypeKind.LONG) break;
                    return ((Number)result).longValue();
                }
                case "java.lang.Short": {
                    if (!(result instanceof Number) || castee == null || castee.getKind() != TypeKind.SHORT) break;
                    return ((Number)result).shortValue();
                }
            }
            return null;
        }

        @Override
        public Object visitTypeCast(TypeCastTree node, Void p) {
            Object op = this.scan((Tree)node.getExpression(), p);
            if (op == null) {
                return null;
            }
            Object result = null;
            TypeMirror tm = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getType()));
            if (!Utilities.isValidType(tm)) {
                return null;
            }
            if (tm.getKind() != TypeKind.CHAR && op instanceof Character) {
                op = (int)((Character)op).charValue();
            }
            switch (tm.getKind()) {
                case BOOLEAN: {
                    if (!(op instanceof Boolean)) break;
                    result = op;
                    break;
                }
                case BYTE: {
                    if (!(op instanceof Number)) break;
                    result = ((Number)op).byteValue();
                    break;
                }
                case CHAR: {
                    if (op instanceof Character) {
                        result = op;
                    }
                    if (!(op instanceof Number)) break;
                    result = Character.valueOf((char)((Number)op).intValue());
                    break;
                }
                case DOUBLE: {
                    if (!(op instanceof Number)) break;
                    result = ((Number)op).doubleValue();
                    break;
                }
                case FLOAT: {
                    if (!(op instanceof Number)) break;
                    result = Float.valueOf(((Number)op).floatValue());
                    break;
                }
                case INT: {
                    if (!(op instanceof Number)) break;
                    result = ((Number)op).intValue();
                    break;
                }
                case LONG: {
                    if (!(op instanceof Number)) break;
                    result = ((Number)op).longValue();
                    break;
                }
                case SHORT: {
                    if (!(op instanceof Number)) break;
                    result = ((Number)op).shortValue();
                    break;
                }
                default: {
                    return this.resolveTypeCast(node, tm, op, p);
                }
            }
            return result;
        }

        @Override
        public Object visitNewArray(NewArrayTree node, Void p) {
            return this.enhanceProcessing ? NOT_NULL : null;
        }

        @Override
        public Object visitNewClass(NewClassTree node, Void p) {
            return this.enhanceProcessing ? NOT_NULL : null;
        }

        @Override
        public Object visitLiteral(LiteralTree node, Void p) {
            if (node.getKind() == Tree.Kind.NULL_LITERAL) {
                return this.enhanceProcessing ? NULL : null;
            }
            return node.getValue();
        }

        @Override
        public Object visitIdentifier(IdentifierTree node, Void p) {
            return this.resolve();
        }

        @Override
        public Object visitMemberSelect(MemberSelectTree node, Void p) {
            return this.resolve();
        }

        private static Map<Object, ElementValue> getValueCache(CompilationInfo info) {
            HashMap cache = (HashMap)info.getCachedValue(CONST_EVAL_KEY);
            if (cache == null) {
                cache = new HashMap(7);
                info.putCachedValue(CONST_EVAL_KEY, cache, CompilationInfo.CacheClearPolicy.ON_TASK_END);
            }
            return cache;
        }

        private static Object resolveElementValue(CompilationInfo info, TreePath path, boolean enhanceProcessing) {
            Object obj;
            ElementValue entry;
            Map<Object, ElementValue> cache;
            Element el;
            block22: {
                el = info.getTrees().getElement(path);
                if (el == null) {
                    return null;
                }
                cache = VisitorImpl.getValueCache(info);
                entry = cache.get(el);
                if (entry != null) {
                    Object v;
                    Object object = v = enhanceProcessing ? entry.constant : entry.jlsConstant;
                    if (v != null) {
                        return v != UNKNOWN ? v : null;
                    }
                }
                if (el == null) {
                    return null;
                }
                obj = null;
                if (el.getKind() == ElementKind.FIELD) {
                    obj = ((VariableElement)el).getConstantValue();
                    if (!(obj != null || el.getModifiers().contains((Object)Modifier.FINAL) && enhanceProcessing)) {
                        obj = UNKNOWN;
                    }
                } else if (!(el.getKind() != ElementKind.LOCAL_VARIABLE || (obj = ((VariableElement)el).getConstantValue()) != null || el.getModifiers().contains((Object)Modifier.FINAL) && enhanceProcessing)) {
                    obj = UNKNOWN;
                }
                if (obj == null) {
                    TreePath varPath = info.getTrees().getPath(el);
                    if (varPath != null && varPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                        VariableTree vt;
                        for (Tree t : path) {
                            if (t != varPath.getLeaf()) {
                                if (!StatementTree.class.isAssignableFrom(t.getKind().asInterface())) continue;
                                break;
                            }
                            break block22;
                        }
                        if ((vt = (VariableTree)varPath.getLeaf()).getInitializer() != null) {
                            VisitorImpl recurse = new VisitorImpl(info, true, enhanceProcessing);
                            try {
                                obj = recurse.scan(new TreePath(varPath, vt.getInitializer()), null);
                            }
                            catch (ArithmeticException | IllegalArgumentException | IndexOutOfBoundsException runtimeException) {}
                        }
                    }
                } else if (entry == null) {
                    return obj != UNKNOWN ? obj : null;
                }
            }
            if (entry == null) {
                entry = new ElementValue();
                cache.put(el, entry);
            }
            if (obj == null) {
                obj = UNKNOWN;
            }
            if (enhanceProcessing) {
                entry.constant = obj;
            } else {
                entry.jlsConstant = obj;
                if (obj == NULL || obj == NOT_NULL) {
                    return null;
                }
            }
            return obj != UNKNOWN ? obj : null;
        }

        private Object resolve() {
            if (!this.resolveCompileTimeConstants) {
                return null;
            }
            return VisitorImpl.resolveElementValue(this.info, this.getCurrentPath(), this.enhanceProcessing);
        }

        private Object numericBinaryOp(BinaryOp op, Object left, Object right) {
            return null;
        }

        @Override
        public Object visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            Object condition = this.scan((Tree)node.getCondition(), p);
            if (condition == Boolean.TRUE) {
                return this.scan((Tree)node.getTrueExpression(), p);
            }
            if (condition == Boolean.FALSE) {
                return this.scan((Tree)node.getFalseExpression(), p);
            }
            if (this.enhanceProcessing) {
                Object first = this.scan((Tree)node.getTrueExpression(), p);
                Object second = this.scan((Tree)node.getFalseExpression(), p);
                if (first == NULL && second == NULL) {
                    return NULL;
                }
                if (first != null && second != null) {
                    return NOT_NULL;
                }
            }
            return null;
        }

        @Override
        public Object visitBinary(BinaryTree node, Void p) {
            Object left = this.scan((Tree)node.getLeftOperand(), p);
            Object right = this.scan((Tree)node.getRightOperand(), p);
            if (left instanceof Character && !(right instanceof String)) {
                left = (int)((Character)left).charValue();
            }
            if (right instanceof Character && !(left instanceof String)) {
                right = (int)((Character)right).charValue();
            }
            if (left != null && right != null) {
                Object result = null;
                switch (node.getKind()) {
                    case EQUAL_TO: {
                        TypeMirror m;
                        if (left instanceof Number && right instanceof Number) {
                            result = this.numericBinaryOp(OP_EQUAL, left, right);
                            Number ln = (Number)left;
                            Number rn = (Number)right;
                            if (left instanceof Double || right instanceof Double) {
                                result = ln.doubleValue() == rn.doubleValue();
                                break;
                            }
                            if (left instanceof Float || right instanceof Float) {
                                result = ln.floatValue() == rn.floatValue();
                                break;
                            }
                            if (left instanceof Long || right instanceof Long) {
                                result = ln.longValue() == rn.longValue();
                                break;
                            }
                            if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                                result = ln.intValue() == rn.intValue();
                                break;
                            }
                            return null;
                        }
                        if (left instanceof Boolean && right instanceof Boolean) {
                            return left.equals(right);
                        }
                        if (left != NULL && right != NULL || !Utilities.isValidType(m = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), left == NULL ? node.getRightOperand() : node.getLeftOperand()))) || PRIMITIVE_KINDS.contains((Object)m.getKind())) break;
                        result = left == right;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        TypeMirror m;
                        if (left instanceof Number && right instanceof Number) {
                            Number ln = (Number)left;
                            Number rn = (Number)right;
                            if (left instanceof Double || right instanceof Double) {
                                result = ln.doubleValue() != rn.doubleValue();
                                break;
                            }
                            if (left instanceof Float || right instanceof Float) {
                                result = ln.floatValue() != rn.floatValue();
                                break;
                            }
                            if (left instanceof Long || right instanceof Long) {
                                result = ln.longValue() != rn.longValue();
                                break;
                            }
                            if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                                result = ln.intValue() != rn.intValue();
                                break;
                            }
                            return null;
                        }
                        if (left instanceof Boolean && right instanceof Boolean) {
                            return left.equals(right);
                        }
                        if (!this.enhanceProcessing || left != NULL && right != NULL || !Utilities.isValidType(m = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), left == NULL ? node.getRightOperand() : node.getLeftOperand()))) || PRIMITIVE_KINDS.contains((Object)m.getKind())) break;
                        result = left != right;
                        break;
                    }
                    case LESS_THAN: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Double || right instanceof Double) {
                            result = ln.doubleValue() < rn.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = ln.floatValue() < rn.floatValue();
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() < rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() < rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case LESS_THAN_EQUAL: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Double || right instanceof Double) {
                            result = ln.doubleValue() <= rn.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = ln.floatValue() <= rn.floatValue();
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() <= rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() <= rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case GREATER_THAN: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Double || right instanceof Double) {
                            result = ln.doubleValue() > rn.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = ln.floatValue() > rn.floatValue();
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() > rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() > rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case GREATER_THAN_EQUAL: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Double || right instanceof Double) {
                            result = ln.doubleValue() >= rn.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = ln.floatValue() >= rn.floatValue();
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() >= rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() >= rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case MULTIPLY: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Double || right instanceof Double) {
                            result = ln.doubleValue() * rn.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(ln.floatValue() * rn.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() * rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() * rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case DIVIDE: {
                        if (left instanceof Number && right instanceof Number) {
                            Number ln = (Number)left;
                            Number rn = (Number)right;
                            if (left instanceof Double || right instanceof Double) {
                                result = ln.doubleValue() / rn.doubleValue();
                            } else if (left instanceof Float || right instanceof Float) {
                                result = Float.valueOf(ln.floatValue() / rn.floatValue());
                            } else if (left instanceof Long || right instanceof Long) {
                                result = ln.longValue() / rn.longValue();
                            } else if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                                result = ln.intValue() / rn.intValue();
                            } else {
                                return null;
                            }
                        }
                        boolean a = true;
                        boolean b = false;
                        boolean c = a & b;
                        break;
                    }
                    case REMAINDER: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Double || right instanceof Double) {
                            result = ln.doubleValue() % rn.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(ln.floatValue() % rn.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() % rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() % rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case MINUS: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Double || right instanceof Double) {
                            result = ln.doubleValue() - rn.doubleValue();
                            break;
                        }
                        if (left instanceof Float || right instanceof Float) {
                            result = Float.valueOf(ln.floatValue() - rn.floatValue());
                            break;
                        }
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() - rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() - rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case LEFT_SHIFT: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() << (int)rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() << rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case RIGHT_SHIFT: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() >> (int)rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() >> rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case UNSIGNED_RIGHT_SHIFT: {
                        if (!(left instanceof Number) || !(right instanceof Number)) break;
                        Number ln = (Number)left;
                        Number rn = (Number)right;
                        if (left instanceof Long || right instanceof Long) {
                            result = ln.longValue() >>> (int)rn.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                            result = ln.intValue() >>> rn.intValue();
                            break;
                        }
                        return null;
                    }
                    case PLUS: {
                        if (left instanceof Number && right instanceof Number) {
                            Number ln = (Number)left;
                            Number rn = (Number)right;
                            if (left instanceof Double || right instanceof Double) {
                                result = ln.doubleValue() + rn.doubleValue();
                                break;
                            }
                            if (left instanceof Float || right instanceof Float) {
                                result = Float.valueOf(ln.floatValue() + rn.floatValue());
                                break;
                            }
                            if (left instanceof Long || right instanceof Long) {
                                result = ln.longValue() + rn.longValue();
                                break;
                            }
                            if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                                result = ln.intValue() + rn.intValue();
                                break;
                            }
                            return null;
                        }
                        if (left instanceof String) {
                            if (right == NOT_NULL) break;
                            result = (String)left + right;
                            break;
                        }
                        if (!(right instanceof String) || left == NOT_NULL) break;
                        result = left + (String)right;
                        break;
                    }
                    case CONDITIONAL_AND: {
                        if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                        result = (Boolean)left != false && (Boolean)right != false;
                        break;
                    }
                    case CONDITIONAL_OR: {
                        if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                        result = (Boolean)left != false || (Boolean)right != false;
                        break;
                    }
                    case XOR: {
                        if (left instanceof Number && right instanceof Number) {
                            Number ln = (Number)left;
                            Number rn = (Number)right;
                            if (left instanceof Long || right instanceof Long) {
                                result = ln.longValue() ^ rn.longValue();
                                break;
                            }
                            if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                                result = ln.intValue() ^ rn.intValue();
                                break;
                            }
                            return null;
                        }
                        if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                        result = (Boolean)left ^ (Boolean)right;
                        break;
                    }
                    case AND: {
                        if (left instanceof Number && right instanceof Number) {
                            Number ln = (Number)left;
                            Number rn = (Number)right;
                            if (left instanceof Long || right instanceof Long) {
                                result = ln.longValue() & rn.longValue();
                                break;
                            }
                            if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                                result = ln.intValue() & rn.intValue();
                                break;
                            }
                            return null;
                        }
                        if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                        result = (Boolean)left & (Boolean)right;
                        break;
                    }
                    case OR: {
                        if (left instanceof Number && right instanceof Number) {
                            Number ln = (Number)left;
                            Number rn = (Number)right;
                            if (left instanceof Long || right instanceof Long) {
                                result = ln.longValue() | rn.longValue();
                                break;
                            }
                            if (VisitorImpl.integerLike(ln) || VisitorImpl.integerLike(rn)) {
                                result = ln.intValue() | rn.intValue();
                                break;
                            }
                            return null;
                        }
                        if (!(left instanceof Boolean) || !(right instanceof Boolean)) break;
                        result = (Boolean)left | (Boolean)right;
                    }
                }
                return result;
            }
            return null;
        }

        @Override
        public Object visitUnary(UnaryTree node, Void p) {
            Object op = this.scan((Tree)node.getExpression(), p);
            if (op != null) {
                Object result = null;
                if (op instanceof Character) {
                    op = (int)((Character)op).charValue();
                }
                switch (node.getKind()) {
                    case BITWISE_COMPLEMENT: {
                        if (op instanceof Long) {
                            result = (Long)op ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        if (!(op instanceof Number) || !VisitorImpl.integerLike((Number)op)) break;
                        result = ~((Number)op).intValue();
                        break;
                    }
                    case LOGICAL_COMPLEMENT: {
                        if (!(op instanceof Boolean)) break;
                        result = (Boolean)op == false;
                        break;
                    }
                    case UNARY_MINUS: {
                        if (!(op instanceof Number)) break;
                        Number nop = (Number)op;
                        if (op instanceof Double) {
                            result = -nop.doubleValue();
                            break;
                        }
                        if (op instanceof Float) {
                            result = Float.valueOf(-nop.floatValue());
                            break;
                        }
                        if (op instanceof Long) {
                            result = -nop.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(nop)) {
                            result = -nop.intValue();
                            break;
                        }
                        return null;
                    }
                    case UNARY_PLUS: {
                        if (!(op instanceof Number)) break;
                        result = op;
                    }
                }
                return result;
            }
            return super.visitUnary(node, p);
        }

        private static boolean integerLike(Number n) {
            return n instanceof Integer || n instanceof Short || n instanceof Byte;
        }

        private static interface BinaryOp {
            public Object eval(Object var1, Object var2);
        }
    }
}

