/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.remote.exception.TransmissionDisabledException;

public class InterruptableOutputStream
extends OutputStream {
    private final OutputStream out;
    private volatile boolean interrupted = false;

    public InterruptableOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.interrupted) {
            throw new TransmissionDisabledException();
        }
        this.out.flush();
    }

    public void interrupt() {
        this.interrupted = true;
    }
}

