/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.File;
import java.util.Objects;
import org.apache.nifi.nar.NarManifest;
import org.apache.nifi.nar.NarSource;
import org.apache.nifi.nar.NarState;

public class NarNode {
    private final String identifier;
    private final File narFile;
    private final String narFileDigest;
    private final NarManifest manifest;
    private final NarSource source;
    private final String sourceIdentifier;
    private volatile NarState state;
    private volatile String failureMessage;

    private NarNode(Builder builder) {
        this.identifier = Objects.requireNonNull(builder.identifier);
        this.narFile = Objects.requireNonNull(builder.narFile);
        this.narFileDigest = Objects.requireNonNull(builder.narFileDigest);
        this.manifest = Objects.requireNonNull(builder.manifest);
        this.source = Objects.requireNonNull(builder.source);
        this.sourceIdentifier = Objects.requireNonNull(builder.sourceIdentifier);
        this.state = Objects.requireNonNull(builder.state);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public File getNarFile() {
        return this.narFile;
    }

    public String getNarFileDigest() {
        return this.narFileDigest;
    }

    public NarManifest getManifest() {
        return this.manifest;
    }

    public NarSource getSource() {
        return this.source;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public NarState getState() {
        return this.state;
    }

    public void setState(NarState state) {
        if (state == null) {
            throw new IllegalArgumentException("NAR State cannot be null");
        }
        this.state = state;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailure(Throwable failure) {
        this.state = NarState.FAILED;
        this.failureMessage = "%s - %s".formatted(failure.getClass().getSimpleName(), failure.getMessage());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NarNode narNode = (NarNode)o;
        return Objects.equals(this.identifier, narNode.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String identifier;
        private File narFile;
        private String narFileDigest;
        private NarManifest manifest;
        private NarSource source;
        private String sourceIdentifier;
        private NarState state;

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder narFile(File narFile) {
            this.narFile = narFile;
            return this;
        }

        public Builder narFileDigest(String narFileDigest) {
            this.narFileDigest = narFileDigest;
            return this;
        }

        public Builder manifest(NarManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public Builder source(NarSource source) {
            this.source = source;
            return this;
        }

        public Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public Builder state(NarState state) {
            this.state = state;
            return this;
        }

        public NarNode build() {
            return new NarNode(this);
        }
    }
}

