/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.encrypt.PropertyEncryptionMethod;
import org.apache.nifi.encrypt.PropertySecretKeyProvider;
import org.apache.nifi.security.crypto.key.DerivedKey;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.StandardDerivedKeySpec;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.pbkdf2.Pbkdf2DerivedKeyParameterSpec;
import org.apache.nifi.security.crypto.key.pbkdf2.Pbkdf2DerivedKeyProvider;

class StandardPropertySecretKeyProvider
implements PropertySecretKeyProvider {
    private static final byte[] APPLICATION_SALT = new byte[]{78, 105, 70, 105, 32, 83, 116, 97, 116, 105, 99, 32, 83, 97, 108, 116};
    private static final Argon2DerivedKeyParameterSpec ARGON2_PARAMETER_SPEC = new Argon2DerivedKeyParameterSpec(65536, 5, 8, APPLICATION_SALT);
    private static final Pbkdf2DerivedKeyParameterSpec PBKDF2_PARAMETER_SPEC = new Pbkdf2DerivedKeyParameterSpec(160000, APPLICATION_SALT);
    private static final int MINIMUM_PASSWORD_LENGTH = 12;
    private static final String PASSWORD_LENGTH_MESSAGE = String.format("Key Password length less than required [%d]", 12);
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private static final Argon2DerivedKeyProvider argon2DerivedKeyProvider = new Argon2DerivedKeyProvider();
    private static final Pbkdf2DerivedKeyProvider pbkdf2DerivedKeyProvider = new Pbkdf2DerivedKeyProvider();

    StandardPropertySecretKeyProvider() {
    }

    @Override
    public SecretKey getSecretKey(PropertyEncryptionMethod propertyEncryptionMethod, String password) {
        Objects.requireNonNull(propertyEncryptionMethod, "Property Encryption Method is required");
        Objects.requireNonNull(password, "Password is required");
        if (password.length() < 12) {
            throw new EncryptionException(PASSWORD_LENGTH_MESSAGE);
        }
        DerivedKey derivedKey = this.getDerivedKey(propertyEncryptionMethod, password);
        return new SecretKeySpec(derivedKey.getEncoded(), SECRET_KEY_ALGORITHM);
    }

    private DerivedKey getDerivedKey(PropertyEncryptionMethod propertyEncryptionMethod, String password) {
        char[] characters = password.toCharArray();
        int derivedKeyLength = propertyEncryptionMethod.getDerivedKeyLength();
        if (PropertyEncryptionMethod.NIFI_ARGON2_AES_GCM_256 == propertyEncryptionMethod) {
            StandardDerivedKeySpec derivedKeySpec = new StandardDerivedKeySpec(characters, derivedKeyLength, SECRET_KEY_ALGORITHM, (DerivedKeyParameterSpec)ARGON2_PARAMETER_SPEC);
            return argon2DerivedKeyProvider.getDerivedKey((DerivedKeySpec)derivedKeySpec);
        }
        if (PropertyEncryptionMethod.NIFI_PBKDF2_AES_GCM_256 == propertyEncryptionMethod) {
            StandardDerivedKeySpec derivedKeySpec = new StandardDerivedKeySpec(characters, derivedKeyLength, SECRET_KEY_ALGORITHM, (DerivedKeyParameterSpec)PBKDF2_PARAMETER_SPEC);
            return pbkdf2DerivedKeyProvider.getDerivedKey((DerivedKeySpec)derivedKeySpec);
        }
        String message = String.format("Property Encryption Method [%s] not supported", new Object[]{propertyEncryptionMethod});
        throw new EncryptionException(message);
    }
}

