/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorityAuthorizationDecision;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class AllAuthoritiesReactiveAuthorizationManager<T>
implements ReactiveAuthorizationManager<T> {
    private static final String ROLE_PREFIX = "ROLE_";
    private RoleHierarchy roleHierarchy = new NullRoleHierarchy();
    private final List<String> requiredAuthorities;
    private final AuthorityAuthorizationDecision defaultDecision;

    private AllAuthoritiesReactiveAuthorizationManager(String ... requiredAuthorities) {
        Assert.notEmpty((Object[])requiredAuthorities, (String)"requiredAuthorities cannot be empty");
        this.requiredAuthorities = Arrays.asList(requiredAuthorities);
        this.defaultDecision = new AuthorityAuthorizationDecision(false, AuthorityUtils.createAuthorityList(this.requiredAuthorities));
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        Assert.notNull((Object)roleHierarchy, (String)"roleHierarchy cannot be null");
        this.roleHierarchy = roleHierarchy;
    }

    @Override
    public Mono<AuthorizationResult> authorize(Mono<Authentication> authentication, T object) {
        return authentication.filter(Authentication::isAuthenticated).map(this::getGrantedAuthorities).defaultIfEmpty(Collections.emptyList()).map(authenticatedAuthorities -> {
            ArrayList<String> missingAuthorities = new ArrayList<String>(this.requiredAuthorities);
            missingAuthorities.removeIf(authenticatedAuthorities::contains);
            return new AuthorityAuthorizationDecision(missingAuthorities.isEmpty(), AuthorityUtils.createAuthorityList(missingAuthorities));
        });
    }

    private List<String> getGrantedAuthorities(Authentication authentication) {
        return this.roleHierarchy.getReachableGrantedAuthorities(authentication.getAuthorities()).stream().map(GrantedAuthority::getAuthority).toList();
    }

    public static <T> AllAuthoritiesReactiveAuthorizationManager<T> hasAllRoles(String ... roles) {
        return AllAuthoritiesReactiveAuthorizationManager.hasAllPrefixedAuthorities(ROLE_PREFIX, roles);
    }

    public static <T> AllAuthoritiesReactiveAuthorizationManager<T> hasAllPrefixedAuthorities(String prefix, String ... authorities) {
        Assert.notNull((Object)prefix, (String)"rolePrefix cannot be null");
        Assert.notEmpty((Object[])authorities, (String)"roles cannot be empty");
        Assert.noNullElements((Object[])authorities, (String)"roles cannot contain null values");
        return AllAuthoritiesReactiveAuthorizationManager.hasAllAuthorities(AllAuthoritiesReactiveAuthorizationManager.toNamedRolesArray(prefix, authorities));
    }

    public static <T> AllAuthoritiesReactiveAuthorizationManager<T> hasAllAuthorities(String ... authorities) {
        Assert.notEmpty((Object[])authorities, (String)"authorities cannot be empty");
        Assert.noNullElements((Object[])authorities, (String)"authorities cannot contain null values");
        return new AllAuthoritiesReactiveAuthorizationManager<T>(authorities);
    }

    private static String[] toNamedRolesArray(String rolePrefix, String[] roles) {
        String[] result = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i];
            Assert.isTrue((rolePrefix.isEmpty() || !role.startsWith(rolePrefix) ? 1 : 0) != 0, () -> role + " should not start with " + rolePrefix + " since " + rolePrefix + " is automatically prepended when using hasAnyRole. Consider using hasAnyAuthority instead.");
            result[i] = rolePrefix + role;
        }
        return result;
    }
}

