/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.bundle;

public class BundleFilterParams {
    private static final BundleFilterParams EMPTY_PARAMS = new Builder().build();
    private final String bucketName;
    private final String groupId;
    private final String artifactId;

    private BundleFilterParams(Builder builder) {
        this.bucketName = builder.bucketName;
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public static BundleFilterParams of(String bucketName, String groupId, String artifactId) {
        return new Builder().bucket(bucketName).group(groupId).artifact(artifactId).build();
    }

    public static BundleFilterParams of(String groupId, String artifactId) {
        return new Builder().group(groupId).artifact(artifactId).build();
    }

    public static BundleFilterParams empty() {
        return EMPTY_PARAMS;
    }

    public static class Builder {
        private String bucketName;
        private String groupId;
        private String artifactId;

        public Builder bucket(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder group(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifact(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public BundleFilterParams build() {
            return new BundleFilterParams(this);
        }
    }
}

