/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.FilteringSpringBootCondition;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class OnBeanCondition
extends FilteringSpringBootCondition
implements ConfigurationCondition {
    OnBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    protected final @Nullable ConditionOutcome[] getOutcomes(@Nullable String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        @Nullable ConditionOutcome[] outcomes = new ConditionOutcome[autoConfigurationClasses.length];
        for (int i = 0; i < outcomes.length; ++i) {
            String autoConfigurationClass = autoConfigurationClasses[i];
            if (autoConfigurationClass == null) continue;
            Set<String> onBeanTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnBean");
            outcomes[i] = this.getOutcome(onBeanTypes, ConditionalOnBean.class);
            if (outcomes[i] != null) continue;
            Set<String> onSingleCandidateTypes = autoConfigurationMetadata.getSet(autoConfigurationClass, "ConditionalOnSingleCandidate");
            outcomes[i] = this.getOutcome(onSingleCandidateTypes, ConditionalOnSingleCandidate.class);
        }
        return outcomes;
    }

    private @Nullable ConditionOutcome getOutcome(@Nullable Set<String> requiredBeanTypes, Class<? extends Annotation> annotation) {
        List<String> missing = this.filter(requiredBeanTypes, FilteringSpringBootCondition.ClassNameFilter.MISSING, this.getBeanClassLoader());
        if (!missing.isEmpty()) {
            ConditionMessage message = ConditionMessage.forCondition(annotation, new Object[0]).didNotFind("required type", "required types").items(ConditionMessage.Style.QUOTE, missing);
            return ConditionOutcome.noMatch(message);
        }
        return null;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Spec spec;
        ConditionOutcome matchOutcome = ConditionOutcome.match();
        MergedAnnotations annotations = metadata.getAnnotations();
        if (annotations.isPresent(ConditionalOnBean.class) && !(matchOutcome = this.evaluateConditionalOnBean(spec = new Spec(context, metadata, annotations, ConditionalOnBean.class), matchOutcome.getConditionMessage())).isMatch()) {
            return matchOutcome;
        }
        if (metadata.isAnnotated(ConditionalOnSingleCandidate.class.getName()) && !(matchOutcome = this.evaluateConditionalOnSingleCandidate(spec = new SingleCandidateSpec(context, metadata, metadata.getAnnotations()), matchOutcome.getConditionMessage())).isMatch()) {
            return matchOutcome;
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName()) && !(matchOutcome = this.evaluateConditionalOnMissingBean(spec = new Spec<ConditionalOnMissingBean>(context, metadata, annotations, ConditionalOnMissingBean.class), matchOutcome.getConditionMessage())).isMatch()) {
            return matchOutcome;
        }
        return matchOutcome;
    }

    private ConditionOutcome evaluateConditionalOnBean(Spec<ConditionalOnBean> spec, ConditionMessage matchMessage) {
        MatchResult matchResult = this.getMatchingBeans(spec);
        if (!matchResult.isAllMatched()) {
            String reason = this.createOnBeanNoMatchReason(matchResult);
            return ConditionOutcome.noMatch(spec.message().because(reason));
        }
        return ConditionOutcome.match(spec.message(matchMessage).found("bean", "beans").items(ConditionMessage.Style.QUOTE, matchResult.getNamesOfAllMatches()));
    }

    private ConditionOutcome evaluateConditionalOnSingleCandidate(Spec<ConditionalOnSingleCandidate> spec, ConditionMessage matchMessage) {
        MatchResult matchResult = this.getMatchingBeans(spec);
        if (!matchResult.isAllMatched()) {
            return ConditionOutcome.noMatch(spec.message().didNotFind("any beans").atAll());
        }
        Set<String> allBeans = matchResult.getNamesOfAllMatches();
        if (allBeans.size() == 1) {
            return ConditionOutcome.match(spec.message(matchMessage).found("a single bean").items(ConditionMessage.Style.QUOTE, allBeans));
        }
        ConfigurableListableBeanFactory beanFactory = spec.context.getBeanFactory();
        Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"'beanFactory' must not be null");
        Map<String, @Nullable BeanDefinition> beanDefinitions = this.getBeanDefinitions(beanFactory, allBeans, spec.getStrategy() == SearchStrategy.ALL);
        List<String> primaryBeans = this.getPrimaryBeans(beanDefinitions);
        if (primaryBeans.size() == 1) {
            return ConditionOutcome.match(spec.message(matchMessage).found("a single primary bean '" + primaryBeans.get(0) + "' from beans").items(ConditionMessage.Style.QUOTE, allBeans));
        }
        if (primaryBeans.size() > 1) {
            return ConditionOutcome.noMatch(spec.message().found("multiple primary beans").items(ConditionMessage.Style.QUOTE, primaryBeans));
        }
        List<String> nonFallbackBeans = this.getNonFallbackBeans(beanDefinitions);
        if (nonFallbackBeans.size() == 1) {
            return ConditionOutcome.match(spec.message(matchMessage).found("a single non-fallback bean '" + nonFallbackBeans.get(0) + "' from beans").items(ConditionMessage.Style.QUOTE, allBeans));
        }
        return ConditionOutcome.noMatch(spec.message().found("multiple beans").items(ConditionMessage.Style.QUOTE, allBeans));
    }

    private ConditionOutcome evaluateConditionalOnMissingBean(Spec<ConditionalOnMissingBean> spec, ConditionMessage matchMessage) {
        MatchResult matchResult = this.getMatchingBeans(spec);
        if (matchResult.isAnyMatched()) {
            String reason = this.createOnMissingBeanNoMatchReason(matchResult);
            return ConditionOutcome.noMatch(spec.message().because(reason));
        }
        return ConditionOutcome.match(spec.message(matchMessage).didNotFind("any beans").atAll());
    }

    protected final MatchResult getMatchingBeans(Spec<?> spec) {
        ConfigurableListableBeanFactory beanFactory = this.getSearchBeanFactory(spec);
        ClassLoader classLoader = spec.getContext().getClassLoader();
        boolean considerHierarchy = spec.getStrategy() != SearchStrategy.CURRENT;
        Set<BeanType> parameterizedContainers = spec.getParameterizedContainers();
        MatchResult result = new MatchResult();
        Set<String> beansIgnoredByType = this.getNamesOfBeansIgnoredByType((ListableBeanFactory)beanFactory, considerHierarchy, spec.getIgnoredTypes(), parameterizedContainers);
        for (BeanType type : spec.getTypes()) {
            Map<String, @Nullable BeanDefinition> typeMatchedDefinitions = this.getBeanDefinitionsForType((ListableBeanFactory)beanFactory, considerHierarchy, type, parameterizedContainers);
            Set<String> typeMatchedNames = this.matchedNamesFrom(typeMatchedDefinitions, (name, definition) -> !ScopedProxyUtils.isScopedTarget((String)name) && this.isCandidate(beanFactory, (String)name, (BeanDefinition)definition, beansIgnoredByType));
            if (typeMatchedNames.isEmpty()) {
                result.recordUnmatchedType(type);
                continue;
            }
            result.recordMatchedType(type, typeMatchedNames);
        }
        for (String annotation : spec.getAnnotations()) {
            Map<String, @Nullable BeanDefinition> annotationMatchedDefinitions = this.getBeanDefinitionsForAnnotation(classLoader, beanFactory, annotation, considerHierarchy);
            Set<String> annotationMatchedNames = this.matchedNamesFrom(annotationMatchedDefinitions, (name, definition) -> this.isCandidate(beanFactory, (String)name, (BeanDefinition)definition, beansIgnoredByType));
            if (annotationMatchedNames.isEmpty()) {
                result.recordUnmatchedAnnotation(annotation);
                continue;
            }
            result.recordMatchedAnnotation(annotation, annotationMatchedNames);
        }
        for (String beanName : spec.getNames()) {
            if (!beansIgnoredByType.contains(beanName) && this.containsBean(beanFactory, beanName, considerHierarchy)) {
                result.recordMatchedName(beanName);
                continue;
            }
            result.recordUnmatchedName(beanName);
        }
        return result;
    }

    private ConfigurableListableBeanFactory getSearchBeanFactory(Spec<?> spec) {
        ConfigurableListableBeanFactory beanFactory = spec.getContext().getBeanFactory();
        Assert.state((beanFactory != null ? 1 : 0) != 0, (String)"'beanFactory' must not be null'");
        if (spec.getStrategy() == SearchStrategy.ANCESTORS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.state((boolean)(parent instanceof ConfigurableListableBeanFactory), (String)"Unable to use SearchStrategy.ANCESTORS without ConfigurableListableBeanFactory");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        return beanFactory;
    }

    private Set<String> matchedNamesFrom(Map<String, @Nullable BeanDefinition> namedDefinitions, BiPredicate<String, BeanDefinition> filter) {
        LinkedHashSet<String> matchedNames = new LinkedHashSet<String>(namedDefinitions.size());
        for (Map.Entry<String, BeanDefinition> namedDefinition : namedDefinitions.entrySet()) {
            if (!filter.test(namedDefinition.getKey(), namedDefinition.getValue())) continue;
            matchedNames.add(namedDefinition.getKey());
        }
        return matchedNames;
    }

    private boolean isCandidate(ConfigurableListableBeanFactory beanFactory, String name, @Nullable BeanDefinition definition, Set<String> ignoredBeans) {
        if (ignoredBeans.contains(name)) {
            return false;
        }
        if (definition == null || definition.isAutowireCandidate() && this.isDefaultCandidate(definition)) {
            return true;
        }
        if (ScopedProxyUtils.isScopedTarget((String)name)) {
            try {
                BeanDefinition originalDefinition = beanFactory.getBeanDefinition(ScopedProxyUtils.getOriginalBeanName((String)name));
                if (originalDefinition.isAutowireCandidate() && this.isDefaultCandidate(originalDefinition)) {
                    return true;
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isDefaultCandidate(BeanDefinition definition) {
        if (definition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)definition;
            return abstractBeanDefinition.isDefaultCandidate();
        }
        return true;
    }

    private Set<String> getNamesOfBeansIgnoredByType(ListableBeanFactory beanFactory, boolean considerHierarchy, Set<BeanType> ignoredTypes, Set<BeanType> parameterizedContainers) {
        Set<String> result = null;
        for (BeanType ignoredType : ignoredTypes) {
            Set<String> ignoredNames = this.getBeanDefinitionsForType(beanFactory, considerHierarchy, ignoredType, parameterizedContainers).keySet();
            result = OnBeanCondition.addAll(result, ignoredNames);
        }
        return result != null ? result : Collections.emptySet();
    }

    private Map<String, @Nullable BeanDefinition> getBeanDefinitionsForType(ListableBeanFactory beanFactory, boolean considerHierarchy, BeanType type, Set<BeanType> parameterizedContainers) {
        Map<String, @Nullable BeanDefinition> result = this.collectBeanDefinitionsForType(beanFactory, considerHierarchy, type, parameterizedContainers, null);
        return result != null ? result : Collections.emptyMap();
    }

    private @Nullable Map<String, @Nullable BeanDefinition> collectBeanDefinitionsForType(ListableBeanFactory beanFactory, boolean considerHierarchy, BeanType type, Set<BeanType> parameterizedContainers, @Nullable Map<String, @Nullable BeanDefinition> result) {
        HierarchicalBeanFactory hierarchicalBeanFactory;
        BeanFactory parent;
        if (ResolvableType.NONE.equals((Object)type.resolvableType())) {
            return result;
        }
        result = OnBeanCondition.putAll(result, beanFactory.getBeanNamesForType(type.resolvableType(), true, false), beanFactory);
        for (BeanType parameterizedContainer : parameterizedContainers) {
            Class resolved = parameterizedContainer.resolvableType().resolve();
            Assert.state((resolved != null ? 1 : 0) != 0, (String)"'resolved' must not be null");
            ResolvableType generic = ResolvableType.forClassWithGenerics((Class)resolved, (ResolvableType[])new ResolvableType[]{type.resolvableType()});
            result = OnBeanCondition.putAll(result, beanFactory.getBeanNamesForType(generic, true, false), beanFactory);
        }
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = (hierarchicalBeanFactory = (HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)parent;
            result = this.collectBeanDefinitionsForType(listableBeanFactory, considerHierarchy, type, parameterizedContainers, result);
        }
        return result;
    }

    private Map<String, @Nullable BeanDefinition> getBeanDefinitionsForAnnotation(@Nullable ClassLoader classLoader, ConfigurableListableBeanFactory beanFactory, String type, boolean considerHierarchy) throws LinkageError {
        Map<String, BeanDefinition> result = null;
        try {
            result = this.collectBeanDefinitionsForAnnotation((ListableBeanFactory)beanFactory, this.resolveAnnotationType(classLoader, type), considerHierarchy, result);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result != null ? result : Collections.emptyMap();
    }

    private Class<? extends Annotation> resolveAnnotationType(@Nullable ClassLoader classLoader, String type) throws ClassNotFoundException {
        return OnBeanCondition.resolve(type, classLoader);
    }

    private @Nullable Map<String, @Nullable BeanDefinition> collectBeanDefinitionsForAnnotation(ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType, boolean considerHierarchy, @Nullable Map<String, @Nullable BeanDefinition> result) {
        BeanFactory parent;
        result = OnBeanCondition.putAll(result, this.getBeanNamesForAnnotation(beanFactory, annotationType), beanFactory);
        if (considerHierarchy && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)parent;
            result = this.collectBeanDefinitionsForAnnotation(listableBeanFactory, annotationType, considerHierarchy, result);
        }
        return result;
    }

    private String[] getBeanNamesForAnnotation(ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType) {
        LinkedHashSet<String> foundBeanNames = new LinkedHashSet<String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            ConfigurableListableBeanFactory configurableListableBeanFactory;
            BeanDefinition beanDefinition;
            if (beanFactory instanceof ConfigurableListableBeanFactory && (beanDefinition = (configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName)) != null && beanDefinition.isAbstract() || beanFactory.findAnnotationOnBean(beanName, annotationType, false) == null) continue;
            foundBeanNames.add(beanName);
        }
        if (beanFactory instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)beanFactory;
            for (String beanName : singletonBeanRegistry.getSingletonNames()) {
                if (beanFactory.findAnnotationOnBean(beanName, annotationType) == null) continue;
                foundBeanNames.add(beanName);
            }
        }
        return (String[])foundBeanNames.toArray(String[]::new);
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private String createOnBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason = new StringBuilder();
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedAnnotations(), "annotated with");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedTypes(), "of type");
        this.appendMessageForNoMatches(reason, matchResult.getUnmatchedNames(), "named");
        return reason.toString();
    }

    private void appendMessageForNoMatches(StringBuilder reason, Collection<String> unmatched, String description) {
        if (!unmatched.isEmpty()) {
            if (!reason.isEmpty()) {
                reason.append(" and ");
            }
            reason.append("did not find any beans ");
            reason.append(description);
            reason.append(" ");
            reason.append(StringUtils.collectionToDelimitedString(unmatched, (String)", "));
        }
    }

    private String createOnMissingBeanNoMatchReason(MatchResult matchResult) {
        StringBuilder reason = new StringBuilder();
        this.appendMessageForMatches(reason, matchResult.getMatchedAnnotations(), "annotated with");
        this.appendMessageForMatches(reason, matchResult.getMatchedTypes(), "of type");
        if (!matchResult.getMatchedNames().isEmpty()) {
            if (!reason.isEmpty()) {
                reason.append(" and ");
            }
            reason.append("found beans named ");
            reason.append(StringUtils.collectionToDelimitedString(matchResult.getMatchedNames(), (String)", "));
        }
        return reason.toString();
    }

    private void appendMessageForMatches(StringBuilder reason, Map<String, Collection<String>> matches, String description) {
        if (!matches.isEmpty()) {
            matches.forEach((key, value) -> {
                if (!reason.isEmpty()) {
                    reason.append(" and ");
                }
                reason.append("found beans ");
                reason.append(description);
                reason.append(" '");
                reason.append((String)key);
                reason.append("' ");
                reason.append(StringUtils.collectionToDelimitedString((Collection)value, (String)", "));
            });
        }
    }

    private Map<String, @Nullable BeanDefinition> getBeanDefinitions(ConfigurableListableBeanFactory beanFactory, Set<String> beanNames, boolean considerHierarchy) {
        HashMap<String, @Nullable BeanDefinition> definitions = new HashMap<String, BeanDefinition>(beanNames.size());
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = this.findBeanDefinition(beanFactory, beanName, considerHierarchy);
            definitions.put(beanName, beanDefinition);
        }
        return definitions;
    }

    private List<String> getPrimaryBeans(Map<String, @Nullable BeanDefinition> beanDefinitions) {
        return this.getMatchingBeans(beanDefinitions, this::isPrimary);
    }

    private boolean isPrimary(@Nullable BeanDefinition beanDefinition) {
        return beanDefinition != null && beanDefinition.isPrimary();
    }

    private List<String> getNonFallbackBeans(Map<String, @Nullable BeanDefinition> beanDefinitions) {
        return this.getMatchingBeans(beanDefinitions, this::isNotFallback);
    }

    private boolean isNotFallback(@Nullable BeanDefinition beanDefinition) {
        return beanDefinition == null || !beanDefinition.isFallback();
    }

    private List<String> getMatchingBeans(Map<String, @Nullable BeanDefinition> beanDefinitions, Predicate<@Nullable BeanDefinition> test) {
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<String, BeanDefinition> namedBeanDefinition : beanDefinitions.entrySet()) {
            if (!test.test(namedBeanDefinition.getValue())) continue;
            matches.add(namedBeanDefinition.getKey());
        }
        return matches;
    }

    private @Nullable BeanDefinition findBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        BeanFactory beanFactory2;
        if (beanFactory.containsBeanDefinition(beanName)) {
            return beanFactory.getBeanDefinition(beanName);
        }
        if (considerHierarchy && (beanFactory2 = beanFactory.getParentBeanFactory()) instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listableBeanFactory = (ConfigurableListableBeanFactory)beanFactory2;
            return this.findBeanDefinition(listableBeanFactory, beanName, considerHierarchy);
        }
        return null;
    }

    private static @Nullable Set<String> addAll(@Nullable Set<String> result, @Nullable Collection<String> additional) {
        if (CollectionUtils.isEmpty(additional)) {
            return result;
        }
        result = result != null ? result : new LinkedHashSet<String>();
        result.addAll(additional);
        return result;
    }

    private static @Nullable Map<String, @Nullable BeanDefinition> putAll(@Nullable Map<String, @Nullable BeanDefinition> result, String[] beanNames, ListableBeanFactory beanFactory) {
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return result;
        }
        if (result == null) {
            result = new LinkedHashMap<String, BeanDefinition>();
        }
        for (String beanName : beanNames) {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
                result.put(beanName, OnBeanCondition.getBeanDefinition(beanName, clbf));
                continue;
            }
            result.put(beanName, null);
        }
        return result;
    }

    private static @Nullable BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (BeanFactoryUtils.isFactoryDereference((String)beanName)) {
                return OnBeanCondition.getBeanDefinition(BeanFactoryUtils.transformedBeanName((String)beanName), beanFactory);
            }
            return null;
        }
    }

    private static class Spec<A extends Annotation> {
        private final ConditionContext context;
        private final Class<? extends Annotation> annotationType;
        private final Set<String> names;
        private final Set<BeanType> types;
        private final Set<String> annotations;
        private final Set<BeanType> ignoredTypes;
        private final Set<BeanType> parameterizedContainers;
        private final @Nullable SearchStrategy strategy;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        Spec(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotations annotations, Class<A> annotationType) {
            @Nullable MultiValueMap attributes = (MultiValueMap)annotations.stream(annotationType).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes)).collect(MergedAnnotationCollectors.toMultiValueMap((MergedAnnotation.Adapt[])new MergedAnnotation.Adapt[]{MergedAnnotation.Adapt.CLASS_TO_STRING}));
            MergedAnnotation annotation = annotations.get(annotationType);
            this.context = context;
            this.annotationType = annotationType;
            this.names = this.extract((MultiValueMap<String, Object>)attributes, "name");
            this.annotations = this.extract((MultiValueMap<String, Object>)attributes, "annotation");
            this.ignoredTypes = this.resolveWhenPossible(this.extract((MultiValueMap<String, Object>)attributes, "ignored", "ignoredType"));
            this.parameterizedContainers = this.resolveWhenPossible(this.extract((MultiValueMap<String, Object>)attributes, "parameterizedContainer"));
            this.strategy = annotation.getValue("search", SearchStrategy.class).orElse(null);
            Set<BeanType> types = this.resolveWhenPossible(this.extractTypes((MultiValueMap<String, Object>)attributes));
            BeanTypeDeductionException deductionException = null;
            if (types.isEmpty() && this.names.isEmpty() && this.annotations.isEmpty()) {
                try {
                    types = this.deducedBeanType(context, metadata);
                }
                catch (BeanTypeDeductionException ex) {
                    deductionException = ex;
                }
            }
            this.types = types;
            this.validate(deductionException);
        }

        protected Set<String> extractTypes(@Nullable MultiValueMap<String, @Nullable Object> attributes) {
            return this.extract(attributes, "value", "type");
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private Set<String> extract(@Nullable MultiValueMap<String, @Nullable Object> attributes, String ... attributeNames) {
            if (CollectionUtils.isEmpty(attributes)) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String attributeName : attributeNames) {
                @Nullable List values = (List)attributes.getOrDefault((Object)attributeName, Collections.emptyList());
                for (Object value : values) {
                    if (value instanceof String[]) {
                        String[] stringArray = (String[])value;
                        this.merge(result, stringArray);
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    String string = (String)value;
                    this.merge(result, string);
                }
            }
            return result.isEmpty() ? Collections.emptySet() : result;
        }

        private void merge(Set<String> result, String ... additional) {
            Collections.addAll(result, additional);
        }

        private Set<BeanType> resolveWhenPossible(Set<String> classNames) {
            if (classNames.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<BeanType> resolved = new LinkedHashSet<BeanType>(classNames.size());
            for (String className : classNames) {
                try {
                    Class<?> type = FilteringSpringBootCondition.resolve(className, this.context.getClassLoader());
                    resolved.add(new BeanType(className, ResolvableType.forRawClass(type)));
                }
                catch (ClassNotFoundException | NoClassDefFoundError ex) {
                    resolved.add(new BeanType(className, ResolvableType.NONE));
                }
            }
            return resolved;
        }

        protected void validate(@Nullable BeanTypeDeductionException ex) {
            if (!this.hasAtLeastOneElement(this.getTypes(), this.getNames(), this.getAnnotations())) {
                String message = this.getAnnotationName() + " did not specify a bean using type, name or annotation";
                if (ex == null) {
                    throw new IllegalStateException(message);
                }
                throw new IllegalStateException(message + " and the attempt to deduce the bean's type failed", ex);
            }
        }

        private boolean hasAtLeastOneElement(Set<?> ... sets) {
            for (Set<?> set : sets) {
                if (set.isEmpty()) continue;
                return true;
            }
            return false;
        }

        protected final String getAnnotationName() {
            return "@" + ClassUtils.getShortName(this.annotationType);
        }

        private Set<BeanType> deducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                return this.deducedBeanTypeForBeanMethod(context, (MethodMetadata)metadata);
            }
            return Collections.emptySet();
        }

        private Set<BeanType> deducedBeanTypeForBeanMethod(ConditionContext context, MethodMetadata metadata) {
            try {
                return Set.of(this.getReturnType(context, metadata));
            }
            catch (Throwable ex) {
                throw new BeanTypeDeductionException(metadata.getDeclaringClassName(), metadata.getMethodName(), ex);
            }
        }

        private BeanType getReturnType(ConditionContext context, MethodMetadata metadata) throws ClassNotFoundException, LinkageError {
            ClassLoader classLoader = context.getClassLoader();
            ResolvableType returnType = this.getMethodReturnType(metadata, classLoader);
            if (this.isParameterizedContainer(returnType.resolve())) {
                returnType = returnType.getGeneric(new int[0]);
            }
            return new BeanType(returnType.toString(), returnType);
        }

        private boolean isParameterizedContainer(@Nullable Class<?> type) {
            return type != null && this.parameterizedContainers.stream().map(beanType -> beanType.resolvableType().resolve(type)).anyMatch(container -> container != null && container.isAssignableFrom(type));
        }

        private ResolvableType getMethodReturnType(MethodMetadata metadata, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
            Class<?> declaringClass = FilteringSpringBootCondition.resolve(metadata.getDeclaringClassName(), classLoader);
            Method beanMethod = this.findBeanMethod(declaringClass, metadata.getMethodName());
            return ResolvableType.forMethodReturnType((Method)beanMethod);
        }

        private Method findBeanMethod(Class<?> declaringClass, String methodName) {
            Method[] candidates;
            Method method = ReflectionUtils.findMethod(declaringClass, (String)methodName);
            if (this.isBeanMethod(method)) {
                return method;
            }
            for (Method candidate : candidates = ReflectionUtils.getAllDeclaredMethods(declaringClass)) {
                if (!candidate.getName().equals(methodName) || !this.isBeanMethod(candidate)) continue;
                return candidate;
            }
            throw new IllegalStateException("Unable to find bean method " + methodName);
        }

        @Contract(value="null -> false")
        private boolean isBeanMethod(@Nullable Method method) {
            return method != null && MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Bean.class);
        }

        private SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        Set<BeanType> getTypes() {
            return this.types;
        }

        private ConditionContext getContext() {
            return this.context;
        }

        private Set<String> getNames() {
            return this.names;
        }

        private Set<String> getAnnotations() {
            return this.annotations;
        }

        private Set<BeanType> getIgnoredTypes() {
            return this.ignoredTypes;
        }

        private Set<BeanType> getParameterizedContainers() {
            return this.parameterizedContainers;
        }

        private ConditionMessage.Builder message() {
            return ConditionMessage.forCondition(this.annotationType, this);
        }

        private ConditionMessage.Builder message(ConditionMessage message) {
            return message.andCondition(this.annotationType, this);
        }

        public String toString() {
            boolean hasNames = !this.names.isEmpty();
            boolean hasTypes = !this.types.isEmpty();
            boolean hasIgnoredTypes = !this.ignoredTypes.isEmpty();
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (hasNames) {
                string.append("names: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.names));
                string.append(hasTypes ? " " : "; ");
            }
            if (hasTypes) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
                string.append(hasIgnoredTypes ? " " : "; ");
            }
            if (hasIgnoredTypes) {
                string.append("ignored: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.ignoredTypes));
                string.append("; ");
            }
            if (this.strategy != null) {
                string.append("SearchStrategy: ");
                string.append(this.strategy.toString().toLowerCase(Locale.ENGLISH));
            }
            string.append(")");
            return string.toString();
        }
    }

    private static class SingleCandidateSpec
    extends Spec<ConditionalOnSingleCandidate> {
        private static final Collection<String> FILTERED_TYPES = Arrays.asList("", Object.class.getName());

        SingleCandidateSpec(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotations annotations) {
            super(context, metadata, annotations, ConditionalOnSingleCandidate.class);
        }

        @Override
        protected Set<String> extractTypes(@Nullable MultiValueMap<String, @Nullable Object> attributes) {
            Set<String> types = super.extractTypes(attributes);
            types.removeAll(FILTERED_TYPES);
            return types;
        }

        @Override
        protected void validate(@Nullable BeanTypeDeductionException ex) {
            Assert.isTrue((this.getTypes().size() == 1 ? 1 : 0) != 0, () -> this.getAnnotationName() + " annotations must specify only one type (got " + StringUtils.collectionToCommaDelimitedString(this.getTypes()) + ")");
        }
    }

    private static final class MatchResult {
        private final Map<String, Collection<String>> matchedAnnotations = new HashMap<String, Collection<String>>();
        private final List<String> matchedNames = new ArrayList<String>();
        private final Map<String, Collection<String>> matchedTypes = new HashMap<String, Collection<String>>();
        private final List<String> unmatchedAnnotations = new ArrayList<String>();
        private final List<String> unmatchedNames = new ArrayList<String>();
        private final List<String> unmatchedTypes = new ArrayList<String>();
        private final Set<String> namesOfAllMatches = new HashSet<String>();

        private MatchResult() {
        }

        private void recordMatchedName(String name) {
            this.matchedNames.add(name);
            this.namesOfAllMatches.add(name);
        }

        private void recordUnmatchedName(String name) {
            this.unmatchedNames.add(name);
        }

        private void recordMatchedAnnotation(String annotation, Collection<String> matchingNames) {
            this.matchedAnnotations.put(annotation, matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedAnnotation(String annotation) {
            this.unmatchedAnnotations.add(annotation);
        }

        private void recordMatchedType(BeanType type, Collection<String> matchingNames) {
            this.matchedTypes.put(type.name.toString(), matchingNames);
            this.namesOfAllMatches.addAll(matchingNames);
        }

        private void recordUnmatchedType(BeanType type) {
            this.unmatchedTypes.add(type.toString());
        }

        boolean isAllMatched() {
            return this.unmatchedAnnotations.isEmpty() && this.unmatchedNames.isEmpty() && this.unmatchedTypes.isEmpty();
        }

        boolean isAnyMatched() {
            return !this.matchedAnnotations.isEmpty() || !this.matchedNames.isEmpty() || !this.matchedTypes.isEmpty();
        }

        Map<String, Collection<String>> getMatchedAnnotations() {
            return this.matchedAnnotations;
        }

        List<String> getMatchedNames() {
            return this.matchedNames;
        }

        Map<String, Collection<String>> getMatchedTypes() {
            return this.matchedTypes;
        }

        List<String> getUnmatchedAnnotations() {
            return this.unmatchedAnnotations;
        }

        List<String> getUnmatchedNames() {
            return this.unmatchedNames;
        }

        List<String> getUnmatchedTypes() {
            return this.unmatchedTypes;
        }

        Set<String> getNamesOfAllMatches() {
            return this.namesOfAllMatches;
        }
    }

    record BeanType(String name, ResolvableType resolvableType) {
        @Override
        public String toString() {
            return ResolvableType.NONE.equals((Object)this.resolvableType) ? this.name : this.resolvableType.toString();
        }
    }

    static final class BeanTypeDeductionException
    extends RuntimeException {
        private BeanTypeDeductionException(String className, String beanMethodName, Throwable cause) {
            super("Failed to deduce bean type for " + className + "." + beanMethodName, cause);
        }
    }
}

