/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.github.openjson.JSONStringer;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Alert;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.TextContentModal;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.file.FileItemDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.entity.server.SOAPLogin;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.db.util.ws.TextRoomMessage;
import org.apache.openmeetings.mediaserver.KurentoHandler;
import org.apache.openmeetings.mediaserver.StreamProcessor;
import org.apache.openmeetings.util.NullStringer;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.QuickPollManager;
import org.apache.openmeetings.web.app.TimerService;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.BasePanel;
import org.apache.openmeetings.web.room.EventDetailDialog;
import org.apache.openmeetings.web.room.ExpiredMessageDialog;
import org.apache.openmeetings.web.room.GroupCustomCssResourceReference;
import org.apache.openmeetings.web.room.NicknameDialog;
import org.apache.openmeetings.web.room.RedirectMessageDialog;
import org.apache.openmeetings.web.room.VideoSettings;
import org.apache.openmeetings.web.room.activities.Activity;
import org.apache.openmeetings.web.room.menu.RoomMenuPanel;
import org.apache.openmeetings.web.room.sidebar.RoomSidebar;
import org.apache.openmeetings.web.room.wb.AbstractWbPanel;
import org.apache.openmeetings.web.room.wb.InterviewWbPanel;
import org.apache.openmeetings.web.room.wb.WbAction;
import org.apache.openmeetings.web.room.wb.WbPanel;
import org.apache.openmeetings.web.util.ExtendedClientProperties;
import org.apache.openmeetings.web.util.TouchPunchResourceReference;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.AjaxDownloadBehavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.protocol.ws.api.BaseWebSocketBehavior;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.event.WebSocketPushPayload;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.interaction.droppable.Droppable;
import org.wicketstuff.jquery.ui.settings.JQueryUILibrarySettings;

@AuthorizeInstantiation(value={"ROOM"})
public class RoomPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RoomPanel.class);
    public static final String PARAM_ACTION = "action";
    private static final String ACCESS_DENIED_ID = "access-denied";
    private static final String EVENT_DETAILS_ID = "event-details";
    private final Room r;
    private final WebMarkupContainer room = new WebMarkupContainer("roomContainer");
    private final AbstractDefaultAjaxBehavior roomEnter = new AbstractDefaultAjaxBehavior(){
        private static final long serialVersionUID = 1L;

        protected void respond(AjaxRequestTarget target) {
            log.debug("RoomPanel::roomEnter");
            WebSession ws = WebSession.get();
            Client c = RoomPanel.this.getClient();
            JSONObject options = VideoSettings.getInitJson(c.getSid()).put("uid", (Object)c.getUid()).put("userId", (Object)c.getUserId()).put("rights", (Object)c.toJson(true).getJSONArray("rights")).put("interview", RoomPanel.this.r.isInterview()).put("audioOnly", RoomPanel.this.r.isAudioOnly()).put("allowRecording", RoomPanel.this.r.isAllowRecording()).put("questions", RoomPanel.this.r.isAllowUserQuestions()).put("showMicStatus", !RoomPanel.this.r.getHiddenElements().contains(Room.RoomElement.MICROPHONE_STATUS));
            if (!(Strings.isEmpty((String)RoomPanel.this.r.getRedirectURL()) || ws.getSoapLogin() == null && ws.getInvitation() == null)) {
                options.put("reloadUrl", (Object)RoomPanel.this.r.getRedirectURL());
            }
            StringBuilder sb = new StringBuilder("Room.init(").append(options.toString((JSONStringer)new NullStringer())).append(");").append(RoomPanel.this.wb.getInitScript()).append(RoomPanel.this.getQuickPollJs());
            sb.append(this.sendClientsOnInit());
            target.appendJavaScript((CharSequence)sb);
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(RoomPanel.this.r.getId(), c, RoomMessage.Type.ROOM_ENTER, c.getUid()));
            this.initVideos(target);
            RoomPanel.this.getMainPanel().getChat().roomEnter(RoomPanel.this.r, (IPartialPageRequestHandler)target);
            if (RoomPanel.this.r.isFilesOpened()) {
                RoomPanel.this.sidebar.setFilesActive((IPartialPageRequestHandler)target);
            }
            if (Room.Type.PRESENTATION != RoomPanel.this.r.getType()) {
                boolean modsEmpty = RoomPanel.this.noModerators();
                log.debug("RoomPanel::roomEnter, mods IS EMPTY ? {}, is MOD ? {}", (Object)modsEmpty, (Object)c.hasRight(Room.Right.MODERATOR));
                if (modsEmpty) {
                    RoomPanel.this.showIdeaAlert((IPartialPageRequestHandler)target, RoomPanel.this.getString(RoomPanel.this.r.isModerated() ? "641" : "498"));
                }
            }
            if (RoomPanel.this.r.isWaitRecording()) {
                RoomPanel.this.showIdeaAlert((IPartialPageRequestHandler)target, RoomPanel.this.getString("1315"));
            }
            RoomPanel.this.wb.update((IPartialPageRequestHandler)target);
            RoomPanel.this.jsInited = true;
        }

        private CharSequence sendClientsOnInit() {
            Client c = RoomPanel.this.getClient();
            StringBuilder res = new StringBuilder();
            if (c.hasRight(Room.Right.MODERATOR) || !RoomPanel.this.r.isHidden(Room.RoomElement.USER_COUNT)) {
                res.append(RoomPanel.this.createAddClientJs(c));
            }
            return res;
        }

        private void initVideos(AjaxRequestTarget target) {
            StringBuilder sb = new StringBuilder();
            JSONArray streams = new JSONArray();
            RoomPanel.this.cm.streamByRoom(RoomPanel.this.getRoom().getId()).map(Client::getStreams).flatMap(Collection::stream).forEach(sd -> streams.put((Object)sd.toJson()));
            if (streams.length() > 0) {
                sb.append("VideoManager.play(").append(streams).append(", ").append(RoomPanel.this.kHandler.getTurnServers(RoomPanel.this.getClient())).append(");");
            }
            if (RoomPanel.this.r.isInterview() && RoomPanel.this.streamProcessor.recordingAllowed(RoomPanel.this.getClient())) {
                sb.append("WbArea.setRecEnabled(true);");
            }
            if (!Strings.isEmpty((CharSequence)sb)) {
                target.appendJavaScript((CharSequence)sb);
            }
        }
    };
    private RedirectMessageDialog roomClosed;
    private Modal<String> clientKicked;
    private Alert waitModerator;
    private RoomMenuPanel menu;
    private RoomSidebar sidebar;
    private final AbstractWbPanel wb;
    private String fuid;
    private String ftype;
    private final AjaxDownloadBehavior download = new AjaxDownloadBehavior((IResource)new ResourceStreamResource(){
        private static final long serialVersionUID = 1L;
        {
            this.setCacheDuration(Duration.ZERO);
        }

        protected IResourceStream getResourceStream(IResource.Attributes attributes) {
            this.setFileName("pdf".equals(RoomPanel.this.ftype) ? "whiteboard.pdf" : "slide.png");
            return new FileResourceStream(Paths.get(System.getProperty("java.io.tmpdir"), RoomPanel.this.fuid).toFile());
        }
    }){
        private static final long serialVersionUID = 1L;

        protected void onDownloadCompleted(AjaxRequestTarget target) {
            super.onDownloadCompleted(target);
            try {
                Files.deleteIfExists(Paths.get(System.getProperty("java.io.tmpdir"), RoomPanel.this.fuid));
            }
            catch (Exception e) {
                log.error("unexcepted error while clean-up", (Throwable)e);
            }
            RoomPanel.this.fuid = null;
            RoomPanel.this.ftype = null;
        }
    };
    Component eventDetail = new WebMarkupContainer("event-details").setVisible(false);
    private boolean avInited = false;
    private boolean jsInited = false;
    @Inject
    private ClientManager cm;
    @Inject
    private UserDao userDao;
    @Inject
    private AppointmentDao apptDao;
    @Inject
    private QuickPollManager qpollManager;
    @Inject
    private KurentoHandler kHandler;
    @Inject
    private StreamProcessor streamProcessor;
    @Inject
    private TimerService timerService;
    @Inject
    private FileItemDao fileDao;

    public RoomPanel(String id, Room r) {
        super(id);
        this.r = r;
        this.wb = r.isInterview() ? new InterviewWbPanel("whiteboard", this) : new WbPanel("whiteboard", this);
    }

    public void startDownload(IPartialPageRequestHandler handler, String type, String fuid) {
        this.fuid = fuid;
        this.ftype = type;
        this.download.initiate(handler);
    }

    protected void onInitialize() {
        super.onInitialize();
        Client c = this.getClient().updateUser(this.userDao);
        Object accessDenied = new WebMarkupContainer(ACCESS_DENIED_ID).setVisible(false);
        this.room.setOutputMarkupPlaceholderTag(true);
        Component[] componentArray = new Component[1];
        this.menu = new RoomMenuPanel("menu", this);
        componentArray[0] = this.menu;
        this.room.add(componentArray);
        this.room.add(new Behavior[]{AttributeModifier.append((String)"data-room-id", (Serializable)this.r.getId())});
        if (this.r.isInterview()) {
            this.room.add(new Component[]{new WebMarkupContainer("wb-area").add(new Component[]{this.wb})});
        } else {
            Droppable<BaseFileItem> wbArea = new Droppable<BaseFileItem>("wb-area"){
                private static final long serialVersionUID = 1L;

                public void onConfigure(JQueryBehavior behavior) {
                    super.onConfigure(behavior);
                    behavior.setOption("hoverClass", (Object)Options.asString((String)"droppable-hover"));
                    behavior.setOption("accept", (Object)Options.asString((String)".recorditem, .fileitem, .readonlyitem"));
                }

                public void onDrop(AjaxRequestTarget target, Component component) {
                    Object o = component.getDefaultModelObject();
                    if (RoomPanel.this.wb.isVisible() && o instanceof BaseFileItem) {
                        BaseFileItem f = (BaseFileItem)o;
                        if (RoomPanel.this.sidebar.getFilesPanel().isSelected(f)) {
                            for (Map.Entry<String, BaseFileItem> e : RoomPanel.this.sidebar.getFilesPanel().getSelected().entrySet()) {
                                RoomPanel.this.wb.sendFileToWb(e.getValue(), false);
                            }
                        } else {
                            RoomPanel.this.wb.sendFileToWb(f, false);
                        }
                    }
                }
            };
            this.room.add(new Component[]{wbArea.add(new Component[]{this.wb})});
        }
        this.room.add(new Behavior[]{this.roomEnter});
        Component[] componentArray2 = new Component[1];
        this.sidebar = new RoomSidebar("sidebar", this);
        componentArray2[0] = this.sidebar;
        this.room.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.roomClosed = new RedirectMessageDialog("room-closed", "1098", this.r.isClosed(), this.r.getRedirectURL());
        componentArray3[0] = this.roomClosed;
        this.add(componentArray3);
        if (this.r.isClosed()) {
            this.room.setVisible(false);
        } else if (this.cm.streamByRoom(this.r.getId()).count() >= this.r.getCapacity()) {
            accessDenied = new ExpiredMessageDialog(ACCESS_DENIED_ID, this.getString("99"), this.menu);
            this.room.setVisible(false);
        } else if (!this.r.getId().equals(WebSession.get().getRoomId())) {
            boolean allowed = Application.get().isRoomAllowedToUser(this.r, c.getUser());
            Object deniedMessage = null;
            if (this.r.isAppointment()) {
                Appointment a = this.apptDao.getByRoom(this.r.getId());
                if (allowed) {
                    Calendar cal = WebSession.getCalendar();
                    if (a.isOwner(WebSession.getUserId()) || cal.getTime().after(Appointment.allowedStart((Date)a.getStart())) && cal.getTime().before(a.getEnd())) {
                        this.eventDetail = new EventDetailDialog(EVENT_DETAILS_ID, a);
                    } else {
                        allowed = false;
                        deniedMessage = String.format("%s %s - %s", this.getString("error.hash.period"), WebSession.getDateFormat().format(a.getStart()), WebSession.getDateFormat().format(a.getEnd()));
                    }
                }
            }
            if (!allowed) {
                if (deniedMessage == null) {
                    deniedMessage = this.getString("1599");
                }
                accessDenied = new ExpiredMessageDialog(ACCESS_DENIED_ID, (String)deniedMessage, this.menu);
                this.room.setVisible(false);
            }
        }
        RepeatingView groupstyles = new RepeatingView("groupstyle");
        this.add(new Component[]{groupstyles.setVisible(this.room.isVisible() && !this.r.getGroups().isEmpty())});
        if (this.room.isVisible()) {
            this.add(new Component[]{new NicknameDialog("nickname", this)});
            this.add(new Behavior[]{this.download});
            this.add(new Behavior[]{new BaseWebSocketBehavior("media")});
            for (RoomGroup rg : this.r.getGroups()) {
                WebMarkupContainer groupstyle = new WebMarkupContainer(groupstyles.newChildId());
                groupstyle.add(new Behavior[]{AttributeModifier.append((String)"href", (Serializable)((Object)((String)RequestCycle.get().urlFor((ResourceReference)new GroupCustomCssResourceReference(), new PageParameters().add("id", (Object)rg.getGroup().getId())))))});
                groupstyles.add(new Component[]{groupstyle});
            }
            int count = this.cm.addToRoom(c.setRoom(this.getRoom()));
            SOAPLogin soap = WebSession.get().getSoapLogin();
            if (soap != null && soap.isModerator()) {
                c.allow(new Room.Right[]{Room.Right.SUPER_MODERATOR});
            } else {
                Set rr = AuthLevelUtil.getRoomRight((User)c.getUser(), (Room)this.r, this.r.isAppointment() ? this.apptDao.getByRoom(this.r.getId()) : null, (int)count);
                if (!rr.isEmpty()) {
                    c.allow((Iterable)rr);
                    log.info("Setting rights for client:: {} -> {}", (Object)rr, (Object)c.hasRight(Room.Right.MODERATOR));
                }
            }
            if (this.r.isModerated() && this.r.isWaitModerator() && !c.hasRight(Room.Right.MODERATOR) && this.noModerators()) {
                this.room.setVisible(false);
                this.createWaitModerator(true);
                this.getMainPanel().getChat().toggle(null, false);
            }
            this.timerService.scheduleModCheck(this.r);
        } else {
            this.add(new Component[]{new WebMarkupContainer("nickname").setVisible(false)});
        }
        this.cm.update(c);
        if (this.waitModerator == null) {
            this.createWaitModerator(false);
        }
        this.add(new Component[]{this.room, accessDenied, this.eventDetail, this.waitModerator});
        Component[] componentArray4 = new Component[1];
        this.clientKicked = new TextContentModal("client-kicked", (IModel)new ResourceModel("606"));
        componentArray4[0] = this.clientKicked;
        this.add(componentArray4);
        this.clientKicked.header((IModel)new ResourceModel("797")).setCloseOnEscapeKey(false).setBackdrop(Modal.Backdrop.FALSE).addButton((Component)new BootstrapAjaxLink<String>("button", (IModel)Model.of((Serializable)((Object)"")), Buttons.Type.Outline_Primary, (IModel)new ResourceModel("54")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                RoomPanel.this.clientKicked.close((IPartialPageRequestHandler)target);
                RoomPanel.this.menu.exit((IPartialPageRequestHandler)target);
            }
        });
    }

    public void onEvent(IEvent<?> event) {
        WebSocketPushPayload wsEvent;
        IWebSocketPushMessage iWebSocketPushMessage;
        if (!this.jsInited) {
            return;
        }
        Client curClient = this.getClient();
        if (curClient != null && event.getPayload() instanceof WebSocketPushPayload && (iWebSocketPushMessage = (wsEvent = (WebSocketPushPayload)event.getPayload()).getMessage()) instanceof RoomMessage) {
            RoomMessage m = (RoomMessage)iWebSocketPushMessage;
            WebSocketRequestHandler handler = wsEvent.getHandler();
            switch (m.getType()) {
                case POLL_CREATED: {
                    this.menu.updatePoll((IPartialPageRequestHandler)handler, m.getUserId());
                    break;
                }
                case POLL_UPDATED: {
                    this.menu.updatePoll((IPartialPageRequestHandler)handler, null);
                    break;
                }
                case RECORDING_TOGGLED: {
                    this.menu.update((IPartialPageRequestHandler)handler);
                    this.updateInterviewRecordingButtons((IPartialPageRequestHandler)handler);
                    break;
                }
                case SHARING_TOGGLED: {
                    this.menu.update((IPartialPageRequestHandler)handler);
                    break;
                }
                case RIGHT_UPDATED: {
                    this.onRightUpdated(curClient, (TextRoomMessage)m, (IPartialPageRequestHandler)handler);
                    break;
                }
                case ROOM_ENTER: {
                    this.onRoomEnter(curClient, (TextRoomMessage)m, (IPartialPageRequestHandler)handler);
                    break;
                }
                case ROOM_EXIT: {
                    this.onRoomExit((TextRoomMessage)m, (IPartialPageRequestHandler)handler);
                    break;
                }
                case ROOM_CLOSED: {
                    handler.add(new Component[]{this.room.setVisible(false)});
                    this.roomClosed.show((IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_MODERATOR: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_MODERATOR), (IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_PRESENTER: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_PRESENTER), (IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_WB: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_WB), (IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_SHARE: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_SHARE), (IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_REMOTE: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_REMOTE), (IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_A: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_A), (IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_AV: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_AV), (IPartialPageRequestHandler)handler);
                    break;
                }
                case REQUEST_RIGHT_MUTE_OTHERS: {
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_MUTE_OTHERS), (IPartialPageRequestHandler)handler);
                    break;
                }
                case ACTIVITY_REMOVE: {
                    this.sidebar.removeActivity(((TextRoomMessage)m).getText(), (IPartialPageRequestHandler)handler);
                    break;
                }
                case HAVE_QUESTION: {
                    if (!curClient.hasRight(Room.Right.MODERATOR) && !WebSession.getUserId().equals(m.getUserId())) break;
                    this.sidebar.addActivity(new Activity((TextRoomMessage)m, Activity.Type.REQ_RIGHT_HAVE_QUESTION), (IPartialPageRequestHandler)handler);
                    break;
                }
                case KICK: {
                    this.onKick(curClient, (TextRoomMessage)m, (IPartialPageRequestHandler)handler);
                    break;
                }
                case MUTE: {
                    this.onMute(curClient, (TextRoomMessage)m, (IPartialPageRequestHandler)handler);
                    break;
                }
                case MUTE_OTHERS: {
                    this.onMuteOthers((TextRoomMessage)m, (IPartialPageRequestHandler)handler);
                    break;
                }
                case QUICK_POLL_UPDATED: {
                    this.menu.update((IPartialPageRequestHandler)handler);
                    handler.appendJavaScript((CharSequence)this.getQuickPollJs());
                    break;
                }
                case KURENTO_STATUS: {
                    this.menu.update((IPartialPageRequestHandler)handler);
                    break;
                }
                case WB_RELOAD: {
                    if (Room.Type.INTERVIEW == this.r.getType()) break;
                    this.wb.reloadWb((IPartialPageRequestHandler)handler);
                    break;
                }
                case MODERATOR_IN_ROOM: {
                    if (!this.r.isModerated() || !this.r.isWaitModerator()) {
                        log.warn("Something weird: `moderatorInRoom` in wrong room {}", (Object)this.r);
                        break;
                    }
                    if (curClient.hasRight(Room.Right.MODERATOR)) break;
                    boolean moderInRoom = Boolean.TRUE.equals(Boolean.valueOf(((TextRoomMessage)m).getText()));
                    log.warn("!! moderatorInRoom: {}", (Object)moderInRoom);
                    if (this.room.isVisible() == moderInRoom) break;
                    handler.add(new Component[]{this.room.setVisible(moderInRoom)});
                    this.getMainPanel().getChat().toggle((IPartialPageRequestHandler)handler, moderInRoom && !this.r.isHidden(Room.RoomElement.CHAT));
                    if (this.room.isVisible()) {
                        handler.appendJavaScript(this.roomEnter.getCallbackScript());
                        handler.add(new Component[]{this.waitModerator.setVisible(false)});
                        break;
                    }
                    handler.add(new Component[]{this.waitModerator.setVisible(true)});
                    break;
                }
                case WB_PUT_FILE: {
                    this.onWbPutFile((TextRoomMessage)m);
                    break;
                }
                case FILE_TREE_UPDATE: {
                    this.onFileTreeUpdate((IPartialPageRequestHandler)handler);
                }
            }
        }
        super.onEvent(event);
    }

    private void onRightUpdated(Client curClient, TextRoomMessage m, IPartialPageRequestHandler handler) {
        String uid = m.getText();
        Client c = this.cm.get(uid);
        if (c == null) {
            log.error("Not existing user in rightUpdated {} !!!!", (Object)uid);
            return;
        }
        boolean self = curClient.getUid().equals(c.getUid());
        StringBuilder sb = new StringBuilder("Room.updateClient(").append(c.toJson(self).toString((JSONStringer)new NullStringer())).append(");").append(this.sendClientsOnUpdate());
        handler.appendJavaScript((CharSequence)sb);
        this.sidebar.update(handler);
        this.menu.update(handler);
        this.wb.update(handler);
        this.updateInterviewRecordingButtons(handler);
    }

    private void onRoomEnter(Client curClient, TextRoomMessage m, IPartialPageRequestHandler handler) {
        this.sidebar.update(handler);
        this.menu.update(handler);
        String uid = m.getText();
        Client c = this.cm.get(uid);
        if (c == null) {
            log.error("Not existing user in rightUpdated {} !!!!", (Object)uid);
            return;
        }
        boolean self = curClient.getUid().equals(c.getUid());
        if (self || curClient.hasRight(Room.Right.MODERATOR) || !this.r.isHidden(Room.RoomElement.USER_COUNT)) {
            handler.appendJavaScript((CharSequence)("Room.addClient([" + c.toJson(self).toString((JSONStringer)new NullStringer()) + "]);"));
        }
        this.sidebar.addActivity(new Activity(m, Activity.Type.ROOM_ENTER), handler);
    }

    private void onRoomExit(TextRoomMessage m, IPartialPageRequestHandler handler) {
        String uid = m.getText();
        this.sidebar.update(handler);
        this.sidebar.addActivity(new Activity(m, Activity.Type.ROOM_EXIT), handler);
        handler.appendJavaScript((CharSequence)("Room.removeClient('" + uid + "'); Chat.removeTab('chatTab-u" + m.getUserId() + "');"));
    }

    private void onKick(Client curClient, TextRoomMessage m, IPartialPageRequestHandler handler) {
        String uid = m.getText();
        if (curClient.getUid().equals(uid)) {
            handler.add(new Component[]{this.room.setVisible(false)});
            this.getMainPanel().getChat().toggle(handler, false);
            this.clientKicked.show(handler);
            this.cm.exitRoom(curClient);
        }
    }

    private void onMute(Client curClient, TextRoomMessage m, IPartialPageRequestHandler handler) {
        JSONObject obj = new JSONObject(m.getText());
        Client c = this.cm.getBySid(obj.getString("sid"));
        if (c == null) {
            log.error("Not existing user in mute {} !!!!", (Object)obj);
            return;
        }
        if (!curClient.getUid().equals(c.getUid())) {
            handler.appendJavaScript((CharSequence)String.format("if (typeof(VideoManager) !== 'undefined') {VideoManager.mute('%s', %s);}", obj.getString("uid"), obj.getBoolean("mute")));
        }
    }

    private void onMuteOthers(TextRoomMessage m, IPartialPageRequestHandler handler) {
        String uid = m.getText();
        Client c = this.cm.get(uid);
        if (c == null) {
            return;
        }
        handler.appendJavaScript((CharSequence)String.format("if (typeof(VideoManager) !== 'undefined') {VideoManager.muteOthers('%s');}", uid));
    }

    private void onWbPutFile(TextRoomMessage m) {
        JSONObject obj = new JSONObject(m.getText());
        this.getWb().sendFileToWb(this.fileDao.getAny(Long.valueOf(obj.getLong("fileId"))), obj.getBoolean("clean"));
    }

    private void onFileTreeUpdate(IPartialPageRequestHandler handler) {
        this.sidebar.getFilesPanel().update(handler);
    }

    private String getQuickPollJs() {
        return String.format("Room.quickPoll(%s);", this.qpollManager.toJson(this.r.getId()));
    }

    private void updateInterviewRecordingButtons(IPartialPageRequestHandler handler) {
        Client curClient = this.getClient();
        if (this.r.isInterview() && curClient.hasRight(Room.Right.MODERATOR)) {
            if (this.streamProcessor.isRecording(this.r.getId())) {
                handler.appendJavaScript((CharSequence)"if (typeof(WbArea) === 'object') {WbArea.setRecStarted(true);}");
            } else if (this.streamProcessor.recordingAllowed(this.getClient())) {
                boolean hasStreams = this.cm.streamByRoom(this.r.getId()).anyMatch(cl -> !cl.getStreams().isEmpty());
                handler.appendJavaScript((CharSequence)String.format("if (typeof(WbArea) === 'object') {WbArea.setRecStarted(false);WbArea.setRecEnabled(%s);}", hasStreams));
            }
        }
    }

    public boolean isModerator(long userId, long roomId) {
        return RoomPanel.isModerator(this.cm, userId, roomId);
    }

    public static boolean isModerator(ClientManager cm, long userId, long roomId) {
        return RoomPanel.hasRight(cm, userId, roomId, Room.Right.MODERATOR);
    }

    public static boolean hasRight(ClientManager cm, long userId, long roomId, Room.Right r) {
        return cm.streamByRoom(roomId).anyMatch(c -> c.sameUserId(Long.valueOf(userId)) && c.hasRight(r));
    }

    @Override
    public BasePanel onMenuPanelLoad(IPartialPageRequestHandler handler) {
        this.getBasePage().getHeader().setVisible(false);
        this.getMainPanel().getTopControls().setVisible(false);
        Component loader = this.getBasePage().getLoader().setVisible(false);
        if (this.r.isHidden(Room.RoomElement.CHAT) || !this.isVisible()) {
            this.getMainPanel().getChat().toggle(handler, false);
        }
        if (handler != null) {
            handler.add(new Component[]{loader, this.getBasePage().getHeader(), this.getMainPanel().getTopControls()});
            if (this.isVisible()) {
                handler.appendJavaScript((CharSequence)"Room.load();");
            }
        }
        return this;
    }

    public void show(IPartialPageRequestHandler handler) {
        this.getMainPanel().getChat().toggle(handler, !this.r.isHidden(Room.RoomElement.CHAT));
        handler.add(new Component[]{this.setVisible(true)});
        handler.appendJavaScript((CharSequence)"Room.load();");
    }

    @Override
    public void cleanup(IPartialPageRequestHandler handler) {
        Component component = this.eventDetail;
        if (component instanceof EventDetailDialog) {
            EventDetailDialog evtDialog = (EventDetailDialog)component;
            evtDialog.close(handler);
        }
        handler.add(new Component[]{this.getBasePage().getHeader().setVisible(true), this.getMainPanel().getTopControls().setVisible(true)});
        if (this.r.isHidden(Room.RoomElement.CHAT)) {
            this.getMainPanel().getChat().toggle(handler, true);
        }
        handler.appendJavaScript((CharSequence)"if (typeof(Room) !== 'undefined') { Room.unload(); }");
        this.cm.exitRoom(this.getClient());
        this.getMainPanel().getChat().roomExit(this.r, handler);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forUrl((String)"js/room.js")){
            private static final long serialVersionUID = 1L;

            public List<HeaderItem> getDependencies() {
                return List.of(VideoSettings.VIDEO_SETTINGS_JS, new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forUrl((String)"js/wb.js")), new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JQueryUILibrarySettings.get().getJavaScriptReference())));
            }
        });
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)TouchPunchResourceReference.instance()));
        if (this.room.isVisible()) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.roomEnter.getCallbackScript()));
        }
    }

    public void requestRight(Room.Right right, IPartialPageRequestHandler handler) {
        RoomMessage.Type reqType = null;
        if (this.noModerators()) {
            if (this.r.isModerated()) {
                this.showIdeaAlert(handler, this.getString("696"));
                return;
            }
            this.rightsUpdated(this.cm.update(this.getClient().allow(new Room.Right[]{right})));
        }
        switch (right) {
            case MODERATOR: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_MODERATOR;
                break;
            }
            case PRESENTER: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_PRESENTER;
                break;
            }
            case WHITEBOARD: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_WB;
                break;
            }
            case SHARE: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_SHARE;
                break;
            }
            case AUDIO: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_A;
                break;
            }
            case MUTE_OTHERS: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_MUTE_OTHERS;
                break;
            }
            case REMOTE_CONTROL: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_REMOTE;
                break;
            }
            case VIDEO: {
                reqType = RoomMessage.Type.REQUEST_RIGHT_AV;
                break;
            }
        }
        if (reqType != null) {
            WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(this.getRoom().getId(), this.getClient(), reqType, this.getClient().getUid()));
        }
    }

    public void allowRight(Client client, Room.Right ... rights) {
        this.rightsUpdated(client.allow(rights));
    }

    public void denyRight(Client client, Room.Right ... rights) {
        for (Room.Right right : rights) {
            client.deny(new Room.Right[]{right});
        }
        client.getCamStreams().forEach(sd -> {
            if (sd.has(Client.Activity.AUDIO) && !client.hasRight(Room.Right.AUDIO)) {
                sd.remove(Client.Activity.AUDIO);
            }
            if (sd.has(Client.Activity.VIDEO) && !client.hasRight(Room.Right.VIDEO)) {
                sd.remove(Client.Activity.VIDEO);
            }
        });
        this.rightsUpdated(client);
    }

    public void rightsUpdated(Client c) {
        this.cm.update(c);
        this.streamProcessor.rightsUpdated(c);
    }

    public void broadcast(Client client) {
        this.cm.update(client);
        WebSocketHelper.sendRoom((RoomMessage)new TextRoomMessage(this.getRoom().getId(), this.getClient(), RoomMessage.Type.RIGHT_UPDATED, client.getUid()));
    }

    @Override
    protected void process(IPartialPageRequestHandler handler, JSONObject o) throws IOException {
        if (this.room.isVisible() && "room".equals(o.optString("area"))) {
            String type = o.optString("type");
            if ("wb".equals(type)) {
                WbAction a = WbAction.of(o.getString(PARAM_ACTION));
                this.wb.processWbAction(a, o.optJSONObject("data"), handler);
            } else if ("room".equals(type)) {
                this.sidebar.roomAction(handler, o);
            } else if ("av".equals(type)) {
                ExtendedClientProperties cp = WebSession.get().getExtendedProperties();
                Client c = cp.setSettings(o.optJSONObject("settings")).update(this.getClient());
                if (!this.avInited) {
                    this.avInited = true;
                    if (Room.Type.CONFERENCE == this.r.getType()) {
                        if (!c.isAllowed(Client.Activity.AUDIO)) {
                            c.allow(new Room.Right[]{Room.Right.AUDIO});
                        }
                        if (!c.getRoom().isAudioOnly() && !c.isAllowed(Client.Activity.VIDEO)) {
                            c.allow(new Room.Right[]{Room.Right.VIDEO});
                        }
                        this.streamProcessor.onToggleActivity(c, c.getRoom().isAudioOnly() ? Client.Activity.AUDIO : Client.Activity.AUDIO_VIDEO);
                    }
                }
                c.getCamStreams().forEach(sd -> {
                    sd.setWidth(c.getWidth());
                    sd.setHeight(c.getHeight());
                });
                this.broadcast(c);
            }
        }
    }

    public Room getRoom() {
        return this.r;
    }

    public Client getClient() {
        return this.getMainPanel().getClient();
    }

    public String getUid() {
        return this.getMainPanel().getUid();
    }

    public boolean screenShareAllowed() {
        Client c = this.getClient();
        return c.getScreenStream().isPresent() || this.streamProcessor.screenShareAllowed(c);
    }

    public RoomSidebar getSidebar() {
        return this.sidebar;
    }

    public AbstractWbPanel getWb() {
        return this.wb;
    }

    public String getPublishingUser() {
        return null;
    }

    public boolean isInterview() {
        return this.r.isInterview();
    }

    private void createWaitModerator(boolean autoopen) {
        this.waitModerator = new Alert("wait-moderator", (IModel)new ResourceModel("wait-moderator.message"), (IModel)new ResourceModel("wait-moderator.title")){
            private static final long serialVersionUID = 1L;

            protected Component createMessage(String markupId, IModel<String> message) {
                return super.createMessage(markupId, message).setEscapeModelStrings(false);
            }
        };
        this.waitModerator.type(Alert.Type.Warning).setCloseButtonVisible(false);
        this.waitModerator.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true).setVisible(autoopen);
    }

    @Override
    protected String getCssClass() {
        String clazz = "room " + this.r.getType().name();
        if (this.r.isHidden(Room.RoomElement.TOP_BAR)) {
            clazz = clazz + " no-menu";
        }
        if (this.r.isHidden(Room.RoomElement.ACTIVITIES)) {
            clazz = clazz + " no-activities";
        }
        if (this.r.isHidden(Room.RoomElement.CHAT)) {
            clazz = clazz + " no-chat";
        }
        if (!this.r.isHidden(Room.RoomElement.MICROPHONE_STATUS)) {
            clazz = clazz + " mic-status";
        }
        return clazz;
    }

    private void showIdeaAlert(IPartialPageRequestHandler handler, String msg) {
        this.showAlert(handler, "info", msg, "far fa-lightbulb");
    }

    private void showAlert(IPartialPageRequestHandler handler, String type, String msg, String icon) {
        handler.appendJavaScript((CharSequence)("OmUtil.alert('" + type + "', '<i class=\"" + icon + "\"></i>&nbsp;" + StringEscapeUtils.escapeEcmaScript((String)msg) + "', 10000)"));
    }

    private CharSequence createAddClientJs(Client c) {
        JSONArray arr = new JSONArray();
        this.cm.streamByRoom(this.r.getId()).forEach(cl -> arr.put((Object)cl.toJson(c.getUid().equals(cl.getUid()))));
        return new StringBuilder().append("Room.addClient(").append(arr.toString((JSONStringer)new NullStringer())).append(");");
    }

    private CharSequence sendClientsOnUpdate() {
        Client c = this.getClient();
        StringBuilder res = new StringBuilder();
        if (this.r.isHidden(Room.RoomElement.USER_COUNT)) {
            if (c.hasRight(Room.Right.MODERATOR)) {
                res.append(this.createAddClientJs(c));
            } else {
                res.append("Room.removeOthers();");
            }
        }
        return res;
    }

    private boolean noModerators() {
        return this.cm.streamByRoom(this.r.getId()).filter(cl -> cl.hasRight(Room.Right.MODERATOR)).findAny().isEmpty();
    }

    public static enum Action {
        KICK("kick"),
        MUTE_OTHERS("muteOthers"),
        MUTE("mute"),
        TOGGLE_RIGHT("toggleRight");

        private final String jsName;

        private Action(String jsName) {
            this.jsName = jsName;
        }

        public static Action of(String jsName) {
            return Stream.of(Action.values()).filter(a -> a.jsName.equals(jsName)).findAny().orElse(null);
        }
    }
}

