/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.activity;

import java.util.HashSet;
import java.util.Map;
import org.asteriskjava.pbx.ActivityCallback;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.NewChannelListener;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.activities.DialToAgiActivity;
import org.asteriskjava.pbx.asterisk.wrap.actions.SetVarAction;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.activity.ActivityHelper;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.DialToAgi;
import org.asteriskjava.pbx.internal.managerAPI.OriginateResult;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class DialToAgiActivityImpl
extends ActivityHelper<DialToAgiActivity>
implements DialToAgiActivity,
NewChannelListener {
    private static final Log logger = LogFactory.getLog(DialToAgiActivityImpl.class);
    private final boolean hideToCallerId;
    private boolean cancelledByOperator;
    private final EndPoint _originating;
    private Channel originatingChannel;
    private final CallerID toCallerID;
    private Map<String, String> channelVarsToSet;
    private AgiChannelActivityAction action;
    private DialToAgi originator;
    private Integer timeout;

    public DialToAgiActivityImpl(EndPoint originating, CallerID toCallerID, Integer timeout, boolean hideToCallerID, ActivityCallback<DialToAgiActivity> listener, Map<String, String> channelVarsToSet, AgiChannelActivityAction action) {
        super("Dial", listener);
        this.timeout = timeout;
        this.action = action;
        this._originating = originating;
        this.toCallerID = toCallerID;
        this.hideToCallerId = hideToCallerID;
        this.cancelledByOperator = false;
        this.channelVarsToSet = channelVarsToSet;
    }

    @Override
    public void dial() {
        this.startActivity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doActivity() throws PBXException {
        boolean success = false;
        try (DialToAgi nr = new DialToAgi(this.toCallerID.toString());){
            logger.debug("**************************************************************************");
            logger.info("***********                begin dial out to agi " + this._originating + "              ***********");
            logger.debug("**************************************************************************");
            this.originator = nr;
            OriginateResult[] resultChannels = nr.dial(this, this._originating, this.action, this.toCallerID, this.timeout, this.hideToCallerId, this.channelVarsToSet);
            if (resultChannels[0] == null || !resultChannels[0].isSuccess()) {
                if (!this.cancelledByOperator) {
                    this.setLastException(new PBXException("OperatorEndedCall"));
                    logger.warn("dialout to " + this._originating + " failed.");
                }
            } else {
                this.originatingChannel = resultChannels[0].getChannel();
                logger.debug("dialout succeeded");
                success = true;
            }
        }
        catch (InterruptedException e) {
            logger.error(e);
        }
        finally {
            if (!success) {
                this.hangup();
            }
        }
        return success;
    }

    private void hangup() {
        try {
            PBX pbx = PBXFactory.getActivePBX();
            if (this.originatingChannel != null) {
                logger.info("Hanging up");
                pbx.hangup(this.originatingChannel);
            }
        }
        catch (Exception e) {
            logger.error(e, e);
        }
    }

    @Override
    public void markCancelled() {
        this.cancelledByOperator = true;
    }

    @Override
    public Channel getOriginatingChannel() {
        return this.originatingChannel;
    }

    @Override
    public EndPoint getOriginatingEndPoint() {
        return this._originating;
    }

    @Override
    public void channelUpdate(Channel channel) {
        if (channel.sameEndPoint(this._originating)) {
            this.originatingChannel = channel;
        }
        super.progess(this, "Channel for " + channel.getEndPoint().getSIPSimpleName() + " is now up.");
    }

    @Override
    public boolean validateChannel(Channel channel) {
        boolean ret = false;
        SetVarAction var = new SetVarAction(channel, "testState", "1");
        ManagerResponse response = null;
        try {
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            response = pbx.sendAction(var, 500);
        }
        catch (Exception e) {
            logger.debug(e, e);
            logger.error("getVariable: " + e);
        }
        if (response != null && response.getAttribute("Response").compareToIgnoreCase("success") == 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean cancelledByOperator() {
        return this.cancelledByOperator;
    }

    @Override
    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        return required;
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.NORMAL;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
    }

    @Override
    public void abort() {
        if (this.originator != null) {
            this.originator.abort();
        } else {
            logger.error("Call to abort, but it doesn't look like the Dial had started yet");
        }
    }
}

