/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.config.InvalidConfigurationException;

final class Tag {
    private final String key;
    private final String value;

    Tag(String spec) {
        String[] labelParts = spec.trim().split("\\s*=\\s*");
        if (labelParts.length != 2) {
            throw new InvalidConfigurationException(String.format("Invalid tag specification: '%s'", spec));
        }
        this.key = labelParts[0];
        this.value = labelParts[1];
    }

    Tag(String key, String value) {
        this.key = key;
        this.value = value;
    }

    String getKey() {
        return this.key;
    }

    String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (!this.key.equals(tag.key)) {
            return false;
        }
        return this.value.equals(tag.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "Tag{key='" + this.key + "', value='" + this.value + "'}";
    }
}

