/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCUpdateConfigCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.operation.UpdateConfigOperation;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.UUID;

public class UpdateConfigMessageTask
extends AbstractInvocationMessageTask<String> {
    private static final ManagementPermission REQUIRED_PERMISSION = new ManagementPermission("config.update");

    public UpdateConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.nodeEngine.getThisAddress());
    }

    @Override
    protected Operation prepareOperation() {
        return new UpdateConfigOperation((String)this.parameters);
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return MCUpdateConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCUpdateConfigCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:configurationService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "updateConfig";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

