/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.DefaultPartitionStrategy;
import java.io.Serializable;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Partitioner<T>
extends Serializable {
    public static final Partitioner<Object> HASH_CODE = (item, partitionCount) -> Math.abs(item.hashCode() % partitionCount);

    default public void init(@Nonnull DefaultPartitionStrategy strat) {
    }

    public int getPartition(@Nonnull T var1, int var2);

    default public T getConstantPartitioningKey() {
        return null;
    }

    public static Partitioner<Object> defaultPartitioner() {
        return new Default();
    }

    public static final class Default
    implements Partitioner<Object> {
        private static final long serialVersionUID = 1L;
        transient DefaultPartitionStrategy defaultPartitioning;

        Default() {
        }

        @Override
        public void init(@Nonnull DefaultPartitionStrategy defaultPartitioning) {
            this.defaultPartitioning = defaultPartitioning;
        }

        @Override
        public int getPartition(@Nonnull Object item, int partitionCount) {
            return this.defaultPartitioning.getPartition(item);
        }
    }
}

