/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.query.impl.getters.AbstractMultiValueGetter;
import com.hazelcast.query.impl.getters.FieldGetter;
import com.hazelcast.query.impl.getters.Getter;
import com.hazelcast.query.impl.getters.MethodGetter;
import com.hazelcast.query.impl.getters.MultiResult;
import com.hazelcast.query.impl.getters.NullGetter;
import com.hazelcast.query.impl.getters.NullMultiValueGetter;
import com.hazelcast.query.impl.getters.ThisGetter;
import com.hazelcast.query.impl.predicates.PredicateUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;

public final class GetterFactory {
    private static final String ANY = "[any]";

    private GetterFactory() {
    }

    public static Getter newFieldGetter(Object object, Getter parent, Field field, String modifier) throws Exception {
        return GetterFactory.newGetter(object, parent, modifier, field.getType(), field::get, (t, et) -> new FieldGetter(parent, field, modifier, t, et));
    }

    public static Getter newMethodGetter(Object object, Getter parent, Method method, String modifier) throws Exception {
        return GetterFactory.newGetter(object, parent, modifier, method.getReturnType(), x$0 -> method.invoke(x$0, new Object[0]), (t, et) -> new MethodGetter(parent, method, modifier, t, et));
    }

    public static Getter newThisGetter(Getter parent, Object object) {
        return new ThisGetter(parent, object);
    }

    private static Getter newGetter(Object object, Getter parent, String modifier, Class type, Reader reader, Constructor constructor) throws Exception {
        Object currentObject = GetterFactory.getCurrentObject(object, parent);
        if (type == Optional.class && (type = GetterFactory.deduceOptionalType(currentObject, reader)) == null) {
            return ANY.equals(modifier) ? NullMultiValueGetter.NULL_MULTIVALUE_GETTER : NullGetter.NULL_GETTER;
        }
        Class elementType = null;
        if (GetterFactory.isExtractingFromCollection(type, modifier)) {
            AbstractMultiValueGetter.validateModifier(modifier);
            if (currentObject == null) {
                return NullGetter.NULL_GETTER;
            }
            if (currentObject instanceof MultiResult) {
                MultiResult multiResult = (MultiResult)currentObject;
                elementType = GetterFactory.deduceElementType(multiResult, reader);
            } else {
                Collection collection = (Collection)PredicateUtils.unwrapIfOptional(reader.read(currentObject));
                elementType = GetterFactory.deduceElementType(collection);
            }
            if (elementType == null) {
                if (modifier.equals(ANY)) {
                    return NullMultiValueGetter.NULL_MULTIVALUE_GETTER;
                }
                return NullGetter.NULL_GETTER;
            }
        } else if (GetterFactory.isExtractingFromArray(type, modifier)) {
            AbstractMultiValueGetter.validateModifier(modifier);
            if (currentObject == null) {
                return NullGetter.NULL_GETTER;
            }
        }
        return constructor.construct(type, elementType);
    }

    private static Class deduceOptionalType(Object object, Reader reader) throws Exception {
        if (object instanceof MultiResult) {
            MultiResult multiResult = (MultiResult)object;
            for (Object result : multiResult.getResults()) {
                Class deducedType;
                if (result == null || (deducedType = GetterFactory.deduceOptionalType(reader.read(result))) == null) continue;
                return deducedType;
            }
            return null;
        }
        return object == null ? null : GetterFactory.deduceOptionalType(reader.read(object));
    }

    private static Class deduceOptionalType(Object value) {
        assert (value == null || value instanceof Optional);
        if (value == null) {
            return null;
        }
        Optional optional = (Optional)value;
        return optional.isPresent() ? optional.get().getClass() : null;
    }

    private static Class deduceElementType(MultiResult multiResult, Reader reader) throws Exception {
        for (Object result : multiResult.getResults()) {
            Collection collection;
            Class elementType;
            if (result == null || (elementType = GetterFactory.deduceElementType(collection = (Collection)PredicateUtils.unwrapIfOptional(reader.read(result)))) == null) continue;
            return elementType;
        }
        return null;
    }

    private static Class deduceElementType(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        Object item = CollectionUtil.getItemAtPositionOrNull(collection, 0);
        if (item == null) {
            for (Object object : collection) {
                if (object == null) continue;
                return object.getClass();
            }
            return null;
        }
        return item.getClass();
    }

    private static boolean isExtractingFromCollection(Class type, String modifier) {
        return modifier != null && Collection.class.isAssignableFrom(type);
    }

    private static boolean isExtractingFromArray(Class type, String modifier) {
        return modifier != null && type.isArray();
    }

    private static Object getCurrentObject(Object object, Getter parent) throws Exception {
        return parent == null ? object : parent.getValue(object);
    }

    @FunctionalInterface
    private static interface Reader {
        public Object read(Object var1) throws Exception;
    }

    @FunctionalInterface
    private static interface Constructor {
        public Getter construct(Class var1, Class var2);
    }
}

