/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.SocketException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SdpNTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsNTAdapter;

public class ConnOption {
    public NTAdapter nt;
    public String protocol;
    public String host;
    public int port;
    public String addr;
    public String sid;
    public String service_name;
    public String instance_name;
    public int delayBetweenRetry;
    public int tdu;
    public int sdu;
    public StringBuilder conn_data = new StringBuilder(200);
    public String sslServerCertDN;
    public String sslServerDNMatch;
    public String sslAllowWeakDNMatch;
    public String walletDirectory;
    public String useTcpFastOpen;
    private ConnOption originalConnOption;
    public boolean done;

    private NTAdapter getNT(Properties properties, SSLContext sSLContext) throws NetException {
        block7: {
            try {
                if (this.protocol.equalsIgnoreCase("tcp")) {
                    this.nt = new TcpNTAdapter(this.addr, properties, this);
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("tcps") || this.protocol.equalsIgnoreCase("wss")) {
                    this.nt = new TcpsNTAdapter(this.addr, properties, sSLContext, this);
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("sdp")) {
                    this.nt = new SdpNTAdapter(this.addr, properties);
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("exadirect") || this.protocol.equalsIgnoreCase("msgqlt")) {
                    this.nt = new MQLNTAdapter(this.addr, properties);
                    break block7;
                }
                throw new NetException(21, "protocol: " + this.protocol);
            }
            catch (NLException nLException) {
                throw new NetException(501);
            }
            catch (Exception exception) {
                throw (NetException)new NetException(21).initCause(exception);
            }
        }
        return this.nt;
    }

    public void connect(Properties properties, SSLContext sSLContext) throws IOException {
        try {
            this.parseAddressParams();
            if (this.protocol == null) {
                throw new NetException(501);
            }
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        if (this.nt == null || !this.nt.hasMoreInetAddresses()) {
            this.nt = this.getNT(properties, sSLContext);
        }
        this.nt.connect();
    }

    private void parseAddressParams() throws NLException {
        NVPair nVPair;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = new NVFactory().createNVPair(this.addr);
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair2, "PROTOCOL");
        if (nVPair3 == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        this.protocol = nVPair3.getAtom();
        NVPair nVPair4 = nVNavigator.findNVPair(nVPair2, "HOST");
        if (nVPair4 != null) {
            this.host = nVPair4.getAtom();
        }
        if ((nVPair = nVNavigator.findNVPair(nVPair2, "PORT")) != null) {
            this.port = Integer.parseInt(nVPair.getAtom());
        }
    }

    public ConnOption getOriginalConnOption() {
        return this.originalConnOption == null ? this : this.originalConnOption;
    }

    public void setOriginalConnOption(ConnOption connOption) {
        this.originalConnOption = connOption;
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + ", sid=" + this.sid + ", protocol=" + this.protocol + ", service_name=" + this.service_name + "\naddr=" + this.addr + "\nconn_data=" + this.conn_data + "\nsslServerCertDN=" + this.sslServerCertDN + ", done=" + this.done;
    }

    boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.nt.isConnectionSocketKeepAlive();
    }

    String getConnectData() {
        return this.conn_data.toString();
    }

    void setConnectData(String string) {
        this.conn_data = new StringBuilder(string);
    }
}

