/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class BootstrapAjaxLink<T>
extends AjaxLink<T>
implements IBootstrapButton<BootstrapAjaxLink<T>> {
    private static final long serialVersionUID = 1L;
    private Icon icon;
    private Component label;
    private Component splitter;
    private ButtonBehavior buttonBehavior;
    private boolean useSplitter = true;
    private final Buttons.Type type;
    private final IModel<? extends Serializable> labelModel;

    public BootstrapAjaxLink(String id, Buttons.Type type) {
        this(id, null, type);
    }

    public BootstrapAjaxLink(String id, IModel<T> model, Buttons.Type type) {
        this(id, model, type, (IModel)Model.of((Serializable)((Object)"")));
    }

    public <L extends Serializable> BootstrapAjaxLink(String id, IModel<T> model, Buttons.Type type, IModel<L> labelModel) {
        super(id, model);
        this.type = type;
        this.labelModel = labelModel;
        this.add(new Behavior[]{this.getButtonBehavior()});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.getIcon(), this.getSplitter(), this.getLinkLabel()});
    }

    private ButtonBehavior getButtonBehavior() {
        if (this.buttonBehavior == null) {
            this.buttonBehavior = new ButtonBehavior(this.type, Buttons.Size.Medium);
        }
        return this.buttonBehavior;
    }

    private Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.newIcon("icon");
        }
        return this.icon;
    }

    private Component getSplitter() {
        if (this.splitter == null) {
            this.splitter = this.newSplitter("splitter");
        }
        return this.splitter;
    }

    private Component getLinkLabel() {
        if (this.label == null) {
            this.label = this.newLabel("label", this.labelModel);
        }
        return this.label;
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected <L extends Serializable> Component newLabel(String markupId, IModel<L> model) {
        return new Label(markupId, model).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false).setVisible(false);
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.useSplitter) {
            this.getSplitter().setVisible(this.getIcon().hasIconType() && StringUtils.isNotEmpty((CharSequence)this.getLinkLabel().getDefaultModelObjectAsString()));
        }
    }

    public <L extends Serializable> BootstrapAjaxLink<T> setLabel(IModel<L> label) {
        this.getLinkLabel().setDefaultModel(label);
        return this;
    }

    public BootstrapAjaxLink<T> setIconType(IconType iconType) {
        this.getIcon().setType(iconType);
        return this;
    }

    @Override
    public BootstrapAjaxLink<T> setSize(Buttons.Size size) {
        this.getButtonBehavior().setSize(size);
        return this;
    }

    @Override
    public BootstrapAjaxLink<T> setType(Buttons.Type type) {
        this.getButtonBehavior().setType(type);
        return this;
    }

    public BootstrapAjaxLink<T> useSplitter(boolean value) {
        this.useSplitter = value;
        return this;
    }

    protected void detachModel() {
        super.detachModel();
        this.labelModel.detach();
    }
}

