/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.mail;

import jakarta.inject.Inject;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.core.mail.MailHandler;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.service.mail.template.RegisterUserTemplate;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.Application;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EmailManager {
    private static final Logger log = LoggerFactory.getLogger(EmailManager.class);
    @Inject
    private MailHandler mailHandler;

    private static IApplication getApp() {
        return (IApplication)Application.get((String)OpenmeetingsVariables.getWicketApplicationName());
    }

    public static String getString(String key) {
        return EmailManager.getApp().getOmString(key);
    }

    public void sendMail(String username, String email, String hash, boolean sendEmailWithVerficationCode, Long langId) {
        log.debug("sendMail:: username = {}, email = {}", (Object)username, (Object)email);
        ApplicationHelper.ensureApplication((Long)(langId != null ? langId : OpenmeetingsVariables.getDefaultLang()));
        String link = EmailManager.getApp().urlForActivatePage(new PageParameters().add("u", (Object)hash));
        if (OpenmeetingsVariables.isSendRegisterEmail()) {
            this.mailHandler.send(email, EmailManager.getString("512"), RegisterUserTemplate.getEmail(username, email, sendEmailWithVerficationCode ? link : null));
        }
    }
}

