/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.DiscoveryStrategyConfigCodec;
import com.hazelcast.client.impl.protocol.codec.holder.DiscoveryConfigHolder;
import com.hazelcast.client.impl.protocol.codec.holder.DiscoveryStrategyConfigHolder;
import com.hazelcast.internal.serialization.Data;
import java.util.List;

public final class DiscoveryConfigCodec {
    private DiscoveryConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, DiscoveryConfigHolder discoveryConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ListMultiFrameCodec.encode(clientMessage, discoveryConfig.getDiscoveryStrategyConfigs(), DiscoveryStrategyConfigCodec::encode);
        DataCodec.encode(clientMessage, discoveryConfig.getDiscoveryServiceProvider());
        DataCodec.encode(clientMessage, discoveryConfig.getNodeFilter());
        StringCodec.encode(clientMessage, discoveryConfig.getNodeFilterClass());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static DiscoveryConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        List<DiscoveryStrategyConfigHolder> discoveryStrategyConfigs = ListMultiFrameCodec.decode(iterator, DiscoveryStrategyConfigCodec::decode);
        Data discoveryServiceProvider = DataCodec.decode(iterator);
        Data nodeFilter = DataCodec.decode(iterator);
        String nodeFilterClass = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new DiscoveryConfigHolder(discoveryStrategyConfigs, discoveryServiceProvider, nodeFilter, nodeFilterClass);
    }
}

