/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDestroyProxyCodec;
import com.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.security.permission.ActionConstants;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.proxyservice.impl.operations.DistributedObjectDestroyOperation;
import java.security.Permission;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;

public class DestroyProxyMessageTask
extends AbstractMultiTargetMessageTask<ClientDestroyProxyCodec.RequestParameters>
implements Supplier<Operation> {
    public DestroyProxyMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public Operation get() {
        return new DistributedObjectDestroyOperation(((ClientDestroyProxyCodec.RequestParameters)this.parameters).serviceName, ((ClientDestroyProxyCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected Supplier<Operation> createOperationSupplier() {
        return this;
    }

    @Override
    protected Object reduce(Map<Member, Object> map) throws Throwable {
        for (Object result : map.values()) {
            if (!(result instanceof Throwable)) continue;
            Throwable throwable = (Throwable)result;
            this.handleException(throwable);
        }
        return null;
    }

    @Override
    public Collection<Member> getTargets() {
        return this.nodeEngine.getClusterService().getMembers();
    }

    private void handleException(Throwable throwable) {
        boolean causedByInactiveInstance = ExceptionUtil.peel(throwable) instanceof HazelcastInstanceNotActiveException;
        Level level = causedByInactiveInstance ? Level.FINEST : Level.WARNING;
        this.logger.log(level, "Error while destroying a proxy.", throwable);
    }

    @Override
    protected ClientDestroyProxyCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientDestroyProxyCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientDestroyProxyCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return ((ClientDestroyProxyCodec.RequestParameters)this.parameters).serviceName;
    }

    @Override
    public Permission getRequiredPermission() {
        return ActionConstants.getPermission(((ClientDestroyProxyCodec.RequestParameters)this.parameters).name, ((ClientDestroyProxyCodec.RequestParameters)this.parameters).serviceName, "destroy");
    }

    @Override
    public String getDistributedObjectName() {
        return ((ClientDestroyProxyCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "destroy";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((ClientDestroyProxyCodec.RequestParameters)this.parameters).name};
    }
}

