/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.map.impl.operation.steps.TxnPrepareOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.tx.TxnPrepareBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.UUID;

public class TxnPrepareOperation
extends KeyBasedMapOperation
implements BackupAwareOperation,
MutatingOperation {
    public static final long LOCK_TTL_MILLIS = 10000L;
    private UUID ownerUuid;
    private UUID transactionId;

    protected TxnPrepareOperation(int partitionId, String name, Data dataKey, UUID ownerUuid, UUID transactionId) {
        super(name, dataKey);
        this.setPartitionId(partitionId);
        this.ownerUuid = ownerUuid;
        this.transactionId = transactionId;
    }

    public TxnPrepareOperation() {
    }

    @Override
    protected void runInternal() {
        try {
            this.wbqCapacityCounter().increment(this.transactionId, false);
        }
        catch (ReachedMaxSizeException e) {
            throw new TransactionException(e);
        }
        if (!this.recordStore.extendLock(this.getKey(), this.ownerUuid, this.getThreadId(), 10000L)) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Locked: [" + this.recordStore.isLocked(this.getKey()) + "], key: [" + this.getKey() + "]");
            }
            this.wbqCapacityCounter().decrement(this.transactionId);
            throw new TransactionException("Lock is not owned by the transaction! [" + this.recordStore.getLockOwnerInfo(this.getKey()) + "]");
        }
    }

    @Override
    public State createState() {
        return super.createState().setTxnId(this.transactionId).setOwnerUuid(this.ownerUuid);
    }

    @Override
    public Step getStartingStep() {
        return TxnPrepareOpSteps.PREPARE;
    }

    @Override
    public void logError(Throwable e) {
        if (e instanceof TransactionException) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("failed to execute:" + this, e);
            }
            return;
        }
        super.logError(e);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public final Operation getBackupOperation() {
        return new TxnPrepareBackupOperation(this.name, this.dataKey, this.ownerUuid, this.getThreadId(), this.transactionId);
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.ownerUuid);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ownerUuid = UUIDSerializationUtil.readUUID(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", ownerUuid=").append(this.ownerUuid).append(", transactionId=").append(this.transactionId);
    }

    @Override
    public int getClassId() {
        return 65;
    }
}

