/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.util;

import com.github.caldav4j.exceptions.AuthorizationException;
import com.github.caldav4j.exceptions.BadStatusException;
import com.github.caldav4j.exceptions.CalDAV4JException;
import com.github.caldav4j.exceptions.ResourceNotFoundException;
import com.github.caldav4j.exceptions.ResourceOutOfDateException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodUtil.class);

    public static int StatusToExceptions(HttpRequestBase method, HttpResponse response) throws CalDAV4JException {
        if (method != null && response != null) {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 300) {
                switch (status) {
                    case 409: {
                        throw new ResourceOutOfDateException("Conflict accessing: " + method.getURI());
                    }
                    case 404: {
                        throw new ResourceNotFoundException(ResourceNotFoundException.IdentifierType.PATH, method.getURI().toString());
                    }
                    case 401: {
                        throw new AuthorizationException("Unauthorized accessing " + method.getURI());
                    }
                    case 412: {
                        throw new ResourceOutOfDateException("Resource out of date: " + method.getURI());
                    }
                }
                throw new BadStatusException(status, method.getMethod(), method.getURI().toString());
            }
            return status;
        }
        throw new CalDAV4JException("Null method or null response");
    }
}

