/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.cdx.CdxReader;
import org.netpreserve.jwarc.cdx.CdxRecord;

public class StatsTool {
    List<Table> tables = Arrays.asList(new Table("RECORD", WarcRecord::type, r -> "cdx"), new Table("MIME", record -> {
        if (record instanceof WarcResponse || record instanceof WarcResource) {
            try {
                return ((WarcCaptureRecord)record).payload().map(payload -> payload.type().base().toString()).orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }, record -> record.contentType().toString()), new Table("HOST", record -> {
        if (record instanceof WarcResponse || record instanceof WarcResource) {
            return ((WarcCaptureRecord)record).targetURI().getHost();
        }
        return null;
    }, record -> record.targetURI().getHost()));

    public static void main(String[] args) throws IOException {
        StatsTool statsTool = new StatsTool();
        Function<Long, String> sizeFormatter = String::valueOf;
        ArrayList<Path> files = new ArrayList<Path>();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                switch (arg) {
                    case "-h": 
                    case "--human-readable": {
                        sizeFormatter = StatsTool::humanByteSize;
                        break;
                    }
                    case "--help": {
                        System.out.println("Usage: jwarc stats [warc-or-cdx-files...]");
                        System.out.println();
                        System.out.println("Options:");
                        System.out.println("  -h, --human-readable  Print sizes in powers of 1024 (e.g. 13.1 MB)");
                        return;
                    }
                    default: {
                        System.err.println("Unrecognized option: " + arg);
                        System.err.println("Try `jwarc stats --help` for usage information");
                        System.exit(1);
                        break;
                    }
                }
                continue;
            }
            files.add(Paths.get(arg, new String[0]));
        }
        for (Path file : files) {
            if (file.getFileName().toString().endsWith(".cdx")) {
                statsTool.loadCdxFile(file);
                continue;
            }
            statsTool.loadWarcFile(file);
        }
        statsTool.print(sizeFormatter);
    }

    private void print(Function<Long, String> sizeFormatter) {
        this.tables.forEach(table -> table.print(sizeFormatter));
    }

    private void loadCdxFile(Path path) throws IOException {
        try (CdxReader reader = new CdxReader(Files.newInputStream(path, new OpenOption[0]));){
            for (CdxRecord record : reader) {
                for (Table table : this.tables) {
                    table.add(record);
                }
            }
        }
    }

    private void loadWarcFile(Path path) throws IOException {
        try (WarcReader reader = new WarcReader(path);){
            WarcRecord next = reader.next().orElse(null);
            while (next != null) {
                long position = reader.position();
                WarcRecord record = next;
                if (record instanceof WarcCaptureRecord) {
                    ((WarcCaptureRecord)record).payload();
                }
                next = reader.next().orElse(null);
                long length = reader.position() - position;
                for (Table table : this.tables) {
                    table.add(record, length);
                }
            }
        }
    }

    private static String humanByteSize(long n) {
        if (n < 0L) {
            return "-" + StatsTool.humanByteSize(-n);
        }
        int i = n == 0L ? 0 : (63 - Long.numberOfLeadingZeros(n)) / 10;
        return String.format("%.1f %sB", (double)n / (double)(1L << i * 10), Character.valueOf(" KMGTPE".charAt(i)));
    }

    private static class Table {
        final String name;
        final Function<WarcRecord, String> warcKeyFunction;
        final Function<CdxRecord, String> cdxKeyFunction;
        final Map<String, Row> rows = new HashMap<String, Row>();

        private Table(String name, Function<WarcRecord, String> warcKeyFunction, Function<CdxRecord, String> cdxKeyFunction) {
            this.name = name;
            this.warcKeyFunction = warcKeyFunction;
            this.cdxKeyFunction = cdxKeyFunction;
        }

        public void add(WarcRecord record, long size) {
            String key = this.warcKeyFunction.apply(record);
            if (key == null) {
                return;
            }
            this.rows.computeIfAbsent(key, Row::new).add(size);
        }

        public void add(CdxRecord record) {
            String key = this.cdxKeyFunction.apply(record);
            if (key == null) {
                return;
            }
            this.rows.computeIfAbsent(key, Row::new).add(record.size());
        }

        public void print(Function<Long, String> sizeFormatter) {
            if (this.rows.isEmpty()) {
                return;
            }
            int maxKeyLength = Math.max(this.name.length(), this.rows.keySet().stream().mapToInt(String::length).max().orElse(10));
            System.out.printf("%-" + maxKeyLength + "s %10s %10s %10s%n", this.name, "COUNT", "TOTSIZE", "AVGSIZE");
            this.rows.values().stream().sorted(Comparator.comparing(e -> -e.count)).forEachOrdered(row -> System.out.printf("%-" + maxKeyLength + "s %10d %10s %10s%n", row.key, row.count, sizeFormatter.apply(row.totalSize), sizeFormatter.apply(row.totalSize / row.count)));
            System.out.println();
        }
    }

    private static class Row {
        final String key;
        long count;
        long totalSize;

        Row(String key) {
            this.key = key;
        }

        public void add(long size) {
            ++this.count;
            this.totalSize += size;
        }
    }
}

