/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Configurable;

public interface SchemaProvider
extends Configurable {
    public static final String SCHEMA_VERSION_FETCHER_CONFIG = "schemaVersionFetcher";

    @Override
    default public void configure(Map<String, ?> configs) {
    }

    public String schemaType();

    default public Optional<ParsedSchema> parseSchema(Schema schema, boolean isNew) {
        try {
            return Optional.of(this.parseSchemaOrElseThrow(schema, isNew, false));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    default public Optional<ParsedSchema> parseSchema(Schema schema, boolean isNew, boolean normalize) {
        try {
            return Optional.of(this.parseSchemaOrElseThrow(schema, isNew, normalize));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    default public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references, boolean isNew) {
        try {
            return Optional.of(this.parseSchemaOrElseThrow(new Schema(null, null, null, this.schemaType(), references, schemaString), isNew, false));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    default public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references, boolean isNew, boolean normalize) {
        try {
            return Optional.of(this.parseSchemaOrElseThrow(new Schema(null, null, null, this.schemaType(), references, schemaString), isNew, normalize));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    default public Optional<ParsedSchema> parseSchema(String schemaString, List<SchemaReference> references) {
        return this.parseSchema(schemaString, references, false, false);
    }

    public ParsedSchema parseSchemaOrElseThrow(Schema var1, boolean var2, boolean var3);
}

