/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.FieldSchemaDiff;
import java.util.HashMap;
import java.util.HashSet;

public class OneOfDiff {
    static void compare(Context ctx, OneOfElement original, OneOfElement update) {
        HashMap<Integer, FieldElement> originalByTag = new HashMap<Integer, FieldElement>();
        for (FieldElement fieldElement : original.getFields()) {
            originalByTag.put(fieldElement.getTag(), fieldElement);
        }
        HashMap<Integer, FieldElement> updateByTag = new HashMap<Integer, FieldElement>();
        for (FieldElement field : update.getFields()) {
            updateByTag.put(field.getTag(), field);
        }
        HashSet hashSet = new HashSet(originalByTag.keySet());
        hashSet.addAll(updateByTag.keySet());
        for (Integer tag : hashSet) {
            Context.PathScope pathScope = ctx.enterPath(tag.toString());
            Throwable throwable = null;
            try {
                FieldElement originalField = (FieldElement)originalByTag.get(tag);
                FieldElement updateField = (FieldElement)updateByTag.get(tag);
                if (updateField == null) {
                    ctx.addDifference(Difference.Type.ONEOF_FIELD_REMOVED);
                    continue;
                }
                if (originalField == null) {
                    ctx.addDifference(Difference.Type.ONEOF_FIELD_ADDED);
                    continue;
                }
                FieldSchemaDiff.compare(ctx, originalField, updateField);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pathScope == null) continue;
                if (throwable != null) {
                    try {
                        pathScope.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pathScope.close();
            }
        }
    }
}

