/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.spark3;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.segment.local.utils.ConsistentDataPushUtils;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.PinotClusterSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.scheduler.JobFailed;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;

public class SparkSegmentMetadataPushJobRunner
implements IngestionJobRunner,
Serializable {
    private SegmentGenerationJobSpec _spec;

    public void init(SegmentGenerationJobSpec spec) {
        this._spec = spec;
    }

    public void run() throws Exception {
        this.setupFileSystems();
        URI outputDirURI = this.validateOutputDirURI(this._spec.getOutputDirURI());
        PinotFS outputDirFS = PinotFSFactory.create((String)outputDirURI.getScheme());
        List<String> segmentsToPush = this.getSegmentsToPush(outputDirFS, outputDirURI);
        this.setupTableConfigURI();
        TableConfig tableConfig = SegmentGenerationUtils.getTableConfig((String)this._spec.getTableSpec().getTableConfigURI(), (String)this._spec.getAuthToken());
        boolean consistentPushEnabled = ConsistentDataPushUtils.consistentDataPushEnabled((TableConfig)tableConfig);
        int pushParallelism = this._spec.getPushJobSpec().getPushParallelism();
        if (pushParallelism < 1) {
            pushParallelism = segmentsToPush.size();
        }
        if (consistentPushEnabled) {
            this.handleConsistentPush(segmentsToPush, outputDirURI, pushParallelism);
        } else {
            this.handleNonConsistentPush(segmentsToPush, outputDirFS, outputDirURI, pushParallelism);
        }
    }

    private void handleConsistentPush(List<String> segmentsToPush, URI outputDirURI, int pushParallelism) throws Exception {
        Map segmentsToPushUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputDirURI, (PushJobSpec)this._spec.getPushJobSpec(), (String[])segmentsToPush.toArray(new String[0]));
        Map uriToLineageEntryIdMap = ConsistentDataPushUtils.preUpload((SegmentGenerationJobSpec)this._spec, this.getSegmentsToReplace(segmentsToPushUriToTarPathMap));
        if (pushParallelism == 1) {
            SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)this._spec, (PinotFS)PinotFSFactory.create((String)outputDirURI.getScheme()), (Map)segmentsToPushUriToTarPathMap);
        } else {
            JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)SparkContext.getOrCreate());
            sparkContext.sc().addSparkListener((SparkListenerInterface)new ConsistentDataPushFailureHandler(this._spec, uriToLineageEntryIdMap));
            JavaRDD pathRDD = sparkContext.parallelize(segmentsToPush, pushParallelism);
            if (this._spec.getPushJobSpec().isBatchSegmentUpload()) {
                pathRDD.foreachPartition((VoidFunction & Serializable)segmentIterator -> {
                    this.setupFileSystems();
                    ArrayList segmentsInPartition = new ArrayList();
                    segmentIterator.forEachRemaining(segmentsInPartition::add);
                    Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputDirURI, (PushJobSpec)this._spec.getPushJobSpec(), (String[])segmentsInPartition.toArray(new String[0]));
                    SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)this._spec, (PinotFS)PinotFSFactory.create((String)outputDirURI.getScheme()), (Map)segmentUriToTarPathMap);
                });
            } else {
                pathRDD.foreach((VoidFunction & Serializable)segmentTarPath -> {
                    this.setupFileSystems();
                    Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputDirURI, (PushJobSpec)this._spec.getPushJobSpec(), (String[])new String[]{segmentTarPath});
                    SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)this._spec, (PinotFS)PinotFSFactory.create((String)outputDirURI.getScheme()), (Map)segmentUriToTarPathMap);
                });
            }
        }
        this.executePostUpload(uriToLineageEntryIdMap);
    }

    private void handleNonConsistentPush(List<String> segmentsToPush, PinotFS outputDirFS, final URI outputDirURI, int pushParallelism) throws Exception {
        if (pushParallelism == 1) {
            try {
                SegmentPushUtils.pushSegments((SegmentGenerationJobSpec)this._spec, (PinotFS)outputDirFS, segmentsToPush);
            }
            catch (AttemptsExceededException | RetriableOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)SparkContext.getOrCreate());
            JavaRDD pathRDD = sparkContext.parallelize(segmentsToPush, pushParallelism);
            if (this._spec.getPushJobSpec().isBatchSegmentUpload()) {
                pathRDD.foreachPartition((VoidFunction)new VoidFunction<Iterator<String>>(){

                    public void call(Iterator<String> segmentIterator) throws Exception {
                        PluginManager.get().init();
                        SparkSegmentMetadataPushJobRunner.this.setupFileSystems();
                        ArrayList segmentsInPartition = new ArrayList();
                        segmentIterator.forEachRemaining(segmentsInPartition::add);
                        try {
                            Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputDirURI, (PushJobSpec)SparkSegmentMetadataPushJobRunner.this._spec.getPushJobSpec(), (String[])segmentsInPartition.toArray(new String[0]));
                            SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)SparkSegmentMetadataPushJobRunner.this._spec, (PinotFS)PinotFSFactory.create((String)outputDirURI.getScheme()), (Map)segmentUriToTarPathMap);
                        }
                        catch (AttemptsExceededException | RetriableOperationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                pathRDD.foreach((VoidFunction)new VoidFunction<String>(){

                    public void call(String segmentTarPath) throws Exception {
                        PluginManager.get().init();
                        SparkSegmentMetadataPushJobRunner.this.setupFileSystems();
                        try {
                            Map segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap((URI)outputDirURI, (PushJobSpec)SparkSegmentMetadataPushJobRunner.this._spec.getPushJobSpec(), (String[])new String[]{segmentTarPath});
                            SegmentPushUtils.sendSegmentUriAndMetadata((SegmentGenerationJobSpec)SparkSegmentMetadataPushJobRunner.this._spec, (PinotFS)PinotFSFactory.create((String)outputDirURI.getScheme()), (Map)segmentUriToTarPathMap);
                        }
                        catch (AttemptsExceededException | RetriableOperationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }
    }

    private List<String> getSegmentsToPush(PinotFS outputDirFS, URI outputDirURI) {
        String[] files = this.listFiles(outputDirFS, outputDirURI);
        return Arrays.stream(files).filter(file -> file.endsWith(".tar.gz")).collect(Collectors.toList());
    }

    private void setupFileSystems() {
        List pinotFSSpecs = this._spec.getPinotFSSpecs();
        for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
            PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
        }
    }

    private URI validateOutputDirURI(String outputDir) {
        URI outputDirURI;
        try {
            outputDirURI = new URI(outputDir);
            if (outputDirURI.getScheme() == null) {
                outputDirURI = new File(outputDir).toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("outputDirURI is not valid - '" + outputDir + "'");
        }
        return outputDirURI;
    }

    private String[] listFiles(PinotFS outputDirFS, URI outputDirURI) throws RuntimeException {
        try {
            return outputDirFS.listFiles(outputDirURI, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list all files under outputDirURI - '" + String.valueOf(outputDirURI) + "'");
        }
    }

    private void setupTableConfigURI() {
        if (this._spec.getTableSpec().getTableConfigURI() == null) {
            if (this._spec.getPinotClusterSpecs() == null || this._spec.getPinotClusterSpecs().length == 0) {
                throw new RuntimeException("Missing property 'tableConfigURI' in 'tableSpec'");
            }
            PinotClusterSpec pinotClusterSpec = this._spec.getPinotClusterSpecs()[0];
            String tableConfigURI = SegmentGenerationUtils.generateTableConfigURI((String)pinotClusterSpec.getControllerURI(), (String)this._spec.getTableSpec().getTableName());
            this._spec.getTableSpec().setTableConfigURI(tableConfigURI);
        }
    }

    private void executePostUpload(Map<URI, String> uriToLineageEntryIdMap) {
        try {
            ConsistentDataPushUtils.postUpload((SegmentGenerationJobSpec)this._spec, uriToLineageEntryIdMap);
        }
        catch (Exception e) {
            ConsistentDataPushUtils.handleUploadException((SegmentGenerationJobSpec)this._spec, uriToLineageEntryIdMap, (Exception)e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getSegmentsToReplace(Map<String, String> segmentsUriToTarPathMap) {
        Collection<String> tarFilePaths = segmentsUriToTarPathMap.values();
        ArrayList<String> segmentNames = new ArrayList<String>(tarFilePaths.size());
        for (String tarFilePath : tarFilePaths) {
            File tarFile = new File(tarFilePath);
            String fileName = tarFile.getName();
            Preconditions.checkArgument((boolean)fileName.endsWith(".tar.gz"));
            String segmentName = fileName.substring(0, fileName.length() - ".tar.gz".length());
            segmentNames.add(segmentName);
        }
        return segmentNames;
    }

    private static class ConsistentDataPushFailureHandler
    extends SparkListener {
        private final SegmentGenerationJobSpec _spec;
        private final Map<URI, String> _uriToLineageEntryIdMap;

        public ConsistentDataPushFailureHandler(SegmentGenerationJobSpec spec, Map<URI, String> uriToLineageEntryIdMap) {
            this._spec = spec;
            this._uriToLineageEntryIdMap = uriToLineageEntryIdMap;
        }

        public void onJobEnd(SparkListenerJobEnd jobEnd) {
            JobResult jobResult = jobEnd.jobResult();
            if (jobResult instanceof JobFailed) {
                try {
                    ConsistentDataPushUtils.handleUploadException((SegmentGenerationJobSpec)this._spec, this._uriToLineageEntryIdMap, (Exception)((JobFailed)jobResult).exception());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to handle upload exception", e);
                }
            }
        }
    }
}

