/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$KEY$;
import kafka.log.IndexSearchType$VALUE$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ne\u0001\u0011\t\u0011)A\u0005geB\u0011B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f \t\u0013}\u0002!\u0011!Q\u0001\n\u0001\u001b\u0005\"\u0002#\u0001\t\u0003)\u0005\"B&\u0001\t\u0003b\u0005BB'\u0001A\u0003&1\u0007C\u0003O\u0001\u0011%q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003V\u0001\u0011\u0005a\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003c\u0001\u0011%1\rC\u0003o\u0001\u0011%q\u000eC\u0003s\u0001\u0011E3\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003z\u0001\u0011\u0005!\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\f\u0001\u0011\u0005\u0013q\u0001\u0005\r\u00033\u0001\u0001\u0013aA\u0001\u0002\u0013%AJ\u0010\u0005\r\u00037\u0001\u0001\u0013aA\u0001\u0002\u0013%A+O\u0004\b\u0003;y\u0002\u0012AA\u0010\r\u0019qr\u0004#\u0001\u0002\"!1A\t\u0007C\u0001\u0003kA\u0011\"a\u000e\u0019\u0005\u0004%\t%!\u000f\t\u0011\u0005E\u0003\u0004)A\u0005\u0003wA\u0011\"a\u0015\u0019#\u0003%\t!!\u0016\t\u0013\u0005-\u0004$%A\u0005\u0002\u00055$aC(gMN,G/\u00138eKbT!\u0001I\u0011\u0002\u00071|wMC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019:S\"A\u0010\n\u0005!z\"!D!cgR\u0014\u0018m\u0019;J]\u0012,\u00070A\u0003`M&dW\r\u0005\u0002,a5\tAF\u0003\u0002.]\u0005\u0011\u0011n\u001c\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0003GS2,\u0017A\u00032bg\u0016|eMZ:fiB\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t!Aj\u001c8h\u0013\t\u0011t%\u0001\u0007nCbLe\u000eZ3y'&TX\r\u0005\u00025y%\u0011Q(\u000e\u0002\u0004\u0013:$\u0018B\u0001\u001e(\u0003!9(/\u001b;bE2,\u0007C\u0001\u001bB\u0013\t\u0011UGA\u0004C_>dW-\u00198\n\u0005}:\u0013A\u0002\u001fj]&$h\bF\u0003G\u000f\"K%\n\u0005\u0002'\u0001!)\u0011&\u0002a\u0001U!)!'\u0002a\u0001g!9!(\u0002I\u0001\u0002\u0004Y\u0004bB \u0006!\u0003\u0005\r\u0001Q\u0001\nK:$(/_*ju\u0016,\u0012aO\u0001\f?2\f7\u000f^(gMN,G/A\u0005mCN$XI\u001c;ssV\t\u0001\u000b\u0005\u0002'#&\u0011!k\b\u0002\u000f\u001f\u001a47/\u001a;Q_NLG/[8o\u0003)a\u0017m\u001d;PM\u001a\u001cX\r^\u000b\u0002g\u00051An\\8lkB$\"\u0001U,\t\u000baS\u0001\u0019A\u001a\u0002\u0019Q\f'oZ3u\u001f\u001a47/\u001a;\u0002+\u0019,Go\u00195VaB,'OQ8v]\u0012|eMZ:fiR\u00191L\u00181\u0011\u0007Qb\u0006+\u0003\u0002^k\t1q\n\u001d;j_:DQaX\u0006A\u0002A\u000b1BZ3uG\"|eMZ:fi\")\u0011m\u0003a\u0001w\u0005Ia-\u001a;dQNK'0Z\u0001\u000fe\u0016d\u0017\r^5wK>3gm]3u)\rYD\r\u001c\u0005\u0006K2\u0001\rAZ\u0001\u0007EV4g-\u001a:\u0011\u0005\u001dTW\"\u00015\u000b\u0005%t\u0013a\u00018j_&\u00111\u000e\u001b\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B7\r\u0001\u0004Y\u0014!\u00018\u0002\u0011AD\u0017p]5dC2$2a\u000f9r\u0011\u0015)W\u00021\u0001g\u0011\u0015iW\u00021\u0001<\u0003)\u0001\u0018M]:f\u000b:$(/\u001f\u000b\u0004!R,\b\"B3\u000f\u0001\u00041\u0007\"B7\u000f\u0001\u0004Y\u0014!B3oiJLHC\u0001)y\u0011\u0015iw\u00021\u0001<\u0003\u0019\t\u0007\u000f]3oIR!1P`A\u0001!\t!D0\u0003\u0002~k\t!QK\\5u\u0011\u0015y\b\u00031\u00014\u0003\u0019ygMZ:fi\"1\u00111\u0001\tA\u0002m\n\u0001\u0002]8tSRLwN\\\u0001\tiJ,hnY1uKR\t10\u0001\u0006ueVt7-\u0019;f)>$2a_A\u0007\u0011\u0015y(\u00031\u00014\u0003E!(/\u001e8dCR,Gk\\#oiJLWm\u001d\u000b\u0004w\u0006M\u0001BBA\u000b'\u0001\u00071(A\u0004f]R\u0014\u0018.Z:\u0002\u0017M\fg.\u001b;z\u0007\",7m[\u0001\u0013gV\u0004XM\u001d\u0013nCbLe\u000eZ3y'&TX-\u0001\ttkB,'\u000f\n2bg\u0016|eMZ:fi\u0006YqJ\u001a4tKRLe\u000eZ3y!\t1\u0003dE\u0003\u0019\u0003G\tI\u0003E\u00025\u0003KI1!a\n6\u0005\u0019\te.\u001f*fMB!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020\u0005\nQ!\u001e;jYNLA!a\r\u0002.\t9Aj\\4hS:<GCAA\u0010\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003w\u0001B!!\u0010\u0002L9!\u0011qHA$!\r\t\t%N\u0007\u0003\u0003\u0007R1!!\u0012$\u0003\u0019a$o\\8u}%\u0019\u0011\u0011J\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\ti%a\u0014\u0003\rM#(/\u001b8h\u0015\r\tI%N\u0001\fY><w-\u001a:OC6,\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003/R3aOA-W\t\tY\u0006\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA3k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0014q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002p)\u001a\u0001)!\u0017")
public class OffsetIndex
extends AbstractIndex {
    private long _lastOffset = this.lastEntry().offset();

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return OffsetIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ fatal_this = offsetIndex$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), fatal_this.msgWithLogIdent(function0.apply()), function02.apply());
            return;
        }
    }

    public static void fatal(Function0<String> function0) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ fatal_this = offsetIndex$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), fatal_this.msgWithLogIdent(function0.apply()));
            return;
        }
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ error_this = offsetIndex$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            error_this.logger().underlying().error(error_this.msgWithLogIdent(function0.apply()), function02.apply());
            return;
        }
    }

    public static void error(Function0<String> function0) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ error_this = offsetIndex$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            error_this.logger().underlying().error(error_this.msgWithLogIdent(function0.apply()));
            return;
        }
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ warn_this = offsetIndex$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(function0.apply()), function02.apply());
            return;
        }
    }

    public static void warn(Function0<String> function0) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ warn_this = offsetIndex$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(function0.apply()));
            return;
        }
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ info_this = offsetIndex$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent(function0.apply()), function02.apply());
            return;
        }
    }

    public static void info(Function0<String> function0) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ info_this = offsetIndex$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent(function0.apply()));
            return;
        }
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ debug_this = offsetIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(function0.apply()), function02.apply());
            return;
        }
    }

    public static void debug(Function0<String> function0) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ debug_this = offsetIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(function0.apply()));
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return OffsetIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return OffsetIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ trace_this = offsetIndex$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            trace_this.logger().underlying().trace(trace_this.msgWithLogIdent(function0.apply()), function02.apply());
            return;
        }
    }

    public static void trace(Function0<String> function0) {
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ trace_this = offsetIndex$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            trace_this.logger().underlying().trace(trace_this.msgWithLogIdent(function0.apply()));
            return;
        }
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    /*
     * WARNING - void declaration
     */
    private OffsetPosition lastEntry() {
        OffsetPosition offsetPosition;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            offsetPosition = OffsetIndex.$anonfun$lastEntry$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return offsetPosition;
    }

    public long lastOffset() {
        return this._lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0<OffsetPosition> & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetOffset, IndexSearchType$KEY$.MODULE$);
            if (slot == -1) {
                return new OffsetPosition(this.super$baseOffset(), 0);
            }
            return this.parseEntry(idx, slot);
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), (Function0<Option> & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.smallestUpperBoundSlotFor(idx, fetchOffset.position() + fetchSize, IndexSearchType$VALUE$.MODULE$);
            if (slot == -1) {
                return None$.MODULE$;
            }
            return new Some<OffsetPosition>(this.parseEntry(idx, slot));
        });
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public OffsetPosition parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0<OffsetPosition> & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(59).append("Attempt to fetch the ").append(n).append("th entry from index ").append(this.file().getAbsolutePath()).append(", ").append("which has size ").append(this._entries()).append(".").toString());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void append(long offset, int position) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            OffsetIndex.$anonfun$append$1(this, offset, position);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void truncateTo(long offset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            OffsetIndex.$anonfun$truncateTo$1(this, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void truncateToEntries(int entries) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            OffsetIndex.$anonfun$truncateToEntries$1(this, entries);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public void sanityCheck() {
        if (this._entries() != 0 && this._lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(113).append("Corrupt index found, index file (").append(this.file().getAbsolutePath()).append(") has non-zero size ").append("but the last offset is ").append(this._lastOffset).append(" which is less than the base offset ").append(super.baseOffset()).append(".").toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(82).append("Index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes which is ").append("neither positive nor a multiple of ").append(this.entrySize()).append(".").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$new$1(OffsetIndex $this) {
        return new StringBuilder(99).append("Loaded index file ").append($this.file().getAbsolutePath()).append(" with maxEntries = ").append($this.maxEntries()).append(", ").append("maxIndexSize = ").append($this.super$maxIndexSize()).append(", entries = ").append($this._entries()).append(", lastOffset = ").append($this._lastOffset).append(", file position = ").append($this.mmap().position()).toString();
    }

    public static final /* synthetic */ OffsetPosition $anonfun$lastEntry$1(OffsetIndex $this) {
        int n = $this._entries();
        switch (n) {
            case 0: {
                return new OffsetPosition($this.super$baseOffset(), 0);
            }
        }
        return $this.parseEntry($this.mmap(), n - 1);
    }

    public static final /* synthetic */ String $anonfun$append$3(OffsetIndex $this, long offset$1, int position$1) {
        return new StringBuilder(27).append("Adding index entry ").append(offset$1).append(" => ").append(position$1).append(" to ").append($this.file().getAbsolutePath()).toString();
    }

    public static final /* synthetic */ void $anonfun$append$1(OffsetIndex $this, long offset$1, int position$1) {
        Predef$.MODULE$.require(!$this.isFull(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Attempt to append to a full index (size = ").append($this._entries()).append(").").toString());
        if ($this._entries() == 0 || offset$1 > $this._lastOffset) {
            OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
            if (offsetIndex$ == null) {
                throw null;
            }
            OffsetIndex$ trace_this = offsetIndex$;
            if (trace_this.logger().underlying().isTraceEnabled()) {
                trace_this.logger().underlying().trace(trace_this.msgWithLogIdent(OffsetIndex.$anonfun$append$3($this, offset$1, position$1)));
            }
            $this.mmap().putInt($this.relativeOffset(offset$1));
            $this.mmap().putInt(position$1);
            $this._entries_$eq($this._entries() + 1);
            $this._lastOffset = offset$1;
            Predef$.MODULE$.require($this._entries() * $this.entrySize() == $this.mmap().position(), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(40).append($this.entries()).append(" entries but file position in index is ").append($this.mmap().position()).append(".").toString());
            return;
        }
        throw new InvalidOffsetException(new StringBuilder(91).append("Attempt to append an offset (").append(offset$1).append(") to position ").append($this.entries()).append(" no larger than").append(" the last offset appended (").append($this._lastOffset).append(") to ").append($this.file().getAbsolutePath()).append(".").toString());
    }

    public static final /* synthetic */ void $anonfun$truncateTo$1(OffsetIndex $this, long offset$2) {
        ByteBuffer idx = $this.mmap().duplicate();
        int slot = $this.largestLowerBoundSlotFor(idx, offset$2, IndexSearchType$KEY$.MODULE$);
        int newEntries = slot < 0 ? 0 : ((long)$this.relativeOffset(idx, slot) == offset$2 - $this.super$baseOffset() ? slot : slot + 1);
        $this.truncateToEntries(newEntries);
    }

    public static final /* synthetic */ String $anonfun$truncateToEntries$2(OffsetIndex $this, int entries$1) {
        return new StringBuilder(70).append("Truncated index ").append($this.file().getAbsolutePath()).append(" to ").append(entries$1).append(" entries;").append(" position is now ").append($this.mmap().position()).append(" and last offset is now ").append($this._lastOffset).toString();
    }

    public static final /* synthetic */ void $anonfun$truncateToEntries$1(OffsetIndex $this, int entries$1) {
        $this._entries_$eq(entries$1);
        $this.mmap().position($this._entries() * $this.entrySize());
        $this._lastOffset = $this.lastEntry().offset();
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ debug_this = offsetIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(OffsetIndex.$anonfun$truncateToEntries$2($this, entries$1)));
            return;
        }
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        OffsetIndex$ offsetIndex$ = OffsetIndex$.MODULE$;
        if (offsetIndex$ == null) {
            throw null;
        }
        OffsetIndex$ debug_this = offsetIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(OffsetIndex.$anonfun$new$1(this)));
            return;
        }
    }
}

