/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction1$mcVJ$sp;
import scala.runtime.java8.JFunction1$mcZJ$sp;

@ScalaSignature(bytes="\u0006\u0001\rUu!\u00021b\u0011\u00031g!\u00025b\u0011\u0003I\u0007\"\u00029\u0002\t\u0003\t\bb\u0002:\u0002\u0005\u0004%Ia\u001d\u0005\u0007o\u0006\u0001\u000b\u0011\u0002;\t\u000fa\f!\u0019!C\u0005s\"9\u0011QA\u0001!\u0002\u0013Q\b\u0002CA\u0004\u0003\t\u0007I\u0011B=\t\u000f\u0005%\u0011\u0001)A\u0005u\"A\u00111B\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002\u000e\u0005\u0001\u000b\u0011\u0002>\t\u0011\u0005=\u0011A1A\u0005\neDq!!\u0005\u0002A\u0003%!\u0010\u0003\u0005\u0002\u0014\u0005\u0011\r\u0011\"\u0003z\u0011\u001d\t)\"\u0001Q\u0001\niD\u0001\"a\u0006\u0002\u0005\u0004%I!\u001f\u0005\b\u00033\t\u0001\u0015!\u0003{\u0011!\tY\"\u0001b\u0001\n\u0013I\bbBA\u000f\u0003\u0001\u0006IA\u001f\u0005\t\u0003?\t!\u0019!C\u0005s\"9\u0011\u0011E\u0001!\u0002\u0013Q\b\u0002CA\u0012\u0003\t\u0007I\u0011B=\t\u000f\u0005\u0015\u0012\u0001)A\u0005u\"A\u0011qE\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002*\u0005\u0001\u000b\u0011\u0002>\t\u0011\u0005-\u0012A1A\u0005\neDq!!\f\u0002A\u0003%!\u0010C\u0005\u00020\u0005\u0011\r\u0011\"\u0003\u00022!A\u0011\u0011H\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002<\u0005\u0011\r\u0011\"\u0003\u00022!A\u0011QH\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002@\u0005\u0011\r\u0011\"\u0003\u00022!A\u0011\u0011I\u0001!\u0002\u0013\t\u0019\u0004C\u0005\u0002D\u0005\u0011\r\u0011\"\u0001\u0002F!A\u0011QM\u0001!\u0002\u0013\t9\u0005C\u0005\u0002h\u0005\u0011\r\u0011\"\u0001\u0002F!A\u0011\u0011N\u0001!\u0002\u0013\t9\u0005C\u0004\u0002l\u0005!\t!!\u001c\t\u000f\u0005u\u0015\u0001\"\u0003\u0002 \"9\u00111Y\u0001\u0005\n\u0005\u0015\u0007\u0002CAh\u0003\u0011\u0005\u0011-!5\t\u0013\u0005\r\u0018!%A\u0005\u0002\u0005\u0015h!\u00025b\u0001\u0005m\bB\u0003B\u0005U\t\u0015\r\u0011\"\u0001\u0003\f!Q!Q\u0003\u0016\u0003\u0002\u0003\u0006IA!\u0004\t\u0015\t]!F!a\u0001\n\u0003\u0011I\u0002\u0003\u0006\u0003\u001c)\u0012\t\u0019!C\u0001\u0005;A!Ba\t+\u0005\u0003\u0005\u000b\u0015BAI\u0011)\u0011iC\u000bBC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0005_Q#\u0011!Q\u0001\n\u0005M\u0002B\u00029+\t\u0003\u0011\t\u0004C\u0005\u0003<)\u0002\r\u0011\"\u0003\u0003>!I!1\u000b\u0016A\u0002\u0013%!Q\u000b\u0005\t\u00053R\u0003\u0015)\u0003\u0003@!I!1\f\u0016C\u0002\u0013%!Q\f\u0005\t\u0005?R\u0003\u0015!\u0003\u0002.\"I!\u0011\r\u0016A\u0002\u0013%!1\r\u0005\n\u0005KR\u0003\u0019!C\u0005\u0005OB\u0001Ba\u001b+A\u0003&\u0011Q\u0018\u0005\n\u0005[R\u0003\u0019!C\u0005\u0005GB\u0011Ba\u001c+\u0001\u0004%IA!\u001d\t\u0011\tU$\u0006)Q\u0005\u0003{C\u0011Ba\u001e+\u0005\u0004%IA!\u001f\t\u0011\t%%\u0006)A\u0005\u0005wB\u0011Ba#+\u0005\u0004%IA!\u001f\t\u0011\t5%\u0006)A\u0005\u0005wBqAa$+\t\u0013\u0011\t\n\u0003\u0005\u0003\u0014*\"\t!\u0019BK\u0011\u001d\u0011iJ\u000bC\u0001\u0005?CqAa-+\t\u0003\u0011)\f\u0003\u0005\u0003<*\"\t!\u0019B_\u0011\u001d\u0011\tM\u000bC\u0001\u0005GBqAa1+\t\u0003\u0011)\rC\u0004\u0003R*\"\tAa5\t\u000f\tU'\u0006\"\u0003\u0003X\"A!\u0011\u001d\u0016\u0005\u0002\u0005\u0014\u0019\u000fC\u0004\u0003j*\"IAa;\t\u000f\tU(\u0006\"\u0001\u0003x\"9!1 \u0016\u0005\u0002\tu\bbBB\u0004U\u0011\u00051\u0011\u0002\u0005\b\u0007?QC\u0011AB\u0011\u0011\u001d\u00199C\u000bC\u0001\u0007SAqaa\f+\t\u0003\u0019\t\u0004C\u0004\u00048)\"\ta!\u000f\t\u000f\rm\"\u0006\"\u0001\u0004>!911\t\u0016\u0005\u0002\tu\u0006bBB#U\u0011\u0005!Q\u0018\u0005\b\u0007\u000fRC\u0011AB%\u0011\u001d\u0019iE\u000bC\u0005\u0007\u001fBqa!\u0016+\t\u0003\u00199\u0006C\u0004\u0004\\)\"\ta!\u0018\t\u000f\r%$\u0006\"\u0001\u0004l!91q\u000e\u0016\u0005\u0002\rE\u0004bBB?U\u0011%1q\u0010\u0005\b\u0007\u0007SC\u0011BB@\u0011!\u0019)I\u000bC\u0001C\u000e\u001d\u0015\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002cG\u0006\u0019An\\4\u000b\u0003\u0011\fQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002h\u00035\t\u0011M\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u0003)\u0004\"a\u001b8\u000e\u00031T\u0011!\\\u0001\u0006g\u000e\fG.Y\u0005\u0003_2\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001g\u0003]\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|GOV3sg&|g.F\u0001u!\tYW/\u0003\u0002wY\n)1\u000b[8si\u0006A\u0002K]8ek\u000e,'o\u00158baNDw\u000e\u001e,feNLwN\u001c\u0011\u0002\u0019Y+'o]5p]\u001aKW\r\u001c3\u0016\u0003i\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003\u0011a\u0017M\\4\u000b\u0003}\fAA[1wC&\u0019\u00111\u0001?\u0003\rM#(/\u001b8h\u000351VM]:j_:4\u0015.\u001a7eA\u0005A1I]2GS\u0016dG-A\u0005De\u000e4\u0015.\u001a7eA\u0005y\u0001K]8ek\u000e,'/\u00133GS\u0016dG-\u0001\tQe>$WoY3s\u0013\u00124\u0015.\u001a7eA\u0005\tB*Y:u'\u0016\fX/\u001a8dK\u001aKW\r\u001c3\u0002%1\u000b7\u000f^*fcV,gnY3GS\u0016dG\rI\u0001\u0013!J|G-^2fe\u0016\u0003xn\u00195GS\u0016dG-A\nQe>$WoY3s\u000bB|7\r\u001b$jK2$\u0007%A\bMCN$xJ\u001a4tKR4\u0015.\u001a7e\u0003Aa\u0015m\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007%\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\u0006\trJ\u001a4tKR$U\r\u001c;b\r&,G\u000e\u001a\u0011\u0002\u001dQKW.Z:uC6\u0004h)[3mI\u0006yA+[7fgR\fW\u000e\u001d$jK2$\u0007%\u0001\u000bQe>$WoY3s\u000b:$(/[3t\r&,G\u000eZ\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0003U\u0019un\u001c:eS:\fGo\u001c:Fa>\u001c\u0007NR5fY\u0012\facQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\rI\u0001\u001b\u0007V\u0014(/\u001a8u)btg)\u001b:ti>3gm]3u\r&,G\u000eZ\u0001\u001c\u0007V\u0014(/\u001a8u)btg)\u001b:ti>3gm]3u\r&,G\u000e\u001a\u0011\u0002\u001bY+'o]5p]>3gm]3u+\t\t\u0019\u0004E\u0002l\u0003kI1!a\u000em\u0005\rIe\u000e^\u0001\u000f-\u0016\u00148/[8o\u001f\u001a47/\u001a;!\u0003%\u0019%oY(gMN,G/\u0001\u0006De\u000e|eMZ:fi\u0002\nQ\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G/\u0001\fQe>$WoY3s\u000b:$(/[3t\u001f\u001a47/\u001a;!\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\u0011\u0011q\t\t\u0005\u0003\u0013\n\t'\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0015!\u0018\u0010]3t\u0015\u0011\t\t&a\u0015\u0002\u0011A\u0014x\u000e^8d_2TA!!\u0016\u0002X\u000511m\\7n_:T1\u0001ZA-\u0015\u0011\tY&!\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty&A\u0002pe\u001eLA!a\u0019\u0002L\t11k\u00195f[\u0006\fA\u0004\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;F]R\u0014\u0018pU2iK6\f\u0007%\u0001\u000bQS\u0012\u001cf.\u00199tQ>$X*\u00199TG\",W.Y\u0001\u0016!&$7K\\1qg\"|G/T1q'\u000eDW-\\1!\u00031\u0011X-\u00193T]\u0006\u00048\u000f[8u)\u0011\ty'!$\u0011\r\u0005E\u0014\u0011QAD\u001d\u0011\t\u0019(! \u000f\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001ff\u0003\u0019a$o\\8u}%\tQ.C\u0002\u0002\u00001\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0004\u0006\u0015%\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005}D\u000eE\u0002h\u0003\u0013K1!a#b\u0005I\u0001&o\u001c3vG\u0016\u00148\u000b^1uK\u0016sGO]=\t\u000f\u0005=U\u00051\u0001\u0002\u0012\u0006!a-\u001b7f!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAAL}\u0006\u0011\u0011n\\\u0005\u0005\u00037\u000b)J\u0001\u0003GS2,\u0017!D<sSR,7K\\1qg\"|G\u000f\u0006\u0004\u0002\"\u0006\u001d\u0016\u0011\u0016\t\u0004W\u0006\r\u0016bAASY\n!QK\\5u\u0011\u001d\tyI\na\u0001\u0003#Cq!a+'\u0001\u0004\ti+A\u0004f]R\u0014\u0018.Z:\u0011\u0011\u0005=\u0016\u0011XA_\u0003\u000fk!!!-\u000b\t\u0005M\u0016QW\u0001\b[V$\u0018M\u00197f\u0015\r\t9\f\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA^\u0003c\u00131!T1q!\rY\u0017qX\u0005\u0004\u0003\u0003d'\u0001\u0002'p]\u001e\fa\"[:T]\u0006\u00048\u000f[8u\r&dW\r\u0006\u0003\u0002H\u00065\u0007cA6\u0002J&\u0019\u00111\u001a7\u0003\u000f\t{w\u000e\\3b]\"9\u0011qR\u0014A\u0002\u0005E\u0015!\u00057jgR\u001cf.\u00199tQ>$h)\u001b7fgR!\u00111[Ap!\u0019\t\t(!6\u0002Z&!\u0011q[AC\u0005\r\u0019V-\u001d\t\u0004O\u0006m\u0017bAAoC\na1K\\1qg\"|GOR5mK\"9\u0011\u0011\u001d\u0015A\u0002\u0005E\u0015a\u00013je\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a:+\t\u0005M\u0012\u0011^\u0016\u0003\u0003W\u0004B!!<\u0002x6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u00190A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001f7\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0006=(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKN!!F[A\u007f!\u0011\tyP!\u0002\u000e\u0005\t\u0005!b\u0001B\u0002G\u0006)Q\u000f^5mg&!!q\u0001B\u0001\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0003\u000eA!!q\u0002B\t\u001b\t\t\u0019&\u0003\u0003\u0003\u0014\u0005M#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u00059q\f\\8h\t&\u0014XCAAI\u0003-yFn\\4ESJ|F%Z9\u0015\t\u0005\u0005&q\u0004\u0005\n\u0005Cq\u0013\u0011!a\u0001\u0003#\u000b1\u0001\u001f\u00132\u0003!yFn\\4ESJ\u0004\u0003fA\u0018\u0003(A\u00191N!\u000b\n\u0007\t-BN\u0001\u0005w_2\fG/\u001b7f\u0003ei\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:\u000255\f\u0007\u0010\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\u0015\u0011\tM\"Q\u0007B\u001c\u0005s\u0001\"a\u001a\u0016\t\u000f\t%!\u00071\u0001\u0003\u000e!9!q\u0003\u001aA\u0002\u0005E\u0005\"\u0003B\u0017eA\u0005\t\u0019AA\u001a\u0003%\u0019h.\u00199tQ>$8/\u0006\u0002\u0003@AA!\u0011\tB&\u0005\u001f\nI.\u0004\u0002\u0003D)!!Q\tB$\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005\u0013r\u0018\u0001B;uS2LAA!\u0014\u0003D\t)2i\u001c8dkJ\u0014XM\u001c;TW&\u0004H*[:u\u001b\u0006\u0004\bcA>\u0003R%\u0019\u0011\u0011\u0019?\u0002\u001bMt\u0017\r]:i_R\u001cx\fJ3r)\u0011\t\tKa\u0016\t\u0013\t\u0005B'!AA\u0002\t}\u0012AC:oCB\u001c\bn\u001c;tA\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003[\u000b!\u0002\u001d:pIV\u001cWM]:!\u00035a\u0017m\u001d;NCB|eMZ:fiV\u0011\u0011QX\u0001\u0012Y\u0006\u001cH/T1q\u001f\u001a47/\u001a;`I\u0015\fH\u0003BAQ\u0005SB\u0011B!\t:\u0003\u0003\u0005\r!!0\u0002\u001d1\f7\u000f^'ba>3gm]3uA\u0005qA.Y:u':\f\u0007o\u00144gg\u0016$\u0018A\u00057bgR\u001cf.\u00199PM\u001a\u001cX\r^0%KF$B!!)\u0003t!I!\u0011\u0005\u001f\u0002\u0002\u0003\u0007\u0011QX\u0001\u0010Y\u0006\u001cHo\u00158ba>3gm]3uA\u0005YqN\\4pS:<G\u000b\u001f8t+\t\u0011Y\b\u0005\u0005\u0003~\t}\u0014Q\u0018BB\u001b\t\u00119%\u0003\u0003\u0003\u0002\n\u001d#a\u0002+sK\u0016l\u0015\r\u001d\t\u0004O\n\u0015\u0015b\u0001BDC\nYA\u000b\u001f8NKR\fG-\u0019;b\u00031ygnZ8j]\u001e$\u0006P\\:!\u0003A)hN]3qY&\u001c\u0017\r^3e)bt7/A\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\u0002\nQ\u0002\\8bINs\u0017\r]:i_R\u001cHC\u0001B \u0003Q\u0011X-\\8wKN#(/Y=T]\u0006\u00048\u000f[8ugR!\u0011\u0011\u0015BL\u0011\u001d\u0011Ij\u0011a\u0001\u00057\u000b!c]3h[\u0016tGOQ1tK>3gm]3ugB1\u0011\u0011OAk\u0003{\u000b1CZ5sgR,fn\u001d;bE2,wJ\u001a4tKR,\"A!)\u0011\u000b-\u0014\u0019Ka*\n\u0007\t\u0015FN\u0001\u0004PaRLwN\u001c\t\u0005\u0005S\u0013y+\u0004\u0002\u0003,*\u0019!QV2\u0002\rM,'O^3s\u0013\u0011\u0011\tLa+\u0003#1{wm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018-\u0001\fp]\"Kw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3e)\u0011\t\tKa.\t\u000f\teV\t1\u0001\u0002>\u0006i\u0001.[4i/\u0006$XM]7be.\fACZ5sgR,f\u000eZ3dS\u0012,Gm\u00144gg\u0016$XC\u0001B`!\u0015Y'1UA_\u00031i\u0017\r]#oI>3gm]3u\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXC\u0001Bd!!\u0011IMa4\u0002>\u0006\u001dUB\u0001Bf\u0015\u0011\u0011i-!.\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA^\u0005\u0017\fq![:F[B$\u00180\u0006\u0002\u0002H\u0006\u0001Bn\\1e\rJ|Wn\u00158baNDw\u000e\u001e\u000b\u0007\u0003C\u0013IN!8\t\u000f\tm'\n1\u0001\u0002>\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bb\u0002Bp\u0015\u0002\u0007\u0011QX\u0001\fGV\u0014(/\u001a8u)&lW-A\tm_\u0006$\u0007K]8ek\u000e,'/\u00128uef$B!!)\u0003f\"9!q]&A\u0002\u0005\u001d\u0015!B3oiJL\u0018!E5t!J|G-^2fe\u0016C\b/\u001b:fIR1\u0011q\u0019Bw\u0005cDqAa<M\u0001\u0004\ti,A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\u0005\b\u0005gd\u0005\u0019AAD\u00035\u0001(o\u001c3vG\u0016\u00148\u000b^1uK\u00061\"/Z7pm\u0016,\u0005\u0010]5sK\u0012\u0004&o\u001c3vG\u0016\u00148\u000f\u0006\u0003\u0002\"\ne\bb\u0002Bx\u001b\u0002\u0007\u0011QX\u0001\u0012iJ,hnY1uK\u0006sGMU3m_\u0006$G\u0003CAQ\u0005\u007f\u001c\ta!\u0002\t\u000f\tmg\n1\u0001\u0002>\"911\u0001(A\u0002\u0005u\u0016\u0001\u00047pO\u0016sGm\u00144gg\u0016$\bb\u0002Bx\u001d\u0002\u0007\u0011QX\u0001\u000eaJ,\u0007/\u0019:f+B$\u0017\r^3\u0015\r\r-1\u0011CB\u000b!\r97QB\u0005\u0004\u0007\u001f\t'A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>Dqaa\u0005P\u0001\u0004\ti,\u0001\u0006qe>$WoY3s\u0013\u0012Dqaa\u0006P\u0001\u0004\u0019I\"\u0001\u0004pe&<\u0017N\u001c\t\u0004O\u000em\u0011bAB\u000fC\na\u0011\t\u001d9f]\u0012|%/[4j]\u00061Q\u000f\u001d3bi\u0016$B!!)\u0004$!91Q\u0005)A\u0002\r-\u0011AC1qa\u0016tG-\u00138g_\u0006\u0011R\u000f\u001d3bi\u0016l\u0015\r]#oI>3gm]3u)\u0011\t\tka\u000b\t\u000f\r5\u0012\u000b1\u0001\u0002>\u0006QA.Y:u\u001f\u001a47/\u001a;\u0002\u00131\f7\u000f^#oiJLH\u0003BB\u001a\u0007k\u0001Ra\u001bBR\u0003\u000fCqaa\u0005S\u0001\u0004\ti,\u0001\u0007uC.,7K\\1qg\"|G\u000f\u0006\u0002\u0002\"\u0006yQ\u000f\u001d3bi\u0016\u0004\u0016M]3oi\u0012K'\u000f\u0006\u0003\u0002\"\u000e}\u0002bBB!)\u0002\u0007\u0011\u0011S\u0001\na\u0006\u0014XM\u001c;ESJ\fA\u0003\\1uKN$8K\\1qg\"|Go\u00144gg\u0016$\u0018\u0001F8mI\u0016\u001cHo\u00158baNDw\u000e^(gMN,G/A\u000ep]2{wm\u0015;beR|eMZ:fi&s7M]3nK:$X\r\u001a\u000b\u0005\u0003C\u001bY\u0005C\u0004\u0003\\^\u0003\r!!0\u0002=I,Wn\u001c<f+:\u0014X\r\u001d7jG\u0006$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u0003BAQ\u0007#Bqaa\u0015Y\u0001\u0004\ti,\u0001\u0004pM\u001a\u001cX\r^\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$B!!)\u0004Z!911K-A\u0002\u0005u\u0016\u0001\u00057bgR\u001cF/\u00192mK>3gm]3u)\u0011\tila\u0018\t\u000f\r\u0005$\f1\u0001\u0004d\u0005a1m\\7qY\u0016$X\r\u001a+y]B\u0019qm!\u001a\n\u0007\r\u001d\u0014M\u0001\u0007D_6\u0004H.\u001a;fIRCh.A\u0006d_6\u0004H.\u001a;f)btG\u0003BAQ\u0007[Bqa!\u0019\\\u0001\u0004\u0019\u0019'A\u000beK2,G/Z*oCB\u001c\bn\u001c;t\u0005\u00164wN]3\u0015\t\u0005\u000561\u000f\u0005\b\u0007'b\u0006\u0019AA_Q\ra6q\u000f\t\u0005\u0003\u007f\u001cI(\u0003\u0003\u0004|\t\u0005!A\u0003;ie\u0016\fGm]1gK\u0006\u0011r\u000e\u001c3fgR\u001cf.\u00199tQ>$h)\u001b7f+\t\u0019\t\tE\u0003l\u0005G\u000bI.\u0001\nmCR,7\u000f^*oCB\u001c\bn\u001c;GS2,\u0017a\u0006:f[>4X-\u00118e\t\u0016dW\r^3T]\u0006\u00048\u000f[8u)\u0011\t\tk!#\t\u000f\r-u\f1\u0001\u0002>\u0006q1O\\1qg\"|Go\u00144gg\u0016$\bf\u0001\u0016\u0004\u0010B!\u0011q`BI\u0013\u0011\u0019\u0019J!\u0001\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File _logDir;
    private final int maxProducerIdExpirationMs;
    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File _logDir() {
        return this._logDir;
    }

    public void _logDir_$eq(File x$1) {
        this._logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots() {
        return this.snapshots;
    }

    private void snapshots_$eq(ConcurrentSkipListMap<Long, SnapshotFile> x$1) {
        this.snapshots = x$1;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentSkipListMap<Long, SnapshotFile> loadSnapshots() {
        void var1_1;
        ConcurrentSkipListMap tm = new ConcurrentSkipListMap();
        ProducerStateManager$.MODULE$.listSnapshotFiles(this._logDir()).foreach((Function1<SnapshotFile, SnapshotFile> & Serializable & scala.Serializable)f -> tm.put(Predef$.MODULE$.long2Long(f.offset()), f));
        return var1_1;
    }

    public void removeStraySnapshots(Seq<Object> segmentBaseOffsets) {
        Option maxSegmentBaseOffset = segmentBaseOffsets.isEmpty() ? None$.MODULE$ : new Some(segmentBaseOffsets.max(Ordering$Long$.MODULE$));
        Set baseOffsets = segmentBaseOffsets.toSet();
        ObjectRef<None$> latestStraySnapshot = ObjectRef.create(None$.MODULE$);
        ConcurrentSkipListMap<Long, SnapshotFile> ss = this.loadSnapshots();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ss.values()).asScala()).foreach((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$removeStraySnapshots$1(latestStraySnapshot, baseOffsets, ss, snapshot);
            return BoxedUnit.UNIT;
        });
        ((Option)latestStraySnapshot.elem).map((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong(x$2.offset())).foreach((JFunction1$mcVJ$sp & scala.Serializable)strayOffset -> maxSegmentBaseOffset.foreach((JFunction1$mcVJ$sp & scala.Serializable)maxOffset -> {
            if (strayOffset < maxOffset) {
                Option$.MODULE$.apply(ss.remove(BoxesRunTime.boxToLong(strayOffset))).foreach((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.deleteIfExists()));
            }
        }));
        this.snapshots_$eq(ss);
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option<LogOffsetMetadata> unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1<Map.Entry, LogOffsetMetadata> & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option<LogOffsetMetadata> undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1<Map.Entry, LogOffsetMetadata> & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        if (unreplicatedFirstOffset.isEmpty()) {
            return undecidedFirstOffset;
        }
        if (undecidedFirstOffset.isEmpty()) {
            return unreplicatedFirstOffset;
        }
        if (undecidedFirstOffset.get().messageOffset() < unreplicatedFirstOffset.get().messageOffset()) {
            return undecidedFirstOffset;
        }
        return var1_1;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1<Map.Entry, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong(ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<SnapshotFile> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            SnapshotFile snapshot = (SnapshotFile)((Some)option).value();
            try {
                this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(snapshot).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshot.file()).filter((Function1<ProducerStateEntry, Object> & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean(ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)))).foreach((Function1<ProducerStateEntry, Object> & Serializable & scala.Serializable)entry -> {
                    this.loadProducerEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(snapshot.offset());
                this.lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(snapshot.file()).append("': ").append(e.getMessage()).toString());
                this.removeAndDeleteSnapshot(snapshot.offset());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put(BoxesRunTime.boxToLong(producerId), entry);
        entry.currentTxnFirstOffset().foreach((Function1<Object, TxnMetadata> & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong(offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().$minus$minus$eq(((MapLike)this.producers().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, x0$1)))).keySet());
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$truncateAndReload$1(this, logEndOffset, logStartOffset, snapshot);
            return BoxedUnit.UNIT;
        });
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
            return;
        }
        this.onLogStartOffsetIncremented(logStartOffset);
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0<ProducerStateEntry> & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get(BoxesRunTime.boxToLong(appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put(BoxesRunTime.boxToLong(appendInfo.producerId()), updatedEntry);
        } else {
            throw new MatchError(option);
        }
        appendInfo.startedTransactions().foreach((Function1<TxnMetadata, TxnMetadata> & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong(txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get(BoxesRunTime.boxToLong(producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            SnapshotFile snapshotFile = SnapshotFile$.MODULE$.apply(Log$.MODULE$.producerSnapshotFile(this._logDir(), this.lastMapOffset()));
            this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writing producer snapshot at offset ").append(this.lastMapOffset()).toString());
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile.file(), this.producers());
            this.snapshots().put(Predef$.MODULE$.long2Long(snapshotFile.offset()), snapshotFile);
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public void updateParentDir(File parentDir) {
        this._logDir_$eq(parentDir);
        this.snapshots().forEach((x$7, s) -> s.updateParentDir(parentDir));
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong(x$8.offset()));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong(x$9.offset()));
    }

    public void onLogStartOffsetIncremented(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong(this.latestSnapshotOffset().getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().lastOffset().exists((JFunction1$mcZJ$sp & scala.Serializable)x$10 -> x$10 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncateFullyAndStartAt(long offset) {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(offset);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        return BoxesRunTime.unboxToLong(((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1<TxnMetadata, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$11))).map((Function1<TxnMetadata, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong(ProducerStateManager.$anonfun$lastStableOffset$2(x$12))).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong(completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq(new Some<Object>(BoxesRunTime.boxToLong(completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong(completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(offset)).values()).asScala()).foreach((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
    }

    private Option<SnapshotFile> oldestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().firstEntry()).map((Function1<Map.Entry, SnapshotFile> & Serializable & scala.Serializable)x$13 -> (SnapshotFile)x$13.getValue());
    }

    private Option<SnapshotFile> latestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().lastEntry()).map((Function1<Map.Entry, SnapshotFile> & Serializable & scala.Serializable)x$14 -> (SnapshotFile)x$14.getValue());
    }

    public void removeAndDeleteSnapshot(long snapshotOffset) {
        Option$.MODULE$.apply(this.snapshots().remove(BoxesRunTime.boxToLong(snapshotOffset))).foreach((Function1<SnapshotFile, Object> & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean(x$15.deleteIfExists()));
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$1(ObjectRef latestStraySnapshot$1, Set baseOffsets$1, ConcurrentSkipListMap ss$1, SnapshotFile snapshot) {
        long key = snapshot.offset();
        Option option = (Option)latestStraySnapshot$1.elem;
        if (option instanceof Some) {
            SnapshotFile prev = (SnapshotFile)((Some)option).value();
            if (!baseOffsets$1.contains(BoxesRunTime.boxToLong(key))) {
                prev.deleteIfExists();
                ss$1.remove(BoxesRunTime.boxToLong(prev.offset()));
                latestStraySnapshot$1.elem = new Some<SnapshotFile>(snapshot);
                return;
            }
        } else if (None$.MODULE$.equals(option)) {
            if (!baseOffsets$1.contains(BoxesRunTime.boxToLong(key))) {
                latestStraySnapshot$1.elem = new Some<SnapshotFile>(snapshot);
                return;
            }
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong(offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)x0$1._2();
        boolean bl = $this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateAndReload$1(ProducerStateManager $this, long logEndOffset$1, long logStartOffset$1, SnapshotFile snapshot) {
        if (snapshot.offset() > logEndOffset$1 || snapshot.offset() <= logStartOffset$1) {
            $this.removeAndDeleteSnapshot(snapshot.offset());
        }
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$11) {
        return x$11.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$12) {
        return x$12.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File _logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this._logDir = _logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.snapshots = Predef$.MODULE$.locally(this.loadSnapshots());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

