/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\re\u0001\u00026l\u0001AD\u0001\" \u0001\u0003\u0006\u0004%\tA \u0005\n\u0003\u000f\u0001!\u0011!Q\u0001\n}D!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011)\t)\u0003\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003O\u0001!Q1A\u0005\u0002\u0005%\u0002BCA$\u0001\t\u0005\t\u0015!\u0003\u0002,!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003\"CA+\u0001\t\u0007I\u0011AA,\u0011!\ty\u0006\u0001Q\u0001\n\u0005e\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\tY\u0007\u0001Q\u0001\n\u0005\u0015\u0004\"CA7\u0001\t\u0007I\u0011BA8\u0011!\t\t\t\u0001Q\u0001\n\u0005E\u0004\"CAB\u0001\t\u0007I\u0011BAC\u0011!\ti\t\u0001Q\u0001\n\u0005\u001d\u0005\"CAH\u0001\t\u0007I\u0011BAI\u0011!\tI\n\u0001Q\u0001\n\u0005M\u0005\"CAN\u0001\u0001\u0007I\u0011BAC\u0011%\ti\n\u0001a\u0001\n\u0013\ty\n\u0003\u0005\u0002,\u0002\u0001\u000b\u0015BAD\u0011%\ti\u000b\u0001b\u0001\n\u0003\ty\u000b\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAY\u0011%\tY\f\u0001b\u0001\n\u0003\ti\f\u0003\u0005\u0002V\u0002\u0001\u000b\u0011BA`\u0011%\t9\u000e\u0001b\u0001\n\u0003\ti\f\u0003\u0005\u0002Z\u0002\u0001\u000b\u0011BA`\u0011%\tY\u000e\u0001a\u0001\n\u0013\t)\tC\u0005\u0002^\u0002\u0001\r\u0011\"\u0003\u0002`\"A\u00111\u001d\u0001!B\u0013\t9\tC\u0005\u0002n\u0002\u0001\r\u0011\"\u0003\u0002p\"I\u0011Q \u0001A\u0002\u0013%\u0011q \u0005\t\u0005\u0007\u0001\u0001\u0015)\u0003\u0002r\"Y!q\u0001\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0005\u0011-\u0011\t\u0002\u0001a\u0001\u0002\u0004%IAa\u0005\t\u0017\t]\u0001\u00011A\u0001B\u0003&!1\u0002\u0005\n\u00053\u0001\u0001\u0019!C\u0005\u00057A\u0011Ba\t\u0001\u0001\u0004%IA!\n\t\u0011\t%\u0002\u0001)Q\u0005\u0005;A\u0011Ba\u000b\u0001\u0001\u0004%IAa\u0007\t\u0013\t5\u0002\u00011A\u0005\n\t=\u0002\u0002\u0003B\u001a\u0001\u0001\u0006KA!\b\t\u0013\tU\u0002\u00011A\u0005\n\tm\u0001\"\u0003B\u001c\u0001\u0001\u0007I\u0011\u0002B\u001d\u0011!\u0011i\u0004\u0001Q!\n\tu\u0001\"\u0003B \u0001\u0001\u0007I\u0011\u0002B\u000e\u0011%\u0011\t\u0005\u0001a\u0001\n\u0013\u0011\u0019\u0005\u0003\u0005\u0003H\u0001\u0001\u000b\u0015\u0002B\u000f\u0011-\u0011I\u0005\u0001a\u0001\u0002\u0004%IAa\u0013\t\u0017\t5\u0003\u00011AA\u0002\u0013%!q\n\u0005\f\u0005'\u0002\u0001\u0019!A!B\u0013\t\t\u0004C\u0006\u0003V\u0001\u0001\r\u00111A\u0005\n\t]\u0003b\u0003B@\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0003C1B!\"\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003Z!Y!q\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002BE\u0011-\u0011I\n\u0001a\u0001\u0002\u0004%IAa'\t\u0017\t}\u0005\u00011A\u0001B\u0003&!1\u0012\u0005\f\u0005C\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0019\u000bC\u0006\u0003,\u0002\u0001\r\u00111A\u0005\u0002\t5\u0006b\u0003BY\u0001\u0001\u0007\t\u0011)Q\u0005\u0005KC\u0011Ba-\u0001\u0005\u0004%\tA!.\t\u0011\t\r\u0007\u0001)A\u0005\u0005oCqA!2\u0001\t\u0003\u00119\rC\u0004\u0003^\u0002!\tAa8\t\u000f\t\u0005\b\u0001\"\u0001\u0003d\"9!Q\u001d\u0001\u0005\u0002\t\u001dhA\u0002Bu\u0001\u0011\u0011Y\u000fC\u0004\u0002J\t#\ta!\u0001\t\u000f\r\u001d!\t\"\u0011\u0003`\"91\u0011\u0002\u0001\u0005\u0002\t}\u0007bBB\u0006\u0001\u0011\u0005!q\u001c\u0005\b\u0007\u001b\u0001A\u0011\u0001Bp\r\u0019\u0019y\u0001\u0001\u0003\u0004\u0012!9\u0011\u0011\n%\u0005\u0002\rM\u0001bBB\u0004\u0011\u0012\u0005#q\u001c\u0004\u0007\u0007/\u0001Aa!\u0007\t\u0015\t-7J!A!\u0002\u0013\u0011Y\u0001\u0003\u0006\u0003P.\u0013\t\u0011)A\u0005\u0005KC!Ba5L\u0005\u0003\u0005\u000b\u0011BA\u0019\u0011)\u00119n\u0013B\u0001B\u0003%!\u0011\f\u0005\u000b\u00057\\%\u0011!Q\u0001\n\t-\u0005bBA%\u0017\u0012\u000511\u0004\u0005\b\u0007\u000fYE\u0011\tBp\u0011\u001d\u0019I\u0003\u0001C\u0005\u0005?4aaa\u000b\u0001\t\r5\u0002bBA%)\u0012\u00051Q\u0007\u0005\b\u0007s!F\u0011IB\u001e\u0011\u001d\u0019i\u0005\u0016C!\u0005?Dqaa\u0014\u0001\t\u0013\u0011yN\u0002\u0004\u0004R\u0001!11\u000b\u0005\b\u0003\u0013JF\u0011AB+\u0011\u001d\u0019I$\u0017C!\u00073Bqa!\u0014Z\t\u0003\u0012y\u000eC\u0004\u0004^\u0001!IAa8\t\u000f\r}\u0003\u0001\"\u0003\u0003`\"91\u0011\r\u0001\u0005\n\t}\u0007bBB2\u0001\u0011%1Q\r\u0004\u0007\u0007W\u0002Aa!\u001c\t\u000f\u0005%\u0013\r\"\u0001\u0004p!91qA1\u0005B\t}gABB:\u0001\u0011\u0019)\bC\u0004\u0002J\u0011$\taa\u001e\t\u000f\r\u001dA\r\"\u0011\u0003`\u001a111\u0010\u0001\u0005\u0007{Bq!!\u0013h\t\u0003\u0019y\bC\u0004\u0004\b\u001d$\tEa8\u0003-\t\u0013xn[3s\u0019&4WmY=dY\u0016l\u0015M\\1hKJT!\u0001\\7\u0002\rM,'O^3s\u0015\u0005q\u0017!B6bM.\f7\u0001A\n\u0004\u0001E<\bC\u0001:v\u001b\u0005\u0019(\"\u0001;\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001c(AB!osJ+g\r\u0005\u0002yw6\t\u0011P\u0003\u0002{[\u0006)Q\u000f^5mg&\u0011A0\u001f\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOV\tq\u0010\u0005\u0003\u0002\u0002\u0005\rQ\"A6\n\u0007\u0005\u00151NA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0005i&lW-\u0006\u0002\u0002\u000eA!\u0011qBA\u0011\u001b\t\t\tBC\u0002{\u0003'QA!!\u0006\u0002\u0018\u000511m\\7n_:T1A\\A\r\u0015\u0011\tY\"!\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty\"A\u0002pe\u001eLA!a\t\u0002\u0012\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070\u0006\u0002\u0002,A)!/!\f\u00022%\u0019\u0011qF:\u0003\r=\u0003H/[8o!\u0011\t\u0019$!\u0011\u000f\t\u0005U\u0012Q\b\t\u0004\u0003o\u0019XBAA\u001d\u0015\r\tYd\\\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005}2/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\n)E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u007f\u0019\u0018!\u0005;ie\u0016\fGMT1nKB\u0013XMZ5yA\u00051A(\u001b8jiz\"\u0002\"!\u0014\u0002P\u0005E\u00131\u000b\t\u0004\u0003\u0003\u0001\u0001\"B?\b\u0001\u0004y\bbBA\u0005\u000f\u0001\u0007\u0011Q\u0002\u0005\b\u0003O9\u0001\u0019AA\u0016\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u00033\u0002B!a\u0004\u0002\\%!\u0011QLA\t\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%\u0001\u0004o_\u0012,\u0017\nZ\u000b\u0003\u0003K\u00022A]A4\u0013\r\tIg\u001d\u0002\u0004\u0013:$\u0018a\u00028pI\u0016LE\rI\u0001\u0005e\u0006\u001c7.\u0006\u0002\u0002rA)!/!\f\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014\u0001\u00027b]\u001eT!!! \u0002\t)\fg/Y\u0005\u0005\u0003\u0007\n9(A\u0003sC\u000e\\\u0007%\u0001\tj]&$\u0018.\u00197US6,w.\u001e;OgV\u0011\u0011q\u0011\t\u0004e\u0006%\u0015bAAFg\n!Aj\u001c8h\u0003EIg.\u001b;jC2$\u0016.\\3pkRt5\u000fI\u0001\u0019e\u0016\u001cXM\u001c3FqB|g.\u001a8uS\u0006d')Y2l_\u001a4WCAAJ!\u0011\ty!!&\n\t\u0005]\u0015\u0011\u0003\u0002\u0013\u000bb\u0004xN\\3oi&\fGNQ1dW>4g-A\rsKN,g\u000eZ#ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\u0004\u0013A\u00044bS2,G-\u0011;uK6\u0004Ho]\u0001\u0013M\u0006LG.\u001a3BiR,W\u000e\u001d;t?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0006\u001d\u0006c\u0001:\u0002$&\u0019\u0011QU:\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003S\u001b\u0012\u0011!a\u0001\u0003\u000f\u000b1\u0001\u001f\u00132\u0003=1\u0017-\u001b7fI\u0006#H/Z7qiN\u0004\u0013!D5oG\u0006\u0014h.\u0019;j_:LE-\u0006\u0002\u00022B!\u00111WA[\u001b\t\t\u0019\"\u0003\u0003\u00028\u0006M!\u0001B+vS\u0012\fa\"\u001b8dCJt\u0017\r^5p]&#\u0007%\u0001\u000bj]&$\u0018.\u00197DCR\u001c\u0007.\u00169GkR,(/Z\u000b\u0003\u0003\u007f\u0003b!!1\u0002L\u0006=WBAAb\u0015\u0011\t)-a2\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002J\u0006m\u0014\u0001B;uS2LA!!4\u0002D\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u0005U\u0014\u0011[\u0005\u0005\u0003'\f9H\u0001\u0003W_&$\u0017!F5oSRL\u0017\r\\\"bi\u000eDW\u000b\u001d$viV\u0014X\rI\u0001\u0019G>tGO]8mY\u0016$7\u000b[;uI><hNR;ukJ,\u0017!G2p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:4U\u000f^;sK\u0002\nAb\u00182s_.,'/\u00129pG\"\f\u0001c\u00182s_.,'/\u00129pG\"|F%Z9\u0015\t\u0005\u0005\u0016\u0011\u001d\u0005\n\u0003Sc\u0012\u0011!a\u0001\u0003\u000f\u000bQb\u00182s_.,'/\u00129pG\"\u0004\u0003fA\u000f\u0002hB\u0019!/!;\n\u0007\u0005-8O\u0001\u0005w_2\fG/\u001b7f\u0003\u0019y6\u000f^1uKV\u0011\u0011\u0011\u001f\t\u0005\u0003g\fI0\u0004\u0002\u0002v*!\u0011q_A\f\u0003!iW\r^1eCR\f\u0017\u0002BA~\u0003k\u00141B\u0011:pW\u0016\u00148\u000b^1uK\u0006Qql\u001d;bi\u0016|F%Z9\u0015\t\u0005\u0005&\u0011\u0001\u0005\n\u0003S{\u0012\u0011!a\u0001\u0003c\fqaX:uCR,\u0007\u0005K\u0002!\u0003O\fad\u00185jO\",7\u000f^'fi\u0006$\u0017\r^1PM\u001a\u001cX\r\u001e)s_ZLG-\u001a:\u0016\u0005\t-\u0001#\u0002:\u0003\u000e\u0005\u001d\u0015b\u0001B\bg\nIa)\u001e8di&|g\u000eM\u0001#?\"Lw\r[3ti6+G/\u00193bi\u0006|eMZ:fiB\u0013xN^5eKJ|F%Z9\u0015\t\u0005\u0005&Q\u0003\u0005\n\u0003S\u0013\u0013\u0011!a\u0001\u0005\u0017\tqd\u00185jO\",7\u000f^'fi\u0006$\u0017\r^1PM\u001a\u001cX\r\u001e)s_ZLG-\u001a:!\u00039\u0011X-\u00193z)>,fNZ3oG\u0016,\"A!\b\u0011\u0007I\u0014y\"C\u0002\u0003\"M\u0014qAQ8pY\u0016\fg.\u0001\nsK\u0006$\u0017\u0010V8V]\u001a,gnY3`I\u0015\fH\u0003BAQ\u0005OA\u0011\"!+&\u0003\u0003\u0005\rA!\b\u0002\u001fI,\u0017\rZ=U_Vsg-\u001a8dK\u0002\nQdZ8u\u0007>tGO]8mY\u0016$7\u000b[;uI><hNU3ta>t7/Z\u0001\"O>$8i\u001c8ue>dG.\u001a3TQV$Hm\\<o%\u0016\u001c\bo\u001c8tK~#S-\u001d\u000b\u0005\u0003C\u0013\t\u0004C\u0005\u0002*\"\n\t\u00111\u0001\u0003\u001e\u0005qrm\u001c;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t'+Z:q_:\u001cX\rI\u0001\u000be\u0016<\u0017n\u001d;fe\u0016$\u0017A\u0004:fO&\u001cH/\u001a:fI~#S-\u001d\u000b\u0005\u0003C\u0013Y\u0004C\u0005\u0002*.\n\t\u00111\u0001\u0003\u001e\u0005Y!/Z4jgR,'/\u001a3!\u0003qIg.\u001b;jC2\u0014VmZ5tiJ\fG/[8o'V\u001c7-Z3eK\u0012\f\u0001%\u001b8ji&\fGNU3hSN$(/\u0019;j_:\u001cVoY2fK\u0012,Gm\u0018\u0013fcR!\u0011\u0011\u0015B#\u0011%\tIKLA\u0001\u0002\u0004\u0011i\"A\u000fj]&$\u0018.\u00197SK\u001eL7\u000f\u001e:bi&|gnU;dG\u0016,G-\u001a3!\u0003)y6\r\\;ti\u0016\u0014\u0018\nZ\u000b\u0003\u0003c\tabX2mkN$XM]%e?\u0012*\u0017\u000f\u0006\u0003\u0002\"\nE\u0003\"CAUc\u0005\u0005\t\u0019AA\u0019\u0003-y6\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\u0002)}\u000bGM^3si&\u001cX\r\u001a'jgR,g.\u001a:t+\t\u0011I\u0006\u0005\u0003\u0003\\\ted\u0002\u0002B/\u0005grAAa\u0018\u0003p9!!\u0011\rB7\u001d\u0011\u0011\u0019Ga\u001b\u000f\t\t\u0015$\u0011\u000e\b\u0005\u0003o\u00119'\u0003\u0002\u0002 %!\u00111DA\u000f\u0013\rq\u0017\u0011D\u0005\u0005\u0003+\t9\"\u0003\u0003\u0003r\u0005M\u0011aB7fgN\fw-Z\u0005\u0005\u0005k\u00129(A\u000fCe>\\WM\u001d*fO&\u001cHO]1uS>t'+Z9vKN$H)\u0019;b\u0015\u0011\u0011\t(a\u0005\n\t\tm$Q\u0010\u0002\u0013\u0019&\u001cH/\u001a8fe\u000e{G\u000e\\3di&|gN\u0003\u0003\u0003v\t]\u0014\u0001G0bIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u00148o\u0018\u0013fcR!\u0011\u0011\u0015BB\u0011%\tI\u000bNA\u0001\u0002\u0004\u0011I&A\u000b`C\u00124XM\u001d;jg\u0016$G*[:uK:,'o\u001d\u0011\u0002%}\u001bX\u000f\u001d9peR,GMR3biV\u0014Xm]\u000b\u0003\u0005\u0017\u0003\u0002B!$\u0003\u0010\u0006E\"1S\u0007\u0003\u0003\u000fLAA!%\u0002H\n\u0019Q*\u00199\u0011\t\u0005M(QS\u0005\u0005\u0005/\u000b)P\u0001\u0007WKJ\u001c\u0018n\u001c8SC:<W-\u0001\f`gV\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001cx\fJ3r)\u0011\t\tK!(\t\u0013\u0005%v'!AA\u0002\t-\u0015aE0tkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKN\u0004\u0013aD0dQ\u0006tg.\u001a7NC:\fw-\u001a:\u0016\u0005\t\u0015\u0006\u0003BA\u0001\u0005OK1A!+l\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002'}\u001b\u0007.\u00198oK2l\u0015M\\1hKJ|F%Z9\u0015\t\u0005\u0005&q\u0016\u0005\n\u0003SS\u0014\u0011!a\u0001\u0005K\u000b\u0001cX2iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002\u0015\u00154XM\u001c;Rk\u0016,X-\u0006\u0002\u00038B!!\u0011\u0018B`\u001b\t\u0011YL\u0003\u0003\u0003>\u0006]\u0011!B9vKV,\u0017\u0002\u0002Ba\u0005w\u0013qbS1gW\u0006,e/\u001a8u#V,W/Z\u0001\fKZ,g\u000e^)vKV,\u0007%A\u0003ti\u0006\u0014H\u000f\u0006\u0007\u0002\"\n%'Q\u001aBi\u0005+\u0014I\u000eC\u0004\u0003Lz\u0002\rAa\u0003\u0002;!Lw\r[3ti6+G/\u00193bi\u0006|eMZ:fiB\u0013xN^5eKJDqAa4?\u0001\u0004\u0011)+\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\t\u000f\tMg\b1\u0001\u00022\u0005I1\r\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u0005/t\u0004\u0019\u0001B-\u0003M\tGM^3si&\u001cX\r\u001a'jgR,g.\u001a:t\u0011\u001d\u0011YN\u0010a\u0001\u0005\u0017\u000b\u0011c];qa>\u0014H/\u001a3GK\u0006$XO]3t\u0003E\u0019X\r\u001e*fC\u0012LHk\\+oM\u0016t7-\u001a\u000b\u0003\u0003C\u000b1B\u0019:pW\u0016\u0014X\t]8dQR\u0011\u0011qQ\u0001\u0006gR\fG/\u001a\u000b\u0003\u0003c\u0014ADQ3hS:\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8Fm\u0016tGoE\u0003C\u0005[\u0014\u0019\u0010\u0005\u0003\u0002v\t=\u0018\u0002\u0002By\u0003o\u0012aa\u00142kK\u000e$\b\u0003\u0002B{\u0005wtAA!/\u0003x&!!\u0011 B^\u0003))e/\u001a8u#V,W/Z\u0005\u0005\u0005{\u0014yPA\u0003Fm\u0016tGO\u0003\u0003\u0003z\nmFCAB\u0002!\r\u0019)AQ\u0007\u0002\u0001\u0005\u0019!/\u001e8\u0002/\t,w-\u001b8D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0017!\u00042fO&t7\u000b[;uI><h.A\u0003dY>\u001cXM\u0001\fTKR\u0014V-\u00193z)>,fNZ3oG\u0016,e/\u001a8u'\u0015A%Q\u001eBz)\t\u0019)\u0002E\u0002\u0004\u0006!\u0013Ab\u0015;beR,\b/\u0012<f]R\u001cRa\u0013Bw\u0005g$Bb!\b\u0004 \r\u000521EB\u0013\u0007O\u00012a!\u0002L\u0011\u001d\u0011Y-\u0015a\u0001\u0005\u0017AqAa4R\u0001\u0004\u0011)\u000bC\u0004\u0003TF\u0003\r!!\r\t\u000f\t]\u0017\u000b1\u0001\u0003Z!9!1\\)A\u0002\t-\u0015AF:f]\u0012\u0014%o\\6feJ+w-[:ue\u0006$\u0018n\u001c8\u0003C\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c*fgB|gn]3IC:$G.\u001a:\u0014\u0007Q\u001by\u0003\u0005\u0003\u0002\u0002\rE\u0012bAB\u001aW\n\u00113i\u001c8ue>dG.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ$\"aa\u000e\u0011\u0007\r\u0015A+\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016$B!!)\u0004>!91q\b,A\u0002\r\u0005\u0013\u0001\u0003:fgB|gn]3\u0011\t\r\r3\u0011J\u0007\u0003\u0007\u000bRAaa\u0012\u0002\u0018\u000591\r\\5f]R\u001c\u0018\u0002BB&\u0007\u000b\u0012ab\u00117jK:$(+Z:q_:\u001cX-A\u0005p]RKW.Z8vi\u0006\u00192/\u001a8e\u0005J|7.\u001a:IK\u0006\u0014HOY3bi\nq\"I]8lKJDU-\u0019:uE\u0016\fGOU3ta>t7/\u001a%b]\u0012dWM]\n\u00043\u000e=BCAB,!\r\u0019)!\u0017\u000b\u0005\u0003C\u001bY\u0006C\u0004\u0004@m\u0003\ra!\u0011\u0002IM\u001c\u0007.\u001a3vY\u0016tU\r\u001f;D_6lWO\\5dCRLwN\\%n[\u0016$\u0017.\u0019;fYf\fQe]2iK\u0012,H.\u001a(fqR\u001cu.\\7v]&\u001c\u0017\r^5p]\u00063G/\u001a:GC&dWO]3\u0002KM\u001c\u0007.\u001a3vY\u0016tU\r\u001f;D_6lWO\\5dCRLwN\\!gi\u0016\u00148+^2dKN\u001c\u0018!G:dQ\u0016$W\u000f\\3OKb$8i\\7nk:L7-\u0019;j_:$B!!)\u0004h!91\u0011\u000e1A\u0002\u0005\u001d\u0015AC5oi\u0016\u0014h/\u00197Og\nA\"+Z4jgR\u0014\u0018\r^5p]RKW.Z8vi\u00163XM\u001c;\u0014\u000b\u0005\u0014iOa=\u0015\u0005\rE\u0004cAB\u0003C\n\u00112i\\7nk:L7-\u0019;j_:,e/\u001a8u'\u0015!'Q\u001eBz)\t\u0019I\bE\u0002\u0004\u0006\u0011\u0014Qb\u00155vi\u0012|wO\\#wK:$8#B4\u0003n\nMHCABA!\r\u0019)a\u001a")
public class BrokerLifecycleManager
implements Logging {
    private final KafkaConfig config;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final LogContext logContext;
    private final int kafka$server$BrokerLifecycleManager$$nodeId;
    private final Option<String> rack;
    private final long kafka$server$BrokerLifecycleManager$$initialTimeoutNs;
    private final ExponentialBackoff resendExponentialBackoff;
    private long kafka$server$BrokerLifecycleManager$$failedAttempts;
    private final Uuid incarnationId;
    private final CompletableFuture<Void> initialCatchUpFuture;
    private final CompletableFuture<Void> controlledShutdownFuture;
    private volatile long kafka$server$BrokerLifecycleManager$$_brokerEpoch;
    private volatile BrokerState kafka$server$BrokerLifecycleManager$$_state;
    private Function0<Object> kafka$server$BrokerLifecycleManager$$_highestMetadataOffsetProvider;
    private boolean kafka$server$BrokerLifecycleManager$$readyToUnfence;
    private boolean kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse;
    private boolean kafka$server$BrokerLifecycleManager$$registered;
    private boolean kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded;
    private String kafka$server$BrokerLifecycleManager$$_clusterId;
    private BrokerRegistrationRequestData.ListenerCollection kafka$server$BrokerLifecycleManager$$_advertisedListeners;
    private Map<String, VersionRange> kafka$server$BrokerLifecycleManager$$_supportedFeatures;
    private BrokerToControllerChannelManager _channelManager;
    private final KafkaEventQueue eventQueue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Time time() {
        return this.time;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public LogContext logContext() {
        return this.logContext;
    }

    public int kafka$server$BrokerLifecycleManager$$nodeId() {
        return this.kafka$server$BrokerLifecycleManager$$nodeId;
    }

    private Option<String> rack() {
        return this.rack;
    }

    public long kafka$server$BrokerLifecycleManager$$initialTimeoutNs() {
        return this.kafka$server$BrokerLifecycleManager$$initialTimeoutNs;
    }

    private ExponentialBackoff resendExponentialBackoff() {
        return this.resendExponentialBackoff;
    }

    private long kafka$server$BrokerLifecycleManager$$failedAttempts() {
        return this.kafka$server$BrokerLifecycleManager$$failedAttempts;
    }

    public void kafka$server$BrokerLifecycleManager$$failedAttempts_$eq(long x$1) {
        this.kafka$server$BrokerLifecycleManager$$failedAttempts = x$1;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public CompletableFuture<Void> initialCatchUpFuture() {
        return this.initialCatchUpFuture;
    }

    public CompletableFuture<Void> controlledShutdownFuture() {
        return this.controlledShutdownFuture;
    }

    public long kafka$server$BrokerLifecycleManager$$_brokerEpoch() {
        return this.kafka$server$BrokerLifecycleManager$$_brokerEpoch;
    }

    public void kafka$server$BrokerLifecycleManager$$_brokerEpoch_$eq(long x$1) {
        this.kafka$server$BrokerLifecycleManager$$_brokerEpoch = x$1;
    }

    public BrokerState kafka$server$BrokerLifecycleManager$$_state() {
        return this.kafka$server$BrokerLifecycleManager$$_state;
    }

    public void kafka$server$BrokerLifecycleManager$$_state_$eq(BrokerState x$1) {
        this.kafka$server$BrokerLifecycleManager$$_state = x$1;
    }

    private Function0<Object> kafka$server$BrokerLifecycleManager$$_highestMetadataOffsetProvider() {
        return this.kafka$server$BrokerLifecycleManager$$_highestMetadataOffsetProvider;
    }

    public void kafka$server$BrokerLifecycleManager$$_highestMetadataOffsetProvider_$eq(Function0<Object> x$1) {
        this.kafka$server$BrokerLifecycleManager$$_highestMetadataOffsetProvider = x$1;
    }

    private boolean kafka$server$BrokerLifecycleManager$$readyToUnfence() {
        return this.kafka$server$BrokerLifecycleManager$$readyToUnfence;
    }

    public void kafka$server$BrokerLifecycleManager$$readyToUnfence_$eq(boolean x$1) {
        this.kafka$server$BrokerLifecycleManager$$readyToUnfence = x$1;
    }

    public boolean kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse() {
        return this.kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse;
    }

    public void kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse_$eq(boolean x$1) {
        this.kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse = x$1;
    }

    public boolean kafka$server$BrokerLifecycleManager$$registered() {
        return this.kafka$server$BrokerLifecycleManager$$registered;
    }

    public void kafka$server$BrokerLifecycleManager$$registered_$eq(boolean x$1) {
        this.kafka$server$BrokerLifecycleManager$$registered = x$1;
    }

    public boolean kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded() {
        return this.kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded;
    }

    public void kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded_$eq(boolean x$1) {
        this.kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded = x$1;
    }

    private String kafka$server$BrokerLifecycleManager$$_clusterId() {
        return this.kafka$server$BrokerLifecycleManager$$_clusterId;
    }

    public void kafka$server$BrokerLifecycleManager$$_clusterId_$eq(String x$1) {
        this.kafka$server$BrokerLifecycleManager$$_clusterId = x$1;
    }

    private BrokerRegistrationRequestData.ListenerCollection kafka$server$BrokerLifecycleManager$$_advertisedListeners() {
        return this.kafka$server$BrokerLifecycleManager$$_advertisedListeners;
    }

    public void kafka$server$BrokerLifecycleManager$$_advertisedListeners_$eq(BrokerRegistrationRequestData.ListenerCollection x$1) {
        this.kafka$server$BrokerLifecycleManager$$_advertisedListeners = x$1;
    }

    private Map<String, VersionRange> kafka$server$BrokerLifecycleManager$$_supportedFeatures() {
        return this.kafka$server$BrokerLifecycleManager$$_supportedFeatures;
    }

    public void kafka$server$BrokerLifecycleManager$$_supportedFeatures_$eq(Map<String, VersionRange> x$1) {
        this.kafka$server$BrokerLifecycleManager$$_supportedFeatures = x$1;
    }

    public BrokerToControllerChannelManager _channelManager() {
        return this._channelManager;
    }

    public void _channelManager_$eq(BrokerToControllerChannelManager x$1) {
        this._channelManager = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    public void start(Function0<Object> highestMetadataOffsetProvider, BrokerToControllerChannelManager channelManager, String clusterId, BrokerRegistrationRequestData.ListenerCollection advertisedListeners, Map<String, VersionRange> supportedFeatures) {
        this.eventQueue().append(new StartupEvent(this, highestMetadataOffsetProvider, channelManager, clusterId, advertisedListeners, supportedFeatures));
    }

    public void setReadyToUnfence() {
        this.eventQueue().append(new SetReadyToUnfenceEvent());
    }

    public long brokerEpoch() {
        return this.kafka$server$BrokerLifecycleManager$$_brokerEpoch();
    }

    public BrokerState state() {
        return this.kafka$server$BrokerLifecycleManager$$_state();
    }

    public void beginControlledShutdown() {
        this.eventQueue().append(new BeginControlledShutdownEvent());
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown", new ShutdownEvent());
    }

    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    public void kafka$server$BrokerLifecycleManager$$sendBrokerRegistration() {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.kafka$server$BrokerLifecycleManager$$_supportedFeatures()).asScala()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(BrokerLifecycleManager.$anonfun$sendBrokerRegistration$1(features, x0$1)));
        BrokerRegistrationRequestData data = new BrokerRegistrationRequestData().setBrokerId(this.kafka$server$BrokerLifecycleManager$$nodeId()).setClusterId(this.kafka$server$BrokerLifecycleManager$$_clusterId()).setFeatures(features).setIncarnationId(this.incarnationId()).setListeners(this.kafka$server$BrokerLifecycleManager$$_advertisedListeners()).setRack((String)this.rack().orNull(Predef$.MODULE$.$conforms()));
        if (this.isTraceEnabled()) {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Sending broker registration ").append(data).toString());
        }
        this._channelManager().sendRequest(new BrokerRegistrationRequest.Builder(data), new BrokerRegistrationResponseHandler());
    }

    public void kafka$server$BrokerLifecycleManager$$sendBrokerHeartbeat() {
        long metadataOffset = this.kafka$server$BrokerLifecycleManager$$_highestMetadataOffsetProvider().apply$mcJ$sp();
        BrokerState brokerState = this.kafka$server$BrokerLifecycleManager$$_state();
        BrokerState brokerState2 = BrokerState.PENDING_CONTROLLED_SHUTDOWN;
        BrokerHeartbeatRequestData data = new BrokerHeartbeatRequestData().setBrokerEpoch(this.kafka$server$BrokerLifecycleManager$$_brokerEpoch()).setBrokerId(this.kafka$server$BrokerLifecycleManager$$nodeId()).setCurrentMetadataOffset(metadataOffset).setWantFence(!this.kafka$server$BrokerLifecycleManager$$readyToUnfence()).setWantShutDown(!(brokerState != null ? !((Object)((Object)brokerState)).equals((Object)brokerState2) : brokerState2 != null));
        if (this.isTraceEnabled()) {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Sending broker heartbeat ").append(data).toString());
        }
        this._channelManager().sendRequest(new BrokerHeartbeatRequest.Builder(data), new BrokerHeartbeatResponseHandler());
    }

    public void kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationImmediately() {
        this.kafka$server$BrokerLifecycleManager$$scheduleNextCommunication(0L);
    }

    public void kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure() {
        long delayMs = this.resendExponentialBackoff().backoff(this.kafka$server$BrokerLifecycleManager$$failedAttempts());
        this.kafka$server$BrokerLifecycleManager$$failedAttempts_$eq(this.kafka$server$BrokerLifecycleManager$$failedAttempts() + 1L);
        this.kafka$server$BrokerLifecycleManager$$scheduleNextCommunication(TimeUnit.NANOSECONDS.convert(delayMs, TimeUnit.MILLISECONDS));
    }

    public void kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterSuccess() {
        this.kafka$server$BrokerLifecycleManager$$scheduleNextCommunication(TimeUnit.NANOSECONDS.convert(this.config().brokerHeartbeatIntervalMs(), TimeUnit.MILLISECONDS));
    }

    public void kafka$server$BrokerLifecycleManager$$scheduleNextCommunication(long intervalNs) {
        this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Scheduling next communication at ").append(TimeUnit.MILLISECONDS.convert(intervalNs, TimeUnit.NANOSECONDS)).append(" ").append("ms from now.").toString());
        long deadlineNs = this.time().nanoseconds() + intervalNs;
        this.eventQueue().scheduleDeferred("communication", new EventQueue.DeadlineFunction(deadlineNs), new CommunicationEvent());
    }

    public static final /* synthetic */ boolean $anonfun$sendBrokerRegistration$1(BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        String name = (String)x0$1._1();
        VersionRange range = (VersionRange)x0$1._2();
        boolean bl = features$1.add(new BrokerRegistrationRequestData.Feature().setName(name).setMinSupportedVersion(range.min()).setMaxSupportedVersion(range.max()));
        return bl;
    }

    public BrokerLifecycleManager(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        this.config = config;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(29).append("[BrokerLifecycleManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.kafka$server$BrokerLifecycleManager$$nodeId = config.nodeId();
        this.rack = config.rack();
        this.kafka$server$BrokerLifecycleManager$$initialTimeoutNs = TimeUnit.MILLISECONDS.toNanos(config.initialRegistrationTimeoutMs());
        this.resendExponentialBackoff = new ExponentialBackoff(100L, 2, config.brokerSessionTimeoutMs(), 0.02);
        this.kafka$server$BrokerLifecycleManager$$failedAttempts = 0L;
        this.incarnationId = Uuid.randomUuid();
        this.initialCatchUpFuture = new CompletableFuture();
        this.controlledShutdownFuture = new CompletableFuture();
        this.kafka$server$BrokerLifecycleManager$$_brokerEpoch = -1L;
        this.kafka$server$BrokerLifecycleManager$$_state = BrokerState.NOT_RUNNING;
        this.kafka$server$BrokerLifecycleManager$$readyToUnfence = false;
        this.kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse = false;
        this.kafka$server$BrokerLifecycleManager$$registered = false;
        this.kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded = false;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), (String)threadNamePrefix.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""));
    }

    private class BeginControlledShutdownEvent
    implements EventQueue.Event {
        @Override
        public void handleException(Throwable x$1) {
            EventQueue.Event.super.handleException(x$1);
        }

        @Override
        public void run() {
            BrokerState brokerState = this.kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer().kafka$server$BrokerLifecycleManager$$_state();
            if (((Object)((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN)).equals((Object)brokerState)) {
                this.kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "Attempted to enter pending controlled shutdown state, but we are already in that state.");
                return;
            }
            if (((Object)((Object)BrokerState.RUNNING)).equals((Object)brokerState)) {
                this.kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "Beginning controlled shutdown.");
                this.kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer().kafka$server$BrokerLifecycleManager$$_state_$eq(BrokerState.PENDING_CONTROLLED_SHUTDOWN);
                return;
            }
            this.kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Skipping controlled shutdown because we are in state ").append((Object)this.kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer().kafka$server$BrokerLifecycleManager$$_state()).append(".").toString());
            this.kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer().beginShutdown();
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$BeginControlledShutdownEvent$$$outer() {
            return BrokerLifecycleManager.this;
        }

        public BeginControlledShutdownEvent() {
            if (BrokerLifecycleManager.this == null) {
                throw null;
            }
        }
    }

    private class BrokerHeartbeatResponseHandler
    extends ControllerRequestCompletionHandler {
        @Override
        public void onComplete(ClientResponse response) {
            Errors errorCode;
            if (response.authenticationException() != null) {
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Unable to send broker heartbeat for ").append(this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" because of an ").append("authentication exception.").toString(), (Function0<Throwable>)(Function0<AuthenticationException> & Serializable & scala.Serializable)() -> response.authenticationException());
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.versionMismatch() != null) {
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Unable to send broker heartbeat for ").append(this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" because of an API ").append("version problem.").toString(), (Function0<Throwable>)(Function0<UnsupportedVersionException> & Serializable & scala.Serializable)() -> response.versionMismatch());
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.responseBody() == null) {
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Unable to send broker heartbeat for ").append(this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(". Retrying.").toString());
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (!(response.responseBody() instanceof BrokerHeartbeatResponse)) {
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Unable to send broker heartbeat for ").append(this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" because the controller ").append("returned an invalid response type.").toString());
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            BrokerHeartbeatResponse message = (BrokerHeartbeatResponse)response.responseBody();
            Errors errors = errorCode = Errors.forCode(message.data().errorCode());
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$failedAttempts_$eq(0L);
                BrokerState brokerState = this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$_state();
                if (((Object)((Object)BrokerState.STARTING)).equals((Object)brokerState)) {
                    if (message.data().isCaughtUp()) {
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "The broker has caught up. Transitioning from STARTING to RECOVERY.");
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$_state_$eq(BrokerState.RECOVERY);
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().initialCatchUpFuture().complete(null);
                    } else {
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().debug((Function0<String> & Serializable & scala.Serializable)() -> "The broker is STARTING. Still waiting to catch up with cluster metadata.");
                    }
                    this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunication(TimeUnit.NANOSECONDS.convert(10L, TimeUnit.MILLISECONDS));
                    return;
                }
                if (((Object)((Object)BrokerState.RECOVERY)).equals((Object)brokerState)) {
                    if (!message.data().isFenced()) {
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "The broker has been unfenced. Transitioning from RECOVERY to RUNNING.");
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$_state_$eq(BrokerState.RUNNING);
                    } else {
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "The broker is in RECOVERY.");
                    }
                    this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterSuccess();
                    return;
                }
                if (((Object)((Object)BrokerState.RUNNING)).equals((Object)brokerState)) {
                    this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().debug((Function0<String> & Serializable & scala.Serializable)() -> "The broker is RUNNING. Processing heartbeat response.");
                    this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterSuccess();
                    return;
                }
                if (((Object)((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN)).equals((Object)brokerState)) {
                    if (!message.data().shouldShutDown()) {
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(92).append("The broker is in PENDING_CONTROLLED_SHUTDOWN state, still waiting ").append("for the active controller.").toString());
                        if (!this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse()) {
                            this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunication(TimeUnit.NANOSECONDS.convert(50L, TimeUnit.MILLISECONDS));
                        } else {
                            this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterSuccess();
                        }
                    } else {
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "The controlled has asked us to exit controlled shutdown.");
                        this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().beginShutdown();
                    }
                    this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$gotControlledShutdownResponse_$eq(true);
                    return;
                }
                if (((Object)((Object)BrokerState.SHUTTING_DOWN)).equals((Object)brokerState)) {
                    this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "The broker is SHUTTING_DOWN. Ignoring heartbeat response.");
                    return;
                }
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Unexpected broker state ").append((Object)this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$_state()).toString());
                this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterSuccess();
                return;
            }
            this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Broker ").append(this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" sent a heartbeat request but received error ").append((Object)errorCode).append(".").toString());
            this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
        }

        @Override
        public void onTimeout() {
            this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "Unable to send a heartbeat because the RPC got timed out before it could be sent.");
            this.kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$BrokerHeartbeatResponseHandler$$$outer() {
            return BrokerLifecycleManager.this;
        }

        public BrokerHeartbeatResponseHandler() {
            if (BrokerLifecycleManager.this == null) {
                throw null;
            }
        }
    }

    private class BrokerRegistrationResponseHandler
    extends ControllerRequestCompletionHandler {
        @Override
        public void onComplete(ClientResponse response) {
            Errors errorCode;
            if (response.authenticationException() != null) {
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Unable to register broker ").append(this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" because of an authentication exception.").toString(), (Function0<Throwable>)(Function0<AuthenticationException> & Serializable & scala.Serializable)() -> response.authenticationException());
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.versionMismatch() != null) {
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Unable to register broker ").append(this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" because of an API version problem.").toString(), (Function0<Throwable>)(Function0<UnsupportedVersionException> & Serializable & scala.Serializable)() -> response.versionMismatch());
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.responseBody() == null) {
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().warn((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Unable to register broker ").append(this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(".").toString());
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (!(response.responseBody() instanceof BrokerRegistrationResponse)) {
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Unable to register broker ").append(this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" because the controller returned an ").append("invalid response type.").toString());
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            BrokerRegistrationResponse message = (BrokerRegistrationResponse)response.responseBody();
            Errors errors = errorCode = Errors.forCode(message.data().errorCode());
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$failedAttempts_$eq(0L);
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$_brokerEpoch_$eq(message.data().brokerEpoch());
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$registered_$eq(true);
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded_$eq(true);
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Successfully registered broker ").append(this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" with broker epoch ").append(this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$_brokerEpoch()).toString());
                this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationImmediately();
                return;
            }
            this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Unable to register broker ").append(this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" because the controller returned ").append("error ").append((Object)errorCode).toString());
            this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
        }

        @Override
        public void onTimeout() {
            this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> "Unable to register the broker because the RPC got timed out before it could be sent.");
            this.kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationAfterFailure();
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$BrokerRegistrationResponseHandler$$$outer() {
            return BrokerLifecycleManager.this;
        }

        public BrokerRegistrationResponseHandler() {
            if (BrokerLifecycleManager.this == null) {
                throw null;
            }
        }
    }

    private class CommunicationEvent
    implements EventQueue.Event {
        @Override
        public void handleException(Throwable x$1) {
            EventQueue.Event.super.handleException(x$1);
        }

        @Override
        public void run() {
            if (this.kafka$server$BrokerLifecycleManager$CommunicationEvent$$$outer().kafka$server$BrokerLifecycleManager$$registered()) {
                this.kafka$server$BrokerLifecycleManager$CommunicationEvent$$$outer().kafka$server$BrokerLifecycleManager$$sendBrokerHeartbeat();
                return;
            }
            this.kafka$server$BrokerLifecycleManager$CommunicationEvent$$$outer().kafka$server$BrokerLifecycleManager$$sendBrokerRegistration();
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$CommunicationEvent$$$outer() {
            return BrokerLifecycleManager.this;
        }

        public CommunicationEvent() {
            if (BrokerLifecycleManager.this == null) {
                throw null;
            }
        }
    }

    private class RegistrationTimeoutEvent
    implements EventQueue.Event {
        @Override
        public void handleException(Throwable x$1) {
            EventQueue.Event.super.handleException(x$1);
        }

        @Override
        public void run() {
            if (!this.kafka$server$BrokerLifecycleManager$RegistrationTimeoutEvent$$$outer().kafka$server$BrokerLifecycleManager$$initialRegistrationSucceeded()) {
                this.kafka$server$BrokerLifecycleManager$RegistrationTimeoutEvent$$$outer().error((Function0<String> & Serializable & scala.Serializable)() -> "Shutting down because we were unable to register with the controller quorum.");
                this.kafka$server$BrokerLifecycleManager$RegistrationTimeoutEvent$$$outer().eventQueue().beginShutdown("registrationTimeout", this.kafka$server$BrokerLifecycleManager$RegistrationTimeoutEvent$$$outer().new ShutdownEvent());
            }
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$RegistrationTimeoutEvent$$$outer() {
            return BrokerLifecycleManager.this;
        }

        public RegistrationTimeoutEvent() {
            if (BrokerLifecycleManager.this == null) {
                throw null;
            }
        }
    }

    private class SetReadyToUnfenceEvent
    implements EventQueue.Event {
        @Override
        public void handleException(Throwable x$1) {
            EventQueue.Event.super.handleException(x$1);
        }

        @Override
        public void run() {
            this.kafka$server$BrokerLifecycleManager$SetReadyToUnfenceEvent$$$outer().kafka$server$BrokerLifecycleManager$$readyToUnfence_$eq(true);
            this.kafka$server$BrokerLifecycleManager$SetReadyToUnfenceEvent$$$outer().kafka$server$BrokerLifecycleManager$$scheduleNextCommunicationImmediately();
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$SetReadyToUnfenceEvent$$$outer() {
            return BrokerLifecycleManager.this;
        }

        public SetReadyToUnfenceEvent() {
            if (BrokerLifecycleManager.this == null) {
                throw null;
            }
        }
    }

    private class ShutdownEvent
    implements EventQueue.Event {
        @Override
        public void handleException(Throwable x$1) {
            EventQueue.Event.super.handleException(x$1);
        }

        @Override
        public void run() {
            this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Transitioning from ").append((Object)this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer().kafka$server$BrokerLifecycleManager$$_state()).append(" to ").append((Object)BrokerState.SHUTTING_DOWN).append(".").toString());
            this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer().kafka$server$BrokerLifecycleManager$$_state_$eq(BrokerState.SHUTTING_DOWN);
            this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer().controlledShutdownFuture().complete(null);
            this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer().initialCatchUpFuture().cancel(false);
            if (this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer()._channelManager() != null) {
                this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer()._channelManager().shutdown();
                this.kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer()._channelManager_$eq(null);
            }
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$ShutdownEvent$$$outer() {
            return BrokerLifecycleManager.this;
        }

        public ShutdownEvent() {
            if (BrokerLifecycleManager.this == null) {
                throw null;
            }
        }
    }

    private class StartupEvent
    implements EventQueue.Event {
        private final Function0<Object> highestMetadataOffsetProvider;
        private final BrokerToControllerChannelManager channelManager;
        private final String clusterId;
        private final BrokerRegistrationRequestData.ListenerCollection advertisedListeners;
        private final Map<String, VersionRange> supportedFeatures;
        public final /* synthetic */ BrokerLifecycleManager $outer;

        @Override
        public void handleException(Throwable x$1) {
            EventQueue.Event.super.handleException(x$1);
        }

        @Override
        public void run() {
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$_highestMetadataOffsetProvider_$eq(this.highestMetadataOffsetProvider);
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer()._channelManager_$eq(this.channelManager);
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer()._channelManager().start();
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$_state_$eq(BrokerState.STARTING);
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$_clusterId_$eq(this.clusterId);
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$_advertisedListeners_$eq(this.advertisedListeners.duplicate());
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$_supportedFeatures_$eq(new HashMap<String, VersionRange>(this.supportedFeatures));
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().eventQueue().scheduleDeferred("initialRegistrationTimeout", new EventQueue.DeadlineFunction(this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().time().nanoseconds() + this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$initialTimeoutNs()), this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().new RegistrationTimeoutEvent());
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$sendBrokerRegistration();
            this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().info((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Incarnation ").append(this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().incarnationId()).append(" of broker ").append(this.kafka$server$BrokerLifecycleManager$StartupEvent$$$outer().kafka$server$BrokerLifecycleManager$$nodeId()).append(" in cluster ").append($this.clusterId).append(" ").append("is now STARTING.").toString());
        }

        public /* synthetic */ BrokerLifecycleManager kafka$server$BrokerLifecycleManager$StartupEvent$$$outer() {
            return this.$outer;
        }

        public StartupEvent(BrokerLifecycleManager $outer, Function0<Object> highestMetadataOffsetProvider, BrokerToControllerChannelManager channelManager, String clusterId, BrokerRegistrationRequestData.ListenerCollection advertisedListeners, Map<String, VersionRange> supportedFeatures) {
            this.highestMetadataOffsetProvider = highestMetadataOffsetProvider;
            this.channelManager = channelManager;
            this.clusterId = clusterId;
            this.advertisedListeners = advertisedListeners;
            this.supportedFeatures = supportedFeatures;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

