/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.IntNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.TextNode;

public class PartitionRecordJsonConverter {
    public static PartitionRecord read(JsonNode _node, short _version) {
        PartitionRecord _object = new PartitionRecord();
        JsonNode _partitionIdNode = _node.get("partitionId");
        if (_partitionIdNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'partitionId', which is mandatory in version " + _version);
        }
        _object.partitionId = MessageUtil.jsonNodeToInt(_partitionIdNode, "PartitionRecord");
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("PartitionRecord expected a JSON string type, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.topicId = Uuid.fromString(_topicIdNode.asText());
        JsonNode _replicasNode = _node.get("replicas");
        if (_replicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'replicas', which is mandatory in version " + _version);
        }
        if (!_replicasNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<Integer> _collection = new ArrayList<Integer>(_replicasNode.size());
        _object.replicas = _collection;
        for (Object _element : _replicasNode) {
            _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, "PartitionRecord element"));
        }
        JsonNode _isrNode = _node.get("isr");
        if (_isrNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'isr', which is mandatory in version " + _version);
        }
        if (!_isrNode.isArray()) {
            throw new RuntimeException("PartitionRecord expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<Integer> _collection2 = new ArrayList<Integer>(_isrNode.size());
        _object.isr = _collection2;
        for (Object _element : _isrNode) {
            _collection2.add(MessageUtil.jsonNodeToInt((JsonNode)_element, "PartitionRecord element"));
        }
        JsonNode _removingReplicasNode = _node.get("removingReplicas");
        if (_removingReplicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'removingReplicas', which is mandatory in version " + _version);
        }
        if (_removingReplicasNode.isNull()) {
            _object.removingReplicas = null;
        } else {
            if (!_removingReplicasNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            ArrayList<Integer> _collection3 = new ArrayList<Integer>(_removingReplicasNode.size());
            _object.removingReplicas = _collection3;
            for (Object _element : _removingReplicasNode) {
                _collection3.add(MessageUtil.jsonNodeToInt((JsonNode)_element, "PartitionRecord element"));
            }
        }
        JsonNode _addingReplicasNode = _node.get("addingReplicas");
        if (_addingReplicasNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'addingReplicas', which is mandatory in version " + _version);
        }
        if (_addingReplicasNode.isNull()) {
            _object.addingReplicas = null;
        } else {
            if (!_addingReplicasNode.isArray()) {
                throw new RuntimeException("PartitionRecord expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            ArrayList<Integer> _collection4 = new ArrayList<Integer>(_addingReplicasNode.size());
            _object.addingReplicas = _collection4;
            for (JsonNode _element : _addingReplicasNode) {
                _collection4.add(MessageUtil.jsonNodeToInt(_element, "PartitionRecord element"));
            }
        }
        JsonNode _leaderNode = _node.get("leader");
        if (_leaderNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'leader', which is mandatory in version " + _version);
        }
        _object.leader = MessageUtil.jsonNodeToInt(_leaderNode, "PartitionRecord");
        JsonNode _leaderEpochNode = _node.get("leaderEpoch");
        if (_leaderEpochNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
        }
        _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "PartitionRecord");
        JsonNode _partitionEpochNode = _node.get("partitionEpoch");
        if (_partitionEpochNode == null) {
            throw new RuntimeException("PartitionRecord: unable to locate field 'partitionEpoch', which is mandatory in version " + _version);
        }
        _object.partitionEpoch = MessageUtil.jsonNodeToInt(_partitionEpochNode, "PartitionRecord");
        return _object;
    }

    public static JsonNode write(PartitionRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("partitionId", new IntNode(_object.partitionId));
        _node.set("topicId", new TextNode(_object.topicId.toString()));
        ArrayNode _replicasArray = new ArrayNode(JsonNodeFactory.instance);
        for (Integer n : _object.replicas) {
            _replicasArray.add(new IntNode(n));
        }
        _node.set("replicas", _replicasArray);
        ArrayNode _isrArray = new ArrayNode(JsonNodeFactory.instance);
        for (Integer _element : _object.isr) {
            _isrArray.add(new IntNode(_element));
        }
        _node.set("isr", _isrArray);
        if (_object.removingReplicas == null) {
            _node.set("removingReplicas", NullNode.instance);
        } else {
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.removingReplicas) {
                arrayNode.add(new IntNode(_element));
            }
            _node.set("removingReplicas", arrayNode);
        }
        if (_object.addingReplicas == null) {
            _node.set("addingReplicas", NullNode.instance);
        } else {
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.addingReplicas) {
                arrayNode.add(new IntNode(_element));
            }
            _node.set("addingReplicas", arrayNode);
        }
        _node.set("leader", new IntNode(_object.leader));
        _node.set("leaderEpoch", new IntNode(_object.leaderEpoch));
        _node.set("partitionEpoch", new IntNode(_object.partitionEpoch));
        return _node;
    }

    public static JsonNode write(PartitionRecord _object, short _version) {
        return PartitionRecordJsonConverter.write(_object, _version, true);
    }
}

