/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template.impl;

import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.impl.Modifier;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VarSpec
implements Serializable {
    private static final long serialVersionUID = 5850478145190940514L;
    private static final Pattern VARNAME_REGEX = Pattern.compile("([\\w\\_\\.]|%[A-Fa-f0-9]{2})+");
    private static final String BASE_PATTERN = "([\\w.~\\-\\_]|%[A-Fa-f0-9]{2})";
    private Modifier modifier = Modifier.NONE;
    private String value;
    private Integer position = 0;
    private String variableName;
    private String regexMatchString;

    public VarSpec(String value, Modifier modifier) {
        this(value, modifier, -1);
    }

    public VarSpec(String value, Modifier modifier, Integer position) {
        this.modifier = modifier;
        this.value = value;
        if (position != null) {
            this.position = position;
        }
        this.initVariableName();
        this.initRegExMatchString();
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    private void initRegExMatchString() {
        StringBuilder b = new StringBuilder(BASE_PATTERN);
        if (this.modifier == Modifier.PREFIX) {
            b.append("{").append(this.getPosition()).append("}");
        } else {
            b.append("+");
        }
        this.regexMatchString = b.toString();
    }

    public String getRegExMatchString() {
        if (this.regexMatchString == null) {
            this.initRegExMatchString();
        }
        return this.regexMatchString;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getPosition() {
        return this.position;
    }

    private void initVariableName() {
        Matcher matcher;
        this.variableName = this.getValue();
        if (this.modifier != Modifier.NONE) {
            if (this.modifier == Modifier.PREFIX) {
                String[] values2 = this.getValue().split(Modifier.PREFIX.getValue());
                this.variableName = values2[0];
            }
            if (this.modifier == Modifier.EXPLODE && this.getValue().lastIndexOf(42) != -1) {
                this.variableName = this.getValue().substring(0, this.getValue().length() - 1);
            }
        } else if (this.variableName.lastIndexOf(42) != -1) {
            this.variableName = this.getValue().substring(0, this.getValue().length() - 1);
            this.modifier = Modifier.EXPLODE;
        }
        if (!(matcher = VARNAME_REGEX.matcher(this.variableName)).matches()) {
            throw new MalformedUriTemplateException("The variable name " + this.variableName + " contains invalid characters", this.position);
        }
        if (this.variableName.contains(" ")) {
            throw new MalformedUriTemplateException("The variable name " + this.variableName + " cannot contain spaces (leading or trailing)", this.position);
        }
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return this.getValue();
        }
        return this.variableName;
    }

    public String toString() {
        return "VarSpec [modifier=" + (Object)((Object)this.modifier) + ", value=" + this.value + ", position=" + this.position + ", variableName=" + this.variableName + "]";
    }

    public static enum VarFormat {
        SINGLE,
        ARRAY,
        PAIRS;

    }
}

