/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0012\u0010\u0013\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0011*\u00020\u000bH\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0011*\u00020\u000bH\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"getResourceRoot", "", "context", "Ljava/lang/Class;", "path", "JAR_PROTOCOL", "FILE_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "Ljava/io/File;", "aClass", "getResourcePathForClass", "tryGetResourcePathForClassByName", "name", "classLoader", "Ljava/lang/ClassLoader;", "toFileOrNull", "toContainingJarOrNull", "kotlin-scripting-jvm"})
@SourceDebugExtension(value={"SMAP\npathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pathUtil.kt\nkotlin/script/experimental/jvm/impl/PathUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class PathUtilKt {
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(path, "path");
        URL url = context.getResource(path);
        if (url == null) {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            url = ClassLoader.getSystemResource(string);
        }
        URL uRL = url;
        return uRL != null ? PathUtilKt.extractRoot(uRL, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, '/', false, 2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, '\\', false, 2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual(protocol, FILE_PROTOCOL)) {
            File file = PathUtilKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull(file);
            String path = file.getPath();
            Intrinsics.checkNotNull(path);
            String testPath = StringsKt.replace$default(path, '\\', '/', false, 4, null);
            String testResourcePath = StringsKt.replace$default(resourcePath, '\\', '/', false, 4, null);
            if (StringsKt.endsWith(testPath, testResourcePath, true)) {
                String string2 = path.substring(0, path.length() - resourcePath.length());
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                resultPath = string2;
            }
        } else if (Intrinsics.areEqual(protocol, JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string3 = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue(string3, "getFile(...)");
            Pair<String, String> pair = paths = PathUtilKt.splitJarUrl(string3);
            if ((pair != null ? pair.getFirst() : null) != null) {
                resultPath = new File(paths.getFirst()).getCanonicalPath();
            }
        }
        String string4 = resultPath;
        if (string4 != null) {
            char[] cArray = new char[]{File.separatorChar};
            string = StringsKt.trimEnd(string4, cArray);
        } else {
            string = null;
        }
        return string;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block6: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, JAR_SEPARATOR, 0, false, 6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                return null;
            }
            int pivot = n2;
            String string = url.substring(pivot + 2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            resourcePath = string;
            String string2 = url.substring(0, pivot);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            jarPath = string2;
            if (StringsKt.startsWith$default(jarPath, "jar:", false, 2, null)) {
                String string3 = jarPath.substring(4);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                jarPath = string3;
            }
            if (StringsKt.startsWith$default(jarPath, FILE_PROTOCOL, false, 2, null)) {
                try {
                    File file = PathUtilKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull(file);
                    String string4 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue(string4, "getPath(...)");
                    jarPath = StringsKt.replace$default(string4, '\\', '/', false, 4, null);
                }
                catch (Exception e) {
                    String string5 = jarPath.substring(4);
                    Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                    jarPath = string5;
                    if (StringsKt.startsWith$default(jarPath, SCHEME_SEPARATOR, false, 2, null)) {
                        String string6 = jarPath.substring(3);
                        Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                        jarPath = string6;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, ':', false, 2, null)) break block6;
                    String string7 = jarPath.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
                    jarPath = string7;
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file;
        Intrinsics.checkNotNullParameter(aClass, "aClass");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = aClass.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String path = stringBuilder.append(StringsKt.replace$default(string, '.', '/', false, 4, null)).append(".class").toString();
        String string2 = PathUtilKt.getResourceRoot(aClass, path);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            file = new File(it).getAbsoluteFile();
        } else {
            file = null;
        }
        return file;
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, "aClass");
        File file = PathUtilKt.tryGetResourcePathForClass(aClass);
        if (file == null) {
            throw new IllegalStateException("Resource for class: " + aClass.getName() + " not found");
        }
        return file;
    }

    @Nullable
    public static final File tryGetResourcePathForClassByName(@NotNull String name, @NotNull ClassLoader classLoader) {
        File file;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        try {
            File file2;
            Class<?> clazz = classLoader.loadClass(name);
            if (clazz != null) {
                Class<?> p0 = clazz;
                boolean bl = false;
                file2 = PathUtilKt.tryGetResourcePathForClass(p0);
            } else {
                file2 = null;
            }
            file = file2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            file = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            file = null;
        }
        return file;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter($this$toFileOrNull, "<this>");
        try {
            file2 = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            file2 = null;
        }
        catch (URISyntaxException e) {
            file2 = null;
        }
        if ((file = file2) == null) {
            URL $this$toFileOrNull_u24lambda_u242 = $this$toFileOrNull;
            boolean bl = false;
            file = !Intrinsics.areEqual($this$toFileOrNull_u24lambda_u242.getProtocol(), FILE_PROTOCOL) ? null : new File($this$toFileOrNull_u24lambda_u242.getFile());
        }
        return file;
    }

    @Nullable
    public static final File toContainingJarOrNull(@NotNull URL $this$toContainingJarOrNull) {
        URLConnection uRLConnection;
        Object object;
        Intrinsics.checkNotNullParameter($this$toContainingJarOrNull, "<this>");
        return Intrinsics.areEqual($this$toContainingJarOrNull.getProtocol(), JAR_PROTOCOL) ? ((object = (uRLConnection = $this$toContainingJarOrNull.openConnection()) instanceof JarURLConnection ? (JarURLConnection)uRLConnection : null) != null && (object = ((JarURLConnection)object).getJarFileURL()) != null ? PathUtilKt.toFileOrNull((URL)object) : null) : null;
    }
}

