/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ProtobufInternalUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoBufUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoBufUtils.class);
    public static final String TMP_DIR_PREFIX = "pinot-protobuf";
    public static final String PB_OUTER_CLASS_SUFFIX = "OuterClass";

    private ProtoBufUtils() {
    }

    public static File getFileCopiedToLocal(String filePath) throws Exception {
        URI fileURI = URI.create(filePath);
        String scheme = fileURI.getScheme();
        if (scheme == null) {
            scheme = "file";
        }
        if (PinotFSFactory.isSchemeSupported((String)scheme)) {
            PinotFS pinotFS = PinotFSFactory.create((String)scheme);
            Path localTmpDir = Files.createTempDirectory(TMP_DIR_PREFIX + System.currentTimeMillis(), new FileAttribute[0]);
            File localFile = ProtoBufUtils.createLocalFile(fileURI, localTmpDir.toFile());
            LOGGER.info("Copying protocol buffer jar/descriptor file from source: {} to dst: {}", (Object)filePath, (Object)localFile.getAbsolutePath());
            pinotFS.copyToLocalFile(fileURI, localFile);
            return localFile;
        }
        throw new RuntimeException(String.format("Scheme: %s not supported in PinotFSFactory for protocol buffer jar/descriptor file: %s.", scheme, filePath));
    }

    public static InputStream getDescriptorFileInputStream(String descriptorFilePath) throws Exception {
        return new FileInputStream(ProtoBufUtils.getFileCopiedToLocal(descriptorFilePath));
    }

    public static File createLocalFile(URI srcURI, File dstDir) {
        String sourceURIPath = srcURI.getPath();
        File dstFile = new File(dstDir, new File(sourceURIPath).getName());
        LOGGER.debug("Created empty local temporary file {} to copy protocol buffer descriptor {}", (Object)dstFile.getAbsolutePath(), (Object)srcURI);
        return dstFile;
    }

    public static String getFullJavaName(Descriptors.Descriptor descriptor) {
        String prefix = null != descriptor.getContainingType() ? ProtoBufUtils.getFullJavaName(descriptor.getContainingType()) : ProtoBufUtils.getOuterProtoPrefix(descriptor.getFile());
        return prefix + "." + descriptor.getName();
    }

    public static String getFullJavaNameForEnum(Descriptors.EnumDescriptor enumDescriptor) {
        if (null != enumDescriptor.getContainingType()) {
            return ProtoBufUtils.getFullJavaName(enumDescriptor.getContainingType()) + "." + enumDescriptor.getName();
        }
        String outerProtoName = ProtoBufUtils.getOuterProtoPrefix(enumDescriptor.getFile());
        return outerProtoName + "." + enumDescriptor.getName();
    }

    public static String getOuterProtoPrefix(Descriptors.FileDescriptor fileDescriptor) {
        String javaPackageName;
        String string = javaPackageName = fileDescriptor.getOptions().hasJavaPackage() ? fileDescriptor.getOptions().getJavaPackage() : fileDescriptor.getPackage();
        if (fileDescriptor.getOptions().getJavaMultipleFiles()) {
            return javaPackageName;
        }
        if (fileDescriptor.getOptions().hasJavaOuterClassname()) {
            return javaPackageName + "." + fileDescriptor.getOptions().hasJavaOuterClassname();
        }
        String[] fileNames = fileDescriptor.getName().split("/");
        String fileName = fileNames[fileNames.length - 1];
        String outerName = ProtobufInternalUtils.underScoreToCamelCase(fileName.split("\\.")[0], true);
        if (ProtoBufUtils.hasTypeWithName(fileDescriptor.getMessageTypes(), outerName) || ProtoBufUtils.hasTypeWithName(fileDescriptor.getEnumTypes(), outerName) || ProtoBufUtils.hasTypeWithName(fileDescriptor.getServices(), outerName)) {
            return javaPackageName + "." + outerName + PB_OUTER_CLASS_SUFFIX;
        }
        return javaPackageName + "." + outerName;
    }

    private static boolean hasTypeWithName(Iterable<? extends Descriptors.GenericDescriptor> descriptors, String name) {
        for (Descriptors.GenericDescriptor genericDescriptor : descriptors) {
            if (!genericDescriptor.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String getTypeStrFromProto(Descriptors.FieldDescriptor desc) {
        switch (desc.getJavaType()) {
            case INT: {
                return "Integer";
            }
            case LONG: {
                return "Long";
            }
            case STRING: {
                return "String";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case BYTE_STRING: {
                return "ByteString";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case ENUM: {
                return ProtoBufUtils.getFullJavaNameForEnum(desc.getEnumType());
            }
            case MESSAGE: {
                if (desc.isMapField()) {
                    Descriptors.FieldDescriptor key = desc.getMessageType().findFieldByName("key");
                    Descriptors.FieldDescriptor value = desc.getMessageType().findFieldByName("value");
                    String keyTypeStr = ProtoBufUtils.getTypeStrFromProto(key);
                    String valueTypeStr = ProtoBufUtils.getTypeStrFromProto(value);
                    return "Map<" + keyTypeStr + "," + valueTypeStr + ">";
                }
                return ProtoBufUtils.getFullJavaName(desc.getMessageType());
            }
        }
        throw new RuntimeException("do not support field type: " + String.valueOf((Object)desc.getJavaType()));
    }
}

