/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfiguredRMFailoverProxyProvider<T>
implements RMFailoverProxyProvider<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfiguredRMFailoverProxyProvider.class);
    private int currentProxyIndex = 0;
    Map<String, T> proxies = new HashMap<String, T>();
    protected RMProxy<T> rmProxy;
    protected Class<T> protocol;
    protected YarnConfiguration conf;
    protected String[] rmServiceIds;

    @Override
    public void init(Configuration configuration, RMProxy<T> rmProxy, Class<T> protocol) {
        this.rmProxy = rmProxy;
        this.protocol = protocol;
        this.rmProxy.checkAllowedProtocols(this.protocol);
        this.conf = new YarnConfiguration(configuration);
        Collection<String> rmIds = this.getRMIds(this.conf);
        this.rmServiceIds = rmIds.toArray(new String[rmIds.size()]);
        this.conf.set("yarn.resourcemanager.ha.id", this.rmServiceIds[this.currentProxyIndex]);
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt("yarn.client.failover-retries", 0));
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.conf.getInt("yarn.client.failover-retries-on-socket-timeouts", 0));
    }

    protected T getProxyInternal() {
        try {
            InetSocketAddress rmAddress = this.rmProxy.getRMAddress(this.conf, this.protocol);
            return this.rmProxy.getProxy(this.conf, this.protocol, rmAddress);
        }
        catch (IOException ioe) {
            LOG.error("Unable to create proxy to the ResourceManager " + this.rmServiceIds[this.currentProxyIndex], ioe);
            return null;
        }
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        String rmId = this.rmServiceIds[this.currentProxyIndex];
        T current = this.proxies.get(rmId);
        if (current == null) {
            current = this.getProxyInternal();
            this.proxies.put(rmId, current);
        }
        return new FailoverProxyProvider.ProxyInfo(current, rmId);
    }

    public synchronized void performFailover(T currentProxy) {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.rmServiceIds.length;
        this.conf.set("yarn.resourcemanager.ha.id", this.rmServiceIds[this.currentProxyIndex]);
        LOG.info("Failing over to " + this.rmServiceIds[this.currentProxyIndex]);
    }

    public Class<T> getInterface() {
        return this.protocol;
    }

    public synchronized void close() throws IOException {
        for (T proxy : this.proxies.values()) {
            if (proxy instanceof Closeable) {
                ((Closeable)proxy).close();
                continue;
            }
            RPC.stopProxy(proxy);
        }
    }

    private Collection<String> getRMIds(Configuration pConfiguration) {
        boolean isFederationEnabled = HAUtil.isFederationEnabled(pConfiguration);
        if (!isFederationEnabled) {
            return HAUtil.getRMHAIds(pConfiguration);
        }
        return this.getRandomOrderByRandomFlag(pConfiguration);
    }

    private Collection<String> getRandomOrderByRandomFlag(Configuration pConfiguration) {
        Collection<String> rmIds = HAUtil.getRMHAIds(pConfiguration);
        boolean isRandomOrder = pConfiguration.getBoolean("yarn.federation.failover.random.order", false);
        if (!isRandomOrder) {
            return rmIds;
        }
        ArrayList<String> rmIdList = new ArrayList<String>(rmIds);
        Collections.shuffle(rmIdList);
        return rmIdList;
    }
}

