/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.spark;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.plugin.ingestion.batch.spark.common.BaseSparkSegmentTarPushJobRunner;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.VoidFunction;

public class SparkSegmentTarPushJobRunner
extends BaseSparkSegmentTarPushJobRunner {
    private SegmentGenerationJobSpec _spec;

    public SparkSegmentTarPushJobRunner() {
    }

    public SparkSegmentTarPushJobRunner(SegmentGenerationJobSpec spec) {
        super(spec);
    }

    @Override
    public void parallelizeTarPushJob(final List<PinotFSSpec> pinotFSSpecs, List<String> segmentUris, int pushParallelism, URI outputDirURI) {
        JavaSparkContext sparkContext = JavaSparkContext.fromSparkContext((SparkContext)SparkContext.getOrCreate());
        JavaRDD pathRDD = sparkContext.parallelize(segmentUris, pushParallelism);
        final URI finalOutputDirURI = outputDirURI;
        pathRDD.foreach((VoidFunction)new VoidFunction<String>(){

            public void call(String segmentTarPath) throws Exception {
                PluginManager.get().init();
                for (PinotFSSpec pinotFSSpec : pinotFSSpecs) {
                    PinotFSFactory.register((String)pinotFSSpec.getScheme(), (String)pinotFSSpec.getClassName(), (PinotConfiguration)new PinotConfiguration(pinotFSSpec));
                }
                try {
                    SegmentPushUtils.pushSegments((SegmentGenerationJobSpec)SparkSegmentTarPushJobRunner.this._spec, (PinotFS)PinotFSFactory.create((String)finalOutputDirURI.getScheme()), Arrays.asList(segmentTarPath));
                }
                catch (AttemptsExceededException | RetriableOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

